/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.transports.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.CarbonUtils;

public class DBSFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".dbs"};

    @Override
    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        PrintWriter out = response.getWriter();
        if (CarbonUtils.isURL((String)axis2Repo)) {
            out.write("<script type=\"text/javascript\">alert('You are not permitted to upload services to URL repository " + axis2Repo + "');</script>");
            out.flush();
            return false;
        }
        response.setContentType("text/html; charset=utf-8");
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        if (isMultipart) {
            try {
                List items = this.parseRequest(servletRequestContext);
                Iterator iter = items.iterator();
                if (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    if (!item.isFormField()) {
                        String fileName;
                        String fileExtension = fileName = item.getName();
                        fileExtension = fileExtension.toLowerCase();
                        this.checkServiceFileExtensionValidity(fileExtension, ALLOWED_FILE_EXTENSIONS);
                        String fileNameOnly = this.getFileName(fileName);
                        if (fileExtension.endsWith(".dbs")) {
                            String repo = this.configurationContext.getAxisConfiguration().getRepository().getPath();
                            if (!fileExtension.endsWith(".dbs")) {
                                throw new CarbonException("File with extension " + fileExtension + " is not supported!");
                            }
                            String finalFolderName = "dataservices";
                            File servicesDir = new File(repo, finalFolderName);
                            if (!servicesDir.exists()) {
                                servicesDir.mkdir();
                            }
                            File uploadedFile = new File(servicesDir, fileNameOnly);
                            item.write(uploadedFile);
                            out.write("<script type=\"text/javascript\" src=\"../main/admin/js/main.js\"></script>");
                            out.write("<script type=\"text/javascript\">alert('File uploaded successfully');loadServiceListingPage();</script>");
                        }
                    }
                    return true;
                }
            }
            catch (Exception e) {
                log.error((Object)"File upload failed", (Throwable)e);
                out.write("<script type=\"text/javascript\" src=\"../ds/extensions/core/js/data_service.js\"></script>");
                out.write("<script type=\"text/javascript\">alert('Service file upload FAILED. You will be redirected to file upload screen.');loadDBSFileUploadPage();</script>");
            }
        }
        return false;
    }
}

