/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.commons.stub.filedownload.FileDownloadServiceStub;
import org.wso2.carbon.core.util.MIMEType2FileExtensionMap;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class FileDownloadUtil {
    private static Log log = LogFactory.getLog(FileDownloadUtil.class);
    private MIMEType2FileExtensionMap mimeMap = new MIMEType2FileExtensionMap();

    public FileDownloadUtil(BundleContext context) {
        this.mimeMap.init(context);
    }

    private String sanitize(String input) {
        if (input.isEmpty()) {
            return input;
        }
        return input.replaceAll("(\\r|\\n|%0D|%0A|%0a|%0d)", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean acquireResource(ConfigurationContextService configCtxService, HttpServletRequest request, HttpServletResponse response) throws CarbonException {
        ServletOutputStream out;
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            String msg = "Unable to retrieve file ";
            log.error((Object)msg, (Throwable)e);
            throw new CarbonException(msg, (Throwable)e);
        }
        String fileID = this.sanitize(request.getParameter("id"));
        String fileName = this.getFileName(configCtxService, request, fileID);
        if (fileName == null) {
            String serverURL = CarbonUIUtil.getServerURL(request.getSession().getServletContext(), request.getSession());
            String serviceEPR = serverURL + "FileDownloadService";
            try {
                FileDownloadServiceStub stub = CarbonUtils.isRunningOnLocalTransportMode() ? new FileDownloadServiceStub(configCtxService.getServerConfigContext(), serviceEPR) : new FileDownloadServiceStub(configCtxService.getClientConfigContext(), serviceEPR);
                DataHandler dataHandler = stub.downloadFile(fileID);
                if (dataHandler != null) {
                    response.setHeader("Content-Disposition", "filename=" + fileID);
                    response.setContentType(dataHandler.getContentType());
                    try (InputStream in = dataHandler.getDataSource().getInputStream();){
                        int nextChar;
                        while ((nextChar = in.read()) != -1) {
                            out.write((char)nextChar);
                        }
                        out.flush();
                    }
                    finally {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            log.error((Object)"Error while closing OutputStream", (Throwable)e);
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                out.write("The requested file was not found on the server".getBytes());
                out.flush();
            }
            catch (IOException e) {
                String msg = "Unable to write output to HttpServletResponse OutputStream ";
                log.error((Object)msg, (Throwable)e);
                throw new CarbonException(msg, (Throwable)e);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing OutputStream", (Throwable)e);
                }
            }
            return false;
        }
        File file = new File(fileName);
        try {
            boolean bl;
            FileInputStream in = new FileInputStream(file);
            try {
                byte[] b = new byte[(int)file.length()];
                response.setContentType(this.mimeMap.getMIMEType(file));
                response.setContentLength((int)file.length());
                response.setHeader("Content-Disposition", "filename=" + file.getName());
                int lengthRead = in.read(b);
                if (lengthRead != -1) {
                    out.write(b);
                }
                out.flush();
                bl = true;
            }
            catch (Throwable b) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        b.addSuppressed(throwable);
                    }
                    throw b;
                }
                catch (IOException e) {
                    String msg = "Unable to retrieve file ";
                    log.error((Object)msg, (Throwable)e);
                    throw new CarbonException(msg, (Throwable)e);
                }
            }
            in.close();
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)("Couldn;t close the Outputstream " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private String getFileName(ConfigurationContextService configCtxService, HttpServletRequest request, String fileID) {
        Map fileResourcesMap = (Map)configCtxService.getClientConfigContext().getProperty("file.resource.map");
        String fileName = (String)fileResourcesMap.get(fileID);
        if (fileName == null) {
            String requestURI = request.getRequestURI();
            ConfigurationContext configContext = configCtxService.getServerConfigContext();
            fileResourcesMap = (Map)configContext.getProperty("file.resource.map");
            fileName = (String)fileResourcesMap.get(fileID);
        }
        return fileName;
    }
}

