/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.tracker;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.tracker.AuthenticatorComparator;

public class AuthenticatorRegistry {
    private static Log log = LogFactory.getLog(AuthenticatorRegistry.class);
    private static ServiceTracker authTracker;
    private static CarbonUIAuthenticator[] authenticators;
    private static Object lock;
    public static final String AUTHENTICATOR_TYPE = "authenticator.type";

    public static void init(BundleContext bc) throws Exception {
        try {
            authTracker = new ServiceTracker(bc, CarbonUIAuthenticator.class.getName(), null);
            authTracker.open();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CarbonUIAuthenticator getCarbonAuthenticator(HttpServletRequest request) {
        CarbonUIAuthenticator[] carbonUIAuthenticatorArray;
        HttpSession session = request.getSession();
        CarbonUIAuthenticator authenticator = (CarbonUIAuthenticator)session.getAttribute("CarbonAuthenticator");
        if (authenticator != null) {
            return authenticator;
        }
        if (authenticators == null || authenticators.length == 0 || authenticators[0] == null) {
            carbonUIAuthenticatorArray = lock;
            // MONITORENTER : lock
            if (authenticators == null || authenticators.length == 0 || authenticators[0] == null) {
                Object[] objects = authTracker.getServices();
                authenticators = new CarbonUIAuthenticator[objects.length];
                int i = 0;
                Object[] objectArray = objects;
                int n = objectArray.length;
                for (int j = 0; j < n; ++i, ++j) {
                    Object obj = objectArray[j];
                    AuthenticatorRegistry.authenticators[i] = (CarbonUIAuthenticator)obj;
                }
                Arrays.sort(authenticators, new AuthenticatorComparator());
            }
            // MONITOREXIT : carbonUIAuthenticatorArray
        }
        carbonUIAuthenticatorArray = authenticators;
        int n = carbonUIAuthenticatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CarbonUIAuthenticator auth = carbonUIAuthenticatorArray[n2];
            if (!auth.isDisabled() && auth.canHandle(request)) {
                session.setAttribute("CarbonAuthenticator", (Object)auth);
                return auth;
            }
            ++n2;
        }
        return null;
    }

    static {
        lock = new Object();
    }
}

