/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.transports.fileupload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.common.UploadedFileItem;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.clients.FileUploadServiceClient;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;
import org.wso2.carbon.ui.transports.fileupload.FileSizeLimitExceededException;
import org.wso2.carbon.ui.transports.fileupload.FileUploadFailedException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileItemData;
import org.wso2.carbon.utils.FileManipulator;

public abstract class AbstractFileUploadExecutor {
    protected static final Log log = LogFactory.getLog(AbstractFileUploadExecutor.class);
    protected ConfigurationContext configurationContext;
    private ThreadLocal<Map<String, ArrayList<FileItemData>>> fileItemsMap = new ThreadLocal();
    private ThreadLocal<Map<String, ArrayList<String>>> formFieldsMap = new ThreadLocal();
    private static final int DEFAULT_TOTAL_FILE_SIZE_LIMIT_IN_MB = 100;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private long totalFileUploadSizeLimit = this.getFileSizeLimit();

    public abstract boolean execute(HttpServletRequest var1, HttpServletResponse var2) throws CarbonException, IOException;

    protected AbstractFileUploadExecutor() {
    }

    private long getFileSizeLimit() {
        String totalFileSizeLimitInBytes = CarbonUIServiceComponent.getServerConfiguration().getFirstProperty("FileUploadConfig.TotalFileSizeLimit");
        return totalFileSizeLimitInBytes != null ? Long.parseLong(totalFileSizeLimitInBytes) * 1024L * 1024L : 0x6400000L;
    }

    boolean executeGeneric(HttpServletRequest request, HttpServletResponse response, ConfigurationContext configurationContext) throws IOException {
        this.configurationContext = configurationContext;
        try {
            this.parseRequest(request);
            return this.execute(request, response);
        }
        catch (FileUploadFailedException e) {
            this.sendErrorRedirect(request, response, e);
        }
        catch (FileSizeLimitExceededException e) {
            this.sendErrorRedirect(request, response, e);
        }
        catch (CarbonException e) {
            this.sendErrorRedirect(request, response, (Exception)((Object)e));
        }
        return false;
    }

    private void sendErrorRedirect(HttpServletRequest request, HttpServletResponse response, Exception e) throws IOException {
        String errorRedirectionPage = this.getErrorRedirectionPage();
        if (errorRedirectionPage == null) {
            throw new IOException("Could not send error. Please define the errorRedirectionPage in your UI page. " + e.getMessage());
        }
        CarbonUIMessage.sendCarbonUIMessage(e.getMessage(), "error", request, response, errorRedirectionPage);
    }

    protected String getErrorRedirectionPage() {
        List<String> errRedirValues = this.getFormFieldValue("errorRedirectionPage");
        String errorRedirectionPage = null;
        if (errRedirValues != null && !errRedirValues.isEmpty()) {
            errorRedirectionPage = errRedirValues.get(0);
        }
        return errorRedirectionPage;
    }

    protected void parseRequest(HttpServletRequest request) throws FileUploadFailedException, FileSizeLimitExceededException {
        this.fileItemsMap.set(new HashMap());
        this.formFieldsMap.set(new HashMap());
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        Long totalFileSize = 0L;
        if (isMultipart) {
            List items;
            try {
                items = this.parseRequest(servletRequestContext);
            }
            catch (FileUploadException e) {
                String msg = "File upload failed";
                log.error((Object)msg, (Throwable)e);
                throw new FileUploadFailedException(msg, e);
            }
            boolean multiItems = false;
            if (items.size() > 1) {
                multiItems = true;
            }
            for (FileItem item : items) {
                String fieldName = item.getFieldName().trim();
                if (item.isFormField()) {
                    if (this.formFieldsMap.get().get(fieldName) == null) {
                        this.formFieldsMap.get().put(fieldName, new ArrayList());
                    }
                    try {
                        this.formFieldsMap.get().get(fieldName).add(new String(item.get(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    continue;
                }
                String fileName = item.getName();
                if ((fileName == null || fileName.length() == 0) && multiItems) continue;
                if (this.fileItemsMap.get().get(fieldName) == null) {
                    this.fileItemsMap.get().put(fieldName, new ArrayList());
                }
                if ((totalFileSize = Long.valueOf(totalFileSize + item.getSize())) < this.totalFileUploadSizeLimit) {
                    this.fileItemsMap.get().get(fieldName).add(new FileItemData(item));
                    continue;
                }
                throw new FileSizeLimitExceededException(this.getFileSizeLimit() / 1024L / 1024L);
            }
        }
    }

    protected String getWorkingDir() {
        return (String)this.configurationContext.getProperty("WORK_DIR");
    }

    protected String generateUUID() {
        return String.valueOf((double)System.currentTimeMillis() + Math.random());
    }

    protected String getFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        return this.requireNonNullChars(fileName).substring(this.indexOfLastSeparator(fileName) + 1);
    }

    private int indexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    private String requireNonNullChars(String path) {
        if (path.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
        return path;
    }

    protected List parseRequest(ServletRequestContext requestContext) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        return upload.parseRequest((RequestContext)requestContext);
    }

    protected void checkServiceFileExtensionValidity(String fileExtension, String[] allowedExtensions) throws FileUploadException {
        boolean isExtensionValid = false;
        StringBuffer allowedExtensionsStr = new StringBuffer();
        for (String allowedExtension : allowedExtensions) {
            allowedExtensionsStr.append(allowedExtension).append(",");
            if (!fileExtension.endsWith(allowedExtension)) continue;
            isExtensionValid = true;
            break;
        }
        if (!isExtensionValid) {
            throw new FileUploadException(" Illegal file type. Allowed file extensions are " + allowedExtensionsStr);
        }
    }

    protected File uploadFile(HttpServletRequest request, String repoDir, HttpServletResponse response, String extension) throws FileUploadException {
        response.setContentType("text/html; charset=utf-8");
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        File uploadedFile = null;
        if (isMultipart) {
            try {
                List items = this.parseRequest(servletRequestContext);
                for (FileItem item : items) {
                    String fileName;
                    if (item.isFormField()) continue;
                    String fileExtension = fileName = item.getName();
                    fileExtension = fileExtension.toLowerCase();
                    if (extension != null && !fileExtension.endsWith(extension)) {
                        throw new Exception(" Illegal file type. Only " + extension + " files can be uploaded");
                    }
                    String fileNameOnly = this.getFileName(fileName);
                    uploadedFile = new File(repoDir, fileNameOnly);
                    item.write(uploadedFile);
                }
            }
            catch (Exception e) {
                String msg = "File upload failed";
                log.error((Object)msg, (Throwable)e);
                throw new FileUploadException(msg, (Throwable)e);
            }
        }
        return uploadedFile;
    }

    protected boolean executeCommon(HttpServletRequest request, HttpServletResponse response) throws FileUploadException {
        String serverURL = (String)request.getAttribute("ServerURL");
        HttpSession session = request.getSession();
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        try (PrintWriter out = null;){
            out = response.getWriter();
            FileUploadServiceClient client = new FileUploadServiceClient(this.configurationContext, serverURL, cookie);
            response.setContentType("text/plain; charset=utf-8");
            Set<String> keys = this.fileItemsMap.get().keySet();
            boolean multiItems = false;
            if (this.fileItemsMap.get().size() > 1) {
                multiItems = true;
            }
            UploadedFileItem[] uploadedFileItems = new UploadedFileItem[this.fileItemsMap.get().size()];
            Iterator<String> iterator = keys.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                String fieldName = iterator.next();
                String fileName = this.fileItemsMap.get().get(fieldName).get(0).getFileItem().getName();
                if ((fileName == null || fileName.length() == 0) && multiItems) continue;
                FileItemData fileItemData = this.fileItemsMap.get().get(fieldName).get(0);
                UploadedFileItem uploadedFileItem = new UploadedFileItem();
                uploadedFileItem.setDataHandler(fileItemData.getDataHandler());
                uploadedFileItem.setFileName(fileName);
                uploadedFileItem.setFileType("");
                uploadedFileItems[i] = uploadedFileItem;
                ++i;
            }
            String[] uuidArray = client.uploadFiles(uploadedFileItems);
            StringBuffer uuids = new StringBuffer();
            for (String uuid : uuidArray) {
                uuids.append(uuid).append(",");
            }
            out.write(uuids.toString().substring(0, uuids.length() - 1));
            out.flush();
        }
        return true;
    }

    protected boolean uploadArtifacts(HttpServletRequest request, HttpServletResponse response, String uploadDirName, String[] extensions, String utilityString) throws FileUploadException, IOException {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (CarbonUtils.isURL((String)axis2Repo)) {
            String msg = "You are not permitted to upload jars to URL repository";
            throw new FileUploadException(msg);
        }
        String tmpDir = (String)this.configurationContext.getProperty("WORK_DIR");
        String uuid = String.valueOf((double)System.currentTimeMillis() + Math.random());
        File tmpDirFile = new File(tmpDir = tmpDir + File.separator + "artifacts" + File.separator + uuid + File.separator);
        if (!tmpDirFile.exists() && !tmpDirFile.mkdirs()) {
            log.warn((Object)("Could not create " + tmpDirFile.getAbsolutePath()));
        }
        response.setContentType("text/html; charset=utf-8");
        ServletRequestContext servletRequestContext = new ServletRequestContext(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((RequestContext)servletRequestContext);
        if (isMultipart) {
            try (PrintWriter out = null;){
                out = response.getWriter();
                List items = this.parseRequest(servletRequestContext);
                for (FileItem item : items) {
                    File uploadedFile;
                    File servicesDir;
                    String fileName;
                    if (item.isFormField()) continue;
                    String fileExtension = fileName = item.getName();
                    fileExtension = fileExtension.toLowerCase();
                    String fileNameOnly = this.getFileName(fileName);
                    String fieldName = item.getFieldName();
                    if (fieldName != null && fieldName.equals("jarResource")) {
                        if (!fileExtension.endsWith(".jar")) continue;
                        servicesDir = new File(tmpDir + File.separator + uploadDirName, "lib");
                        if (!servicesDir.exists() && !servicesDir.mkdirs()) {
                            log.warn((Object)("Could not create " + servicesDir.getAbsolutePath()));
                        }
                        uploadedFile = new File(servicesDir, fileNameOnly);
                        item.write(uploadedFile);
                        continue;
                    }
                    servicesDir = new File(tmpDir, uploadDirName);
                    if (!servicesDir.exists() && !servicesDir.mkdirs()) {
                        log.warn((Object)("Could not create " + servicesDir.getAbsolutePath()));
                    }
                    uploadedFile = new File(servicesDir, fileNameOnly);
                    item.write(uploadedFile);
                }
                String repo = this.configurationContext.getAxisConfiguration().getRepository().getPath();
                String parent = repo + File.separator + uploadDirName;
                File mainDir = new File(tmpDir + File.separator + uploadDirName);
                File libDir = new File(mainDir, "lib");
                File[] resourceLibFile = FileManipulator.getMatchingFiles((String)libDir.getAbsolutePath(), null, (String)"jar");
                for (File src : resourceLibFile) {
                    String[] files;
                    File dst = new File(parent, "lib");
                    String[] stringArray = files = libDir.list();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String file = stringArray[i];
                        this.copyFile(src, new File(dst, file));
                    }
                }
                for (String extension : extensions) {
                    File[] mainFiles;
                    for (File mainFile : mainFiles = FileManipulator.getMatchingFiles((String)mainDir.getAbsolutePath(), null, (String)extension)) {
                        String[] files;
                        File dst = new File(parent);
                        for (String file : files = mainDir.list()) {
                            File f = new File(dst, file);
                            if (f.isDirectory()) continue;
                            this.copyFile(mainFile, f);
                        }
                    }
                }
                response.sendRedirect(this.getContextRoot(request) + "/carbon/service-mgt/index.jsp?message=Files have been uploaded successfully. This page will be auto refreshed shortly with the status of the created " + utilityString + " service");
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File src, File dst) throws IOException {
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists() && !dir.mkdirs()) {
            log.warn((Object)("Could not create " + dir.getAbsolutePath()));
        }
        DataHandler dh = new DataHandler(src.toURL());
        try (FileOutputStream out = null;){
            out = new FileOutputStream(dst);
            dh.writeTo((OutputStream)out);
            out.flush();
        }
    }

    protected List<FileItemData> getAllFileItems() {
        Collection<ArrayList<FileItemData>> listCollection = this.fileItemsMap.get().values();
        ArrayList<FileItemData> fileItems = new ArrayList<FileItemData>();
        for (ArrayList<FileItemData> fileItemData : listCollection) {
            fileItems.addAll(fileItemData);
        }
        return fileItems;
    }

    protected String getContextRoot(HttpServletRequest request) {
        String contextPath;
        String string = contextPath = request.getContextPath().equals("") ? "" : request.getContextPath();
        if (contextPath.equals("/fileupload")) {
            contextPath = "";
        } else {
            int index = contextPath.indexOf("/fileupload");
            if (index > -1) {
                contextPath = contextPath.substring(0, index);
            }
        }
        String tenantDomain = (String)request.getSession().getAttribute("tenantDomain");
        if (!contextPath.startsWith("/t/") && tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
            contextPath = contextPath + "/" + "t" + "/" + tenantDomain;
            contextPath = contextPath.replaceAll("//", "/");
        }
        return contextPath;
    }

    public List<String> getFormFieldValue(String formFieldName) {
        return this.formFieldsMap.get().get(formFieldName);
    }

    protected Map<String, ArrayList<FileItemData>> getFileItemsMap() {
        return this.fileItemsMap.get();
    }

    protected Map<String, ArrayList<String>> getFormFieldsMap() {
        return this.formFieldsMap.get();
    }
}

