/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.context.internal;

import java.lang.ref.WeakReference;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventContext;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.wso2.carbon.base.DiscoveryService;
import org.wso2.carbon.base.UnloadTenantTask;
import org.wso2.carbon.context.internal.OSGiDataHolder;
import org.wso2.carbon.queuing.CarbonQueue;
import org.wso2.carbon.queuing.CarbonQueueManager;
import org.wso2.carbon.queuing.QueuingException;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserRealmService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantCarbonQueueManager;

public final class CarbonContextDataHolder {
    private static final Log log;
    protected Registry localRepository;
    protected Registry configSystemRegistry;
    protected Registry governanceSystemRegistry;
    protected Registry configUserRegistry;
    protected Registry governanceUserRegistry;
    protected UserRealm userRealm;
    private static final String CARBON_CONTEXT_HOLDER = "carbonContextHolder";
    private int tenantId = -1;
    private static final int CARBON_AUTHENTICATION_UTIL_INDEX = 5;
    private static final String CARBON_AUTHENTICATION_UTIL_CLASS = "org.wso2.carbon.core.services.util.CarbonAuthenticationUtil";
    private static final int CARBON_AUTHENTICATION_HANDLER_INDEX = 5;
    private static final String CARBON_AUTHENTICATION_HANDLER_CLASS = "org.wso2.carbon.server.admin.module.handler.AuthenticationHandler";
    private String username;
    private String userId;
    private String userResidentOrganizationId;
    private String tenantDomain;
    private String organizationId;
    private String applicationName;
    private Map<String, Object> properties;
    private static List<UnloadTenantTask> unloadTenantTasks;
    private static final AtomicReference<DiscoveryService> discoveryServiceProvider;
    private static ThreadLocal<CarbonContextDataHolder> currentContextHolder;
    private static ThreadLocal<Stack<CarbonContextDataHolder>> parentContextHolderStack;

    public Registry getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(Registry localRepository) {
        this.localRepository = localRepository;
    }

    public Registry getConfigSystemRegistry() {
        return this.configSystemRegistry;
    }

    public void setConfigSystemRegistry(Registry configSystemRegistry) {
        this.configSystemRegistry = configSystemRegistry;
    }

    public Registry getGovernanceSystemRegistry() {
        return this.governanceSystemRegistry;
    }

    public void setGovernanceSystemRegistry(Registry governanceSystemRegistry) {
        this.governanceSystemRegistry = governanceSystemRegistry;
    }

    public Registry getConfigUserRegistry() {
        return this.configUserRegistry;
    }

    public void setConfigUserRegistry(Registry configUserRegistry) {
        this.configUserRegistry = configUserRegistry;
    }

    public Registry getGovernanceUserRegistry() {
        return this.governanceUserRegistry;
    }

    public void setGovernanceUserRegistry(Registry governanceUserRegistry) {
        this.governanceUserRegistry = governanceUserRegistry;
    }

    public UserRealm getUserRealm() {
        UserRealmService userRealmService;
        if (this.userRealm == null && (userRealmService = OSGiDataHolder.getInstance().getUserRealmService()) != null) {
            try {
                this.userRealm = userRealmService.getTenantUserRealm(this.tenantId);
            }
            catch (UserStoreException e) {
                log.error((Object)("Cannot retrieve UserRealm for tenant " + this.tenantId), (Throwable)e);
            }
        }
        return this.userRealm;
    }

    public void setUserRealm(UserRealm userRealm) {
        this.userRealm = userRealm;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    private static void setupAuthenticator(CarbonAuthenticator authenticator) throws Exception {
        OMElement documentElement = XMLUtils.toOM((Element)CarbonUtils.getServerConfiguration().getDocumentElement());
        OMElement authenticators = documentElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Security")).getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "NetworkAuthenticatorConfig"));
        if (authenticators == null) {
            return;
        }
        Iterator iterator = authenticators.getChildElements();
        while (iterator.hasNext()) {
            OMElement authenticatorElement = (OMElement)iterator.next();
            if (!authenticatorElement.getLocalName().equalsIgnoreCase("Credential")) continue;
            String pattern = authenticatorElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Pattern")).getText();
            String type = authenticatorElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Type")).getText();
            String username = authenticatorElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Username")).getText();
            String password = authenticatorElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", "Password")).getText();
            authenticator.addAuthenticator(type, pattern, username, password);
        }
    }

    public void unloadTenant() {
        int tenantId = this.getTenantId();
        CarbonContextDataHolder.unloadTenant(tenantId);
    }

    public static CarbonContextDataHolder getThreadLocalCarbonContextHolder() {
        return currentContextHolder.get();
    }

    public void setQueueManager(MultitenantCarbonQueueManager queueManager) throws QueuingException {
        CarbonQueueManager manager = CarbonQueueManager.getInstance();
        if (manager instanceof InternalCarbonQueueManager) {
            ((InternalCarbonQueueManager)manager).setQueueManager(queueManager);
        }
        log.debug((Object)"Successfully set the Queue Manager");
    }

    public void removeQueueManager() throws QueuingException {
        CarbonQueueManager manager = CarbonQueueManager.getInstance();
        if (manager instanceof InternalCarbonQueueManager) {
            ((InternalCarbonQueueManager)manager).removeQueueManager();
        }
        log.debug((Object)"Successfully removed the Queue Manager");
    }

    private static boolean isSubTenant(int tenantId) {
        return tenantId != -1234 && tenantId != -1;
    }

    private static Class<?> classForName(final String className) throws ClassNotFoundException {
        Class cls = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException ignored) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)ignored);
                    }
                    try {
                        return Class.forName(className, true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException ignored2) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)ignored2);
                        }
                        return null;
                    }
                }
            }
        });
        if (cls == null) {
            throw new ClassNotFoundException("class " + className + " not found");
        }
        return cls;
    }

    public static DiscoveryService getDiscoveryServiceProvider() {
        return discoveryServiceProvider.get();
    }

    public static void setDiscoveryServiceProvider(DiscoveryService discoveryServiceProvider) {
        CarbonContextDataHolder.discoveryServiceProvider.set(discoveryServiceProvider);
    }

    public static CarbonContextDataHolder getCurrentCarbonContextHolderBase() {
        return currentContextHolder.get();
    }

    public static synchronized void registerUnloadTenantTask(UnloadTenantTask unloadTenantTask) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unload Tenant Task: " + unloadTenantTask.getClass().getName() + " was registered."));
        }
        unloadTenantTasks.add(unloadTenantTask);
    }

    public static void unloadTenant(int tenantId) {
        log.debug((Object)"Started unloading tenant");
        for (UnloadTenantTask unloadTenantTask : unloadTenantTasks) {
            unloadTenantTask.cleanup(tenantId);
        }
        log.info((Object)"Completed unloading tenant");
    }

    public void startTenantFlow() {
        Stack<CarbonContextDataHolder> carbonContextDataHolders = parentContextHolderStack.get();
        if (carbonContextDataHolders == null) {
            carbonContextDataHolders = new Stack();
            parentContextHolderStack.set(carbonContextDataHolders);
        }
        carbonContextDataHolders.push(currentContextHolder.get());
        currentContextHolder.remove();
    }

    public void endTenantFlow() {
        Stack<CarbonContextDataHolder> carbonContextDataHolders = parentContextHolderStack.get();
        if (carbonContextDataHolders != null) {
            currentContextHolder.set(carbonContextDataHolders.pop());
        }
    }

    private CarbonContextDataHolder() {
        this.tenantId = -1;
        this.username = null;
        this.tenantDomain = null;
    }

    public CarbonContextDataHolder(CarbonContextDataHolder carbonContextHolder) {
        this.tenantId = carbonContextHolder.tenantId;
        this.username = carbonContextHolder.username;
        this.tenantDomain = carbonContextHolder.tenantDomain;
        if (carbonContextHolder.properties != null) {
            this.properties = new HashMap<String, Object>(carbonContextHolder.properties);
        }
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        StackTraceElement[] traces;
        if (this.tenantId == -1 || this.tenantId == -1234) {
            this.tenantId = tenantId;
        } else if (this.tenantId != tenantId && !this.isAllowedToChangeTenantDomain(traces = Thread.currentThread().getStackTrace())) {
            throw new IllegalStateException("Trying to set the domain from " + this.tenantId + " to " + tenantId);
        }
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        CarbonUtils.checkSecurity();
        this.organizationId = organizationId;
    }

    public String getUserResidentOrganizationId() {
        return this.userResidentOrganizationId;
    }

    public void setUserResidentOrganizationId(String userResidentOrganizationId) {
        CarbonUtils.checkSecurity();
        this.userResidentOrganizationId = userResidentOrganizationId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        CarbonUtils.checkSecurity();
        this.username = username;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        CarbonUtils.checkSecurity();
        this.userId = userId;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String domain) {
        try {
            StackTraceElement[] traces;
            if (this.tenantDomain == null || this.tenantDomain.equals("carbon.super")) {
                this.tenantDomain = domain;
            } else if (!this.tenantDomain.equals(domain) && !this.isAllowedToChangeTenantDomain(traces = Thread.currentThread().getStackTrace())) {
                throw new IllegalStateException("Trying to set the domain from " + this.tenantDomain + " to " + domain);
            }
        }
        catch (IllegalStateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    private void cleanupProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    private boolean isAllowedToChangeTenantDomain(StackTraceElement[] traces) {
        boolean allowChange = false;
        if (traces.length > 5 && traces[5].getClassName().equals(CARBON_AUTHENTICATION_UTIL_CLASS)) {
            allowChange = true;
        } else if (traces.length > 5 && traces[5].getClassName().equals(CARBON_AUTHENTICATION_HANDLER_CLASS)) {
            allowChange = true;
        }
        return allowChange;
    }

    public static void destroyCurrentCarbonContextHolder() {
        currentContextHolder.remove();
        parentContextHolderStack.remove();
    }

    static {
        block16: {
            block15: {
                log = LogFactory.getLog(CarbonContextDataHolder.class);
                unloadTenantTasks = null;
                discoveryServiceProvider = new AtomicReference();
                currentContextHolder = new ThreadLocal<CarbonContextDataHolder>(){

                    @Override
                    protected CarbonContextDataHolder initialValue() {
                        return new CarbonContextDataHolder();
                    }
                };
                parentContextHolderStack = new ThreadLocal();
                try {
                    log.debug((Object)"Started Setting up Authenticator Configuration");
                    CarbonAuthenticator authenticator = new CarbonAuthenticator();
                    try {
                        CarbonContextDataHolder.setupAuthenticator(authenticator);
                    }
                    finally {
                        String username = System.getProperty("http.proxyUser");
                        String password = System.getProperty("http.proxyPassword");
                        if (username != null && password != null) {
                            authenticator.addAuthenticator("proxy", ".*", username, password);
                        }
                        Authenticator.setDefault(authenticator);
                    }
                    log.debug((Object)"Completed Setting up Authenticator Configuration");
                }
                catch (NoClassDefFoundError ignore) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"There can be situations where the CarbonContext is accessed, when there is no Axis2library on the classpath.", (Throwable)ignore);
                    }
                }
                catch (Exception e) {
                    String msg = "Unable to read Server Configuration";
                    log.error((Object)msg, (Throwable)e);
                }
                unloadTenantTasks = new LinkedList<UnloadTenantTask>();
                CarbonContextDataHolder.registerUnloadTenantTask(new CarbonContextCleanupTask());
                try {
                    CarbonQueueManager.setInstance((CarbonQueueManager)new InternalCarbonQueueManager());
                }
                catch (RuntimeException ignore) {
                    if (!log.isDebugEnabled()) break block15;
                    log.debug((Object)"there can be a possibility of the same class loading twice and then trying to reset the initial context factory builder", (Throwable)ignore);
                }
            }
            try {
                NamingManager.setInitialContextFactoryBuilder(new CarbonInitialJNDIContextFactoryBuilder());
            }
            catch (NamingException ignore) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"there can be a possibility of the same class loading twice and then trying to reset the initial context factory builder", (Throwable)ignore);
                }
            }
            catch (RuntimeException ignore) {
                if (!log.isDebugEnabled()) break block16;
                log.debug((Object)"there can be a possibility of the same class loading twice and then trying to reset the initial context factory builder", (Throwable)ignore);
            }
        }
    }

    private static class CarbonContextCleanupTask
    implements UnloadTenantTask<CarbonContextDataHolder> {
        private Map<Integer, ArrayList<WeakReference<CarbonContextDataHolder>>> contextHolderList = new ConcurrentHashMap<Integer, ArrayList<WeakReference<CarbonContextDataHolder>>>();

        private CarbonContextCleanupTask() {
        }

        public void register(int tenantId, CarbonContextDataHolder contextHolderBase) {
            ArrayList<WeakReference<CarbonContextDataHolder>> list = this.contextHolderList.get(tenantId);
            if (list == null) {
                list = new ArrayList();
                list.add(new WeakReference<CarbonContextDataHolder>(contextHolderBase));
                this.contextHolderList.put(tenantId, list);
            } else {
                list.add(new WeakReference<CarbonContextDataHolder>(contextHolderBase));
            }
        }

        public void cleanup(int tenantId) {
            ArrayList<WeakReference<CarbonContextDataHolder>> list = this.contextHolderList.remove(tenantId);
            if (list != null) {
                for (WeakReference<CarbonContextDataHolder> carbonContextHolderBaseRef : list) {
                    CarbonContextDataHolder carbonContextHolderBase = (CarbonContextDataHolder)carbonContextHolderBaseRef.get();
                    if (carbonContextHolderBase == null) continue;
                    carbonContextHolderBase.cleanupProperties();
                }
                list.clear();
            }
        }
    }

    private static class CarbonAuthenticator
    extends Authenticator {
        private List<AuthenticatorBean> proxyAuthenticators = new LinkedList<AuthenticatorBean>();
        private List<AuthenticatorBean> serverAuthenticators = new LinkedList<AuthenticatorBean>();

        private CarbonAuthenticator() {
        }

        public void addAuthenticator(String type, String regEx, String username, String password) {
            if (type.equalsIgnoreCase("proxy")) {
                this.proxyAuthenticators.add(new AuthenticatorBean(regEx, username, password));
            } else if (type.equalsIgnoreCase("server")) {
                this.serverAuthenticators.add(new AuthenticatorBean(regEx, username, password));
            }
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            block3: {
                block2: {
                    if (!Authenticator.RequestorType.PROXY.equals((Object)this.getRequestorType())) break block2;
                    for (AuthenticatorBean authenticator : this.proxyAuthenticators) {
                        if (!authenticator.matches(this.getRequestingProtocol(), this.getRequestingHost(), this.getRequestingPort()) && !authenticator.matches(this.getRequestingURL())) continue;
                        return authenticator.getPasswordAuthentication();
                    }
                    break block3;
                }
                if (!Authenticator.RequestorType.SERVER.equals((Object)this.getRequestorType())) break block3;
                for (AuthenticatorBean authenticator : this.serverAuthenticators) {
                    if (!authenticator.matches(this.getRequestingScheme(), this.getRequestingHost(), this.getRequestingPort()) && !authenticator.matches(this.getRequestingURL())) continue;
                    return authenticator.getPasswordAuthentication();
                }
            }
            return super.getPasswordAuthentication();
        }

        private static class AuthenticatorBean {
            private Pattern pattern;
            private PasswordAuthentication credential;

            public AuthenticatorBean(String regEx, String username, String password) {
                this.pattern = Pattern.compile(regEx);
                this.credential = new PasswordAuthentication(username, password.toCharArray());
            }

            public PasswordAuthentication getPasswordAuthentication() {
                return this.credential;
            }

            public boolean matches(String protocol, String host, int port) {
                return this.pattern.matcher((protocol + "://" + host + ':' + port).toLowerCase()).matches();
            }

            public boolean matches(URL url) {
                return this.pattern.matcher(url.toString()).matches();
            }
        }
    }

    private static class CarbonInitialJNDIContext
    implements EventDirContext,
    LdapContext {
        private Context initialContext;
        private Map<String, Context> contextCache = Collections.synchronizedMap(new HashMap());
        private static ContextCleanupTask contextCleanupTask = new ContextCleanupTask();
        private static List<String> superTenantOnlyUrlContextSchemes;
        private static List<String> allTenantUrlContextSchemes;

        public CarbonInitialJNDIContext(Context initialContext) throws NamingException {
            this.initialContext = initialContext;
        }

        private static String getScheme(String url) {
            if (null == url) {
                return null;
            }
            int colPos = url.indexOf(58);
            if (colPos < 0) {
                return null;
            }
            String scheme = url.substring(0, colPos);
            for (int i = 0; i < scheme.length(); ++i) {
                boolean inCharSet;
                char c = scheme.charAt(i);
                boolean bl = inCharSet = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '+' || c == '.' || c == '-' || c == '_';
                if (inCharSet) continue;
                return null;
            }
            return scheme;
        }

        private Context getInitialContext(Name name) {
            return this.getInitialContext(name.get(0));
        }

        private Context getInitialContext() {
            return this.getInitialContext((String)null);
        }

        private boolean isBaseContextRequested() {
            try {
                String baseContextRequested = (String)this.initialContext.getEnvironment().get("org.wso2.carbon.context.RequestBaseContext");
                if (baseContextRequested != null && baseContextRequested.equals("true")) {
                    return true;
                }
            }
            catch (NamingException e) {
                log.warn((Object)"An error occurred while retrieving environment properties from initial context.", (Throwable)e);
            }
            return false;
        }

        private Context getInitialContext(String name) {
            Context subContext;
            String tenantContextName;
            int tenantId;
            Context base;
            block20: {
                String scheme;
                block19: {
                    if (this.isBaseContextRequested()) {
                        return this.initialContext;
                    }
                    base = null;
                    scheme = null;
                    if (name != null && (scheme = CarbonInitialJNDIContext.getScheme(name)) != null) {
                        if (this.contextCache.containsKey(scheme)) {
                            base = this.contextCache.get(scheme);
                        } else {
                            try {
                                Context urlContext;
                                if (!this.initialContext.getEnvironment().containsKey("java.naming.factory.url.pkgs")) {
                                    String pkgValue = System.getProperty("java.naming.factory.url.pkgs");
                                    this.initialContext.addToEnvironment("java.naming.factory.url.pkgs", pkgValue);
                                }
                                if ((urlContext = NamingManager.getURLContext(scheme, this.initialContext.getEnvironment())) != null) {
                                    this.contextCache.put(scheme, urlContext);
                                    base = urlContext;
                                }
                            }
                            catch (NamingException ignored) {
                                if (!log.isDebugEnabled()) break block19;
                                log.debug((Object)"If we are unable to find the context, we use the default context.", (Throwable)ignored);
                            }
                        }
                    }
                }
                if (base == null) {
                    base = this.initialContext;
                    scheme = null;
                }
                if (!CarbonContextDataHolder.isSubTenant(tenantId = CarbonContextDataHolder.getThreadLocalCarbonContextHolder().getTenantId())) {
                    return base;
                }
                if (scheme != null) {
                    if (allTenantUrlContextSchemes.contains(scheme)) {
                        return base;
                    }
                    if (superTenantOnlyUrlContextSchemes.contains(scheme)) {
                        throw new SecurityException("Tenants are not allowed to use JNDI contexts with scheme: " + scheme);
                    }
                }
                tenantContextName = Integer.toString(tenantId);
                try {
                    subContext = (Context)base.lookup(tenantContextName);
                    if (subContext != null) {
                        return subContext;
                    }
                }
                catch (NamingException ignored) {
                    if (!log.isDebugEnabled()) break block20;
                    log.debug((Object)ignored);
                }
            }
            try {
                log.debug((Object)("Creating Sub-Context: " + tenantContextName));
                subContext = base.createSubcontext(tenantContextName);
                contextCleanupTask.register(tenantId, subContext);
                if (subContext == null) {
                    throw new RuntimeException("Initial context was not created for tenant: " + tenantId);
                }
                return subContext;
            }
            catch (NamingException e) {
                throw new RuntimeException("An error occurred while creating the initial context for tenant: " + tenantId, e);
            }
        }

        @Override
        public Object lookup(String s) throws NamingException {
            return this.getInitialContext(s).lookup(s);
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.getInitialContext(name).lookup(name);
        }

        @Override
        public void bind(String s, Object o) throws NamingException {
            this.getInitialContext(s).bind(s, o);
        }

        @Override
        public void bind(Name name, Object o) throws NamingException {
            this.getInitialContext(name).bind(name, o);
        }

        @Override
        public void rebind(String s, Object o) throws NamingException {
            this.getInitialContext(s).rebind(s, o);
        }

        @Override
        public void rebind(Name name, Object o) throws NamingException {
            this.getInitialContext(name).rebind(name, o);
        }

        @Override
        public void unbind(String s) throws NamingException {
            this.getInitialContext(s).unbind(s);
        }

        @Override
        public void unbind(Name name) throws NamingException {
            this.getInitialContext(name).unbind(name);
        }

        @Override
        public void rename(String s, String s1) throws NamingException {
            this.getInitialContext(s).rename(s, s1);
        }

        @Override
        public void rename(Name name, Name name1) throws NamingException {
            this.getInitialContext(name).rename(name, name1);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
            return this.getInitialContext(s).list(s);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return this.getInitialContext(name).list(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String s) throws NamingException {
            return this.getInitialContext(s).listBindings(s);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return this.getInitialContext(name).listBindings(name);
        }

        @Override
        public void destroySubcontext(String s) throws NamingException {
            this.getInitialContext(s).destroySubcontext(s);
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            this.getInitialContext(name).destroySubcontext(name);
        }

        @Override
        public Context createSubcontext(String s) throws NamingException {
            return this.getInitialContext(s).createSubcontext(s);
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            return this.getInitialContext(name).createSubcontext(name);
        }

        @Override
        public Object lookupLink(String s) throws NamingException {
            return this.getInitialContext(s).lookupLink(s);
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return this.getInitialContext(name).lookupLink(name);
        }

        @Override
        public NameParser getNameParser(String s) throws NamingException {
            return this.getInitialContext(s).getNameParser(s);
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return this.getInitialContext(name).getNameParser(name);
        }

        @Override
        public String composeName(String s, String s1) throws NamingException {
            return this.getInitialContext(s).composeName(s, s1);
        }

        @Override
        public Name composeName(Name name, Name name1) throws NamingException {
            return this.getInitialContext(name).composeName(name, name1);
        }

        @Override
        public Object addToEnvironment(String s, Object o) throws NamingException {
            return this.getInitialContext().addToEnvironment(s, o);
        }

        @Override
        public Object removeFromEnvironment(String s) throws NamingException {
            return this.getInitialContext().removeFromEnvironment(s);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            if (CarbonContextDataHolder.isSubTenant(CarbonContextDataHolder.getThreadLocalCarbonContextHolder().getTenantId())) {
                throw new NamingException("Tenants cannot retrieve the environment.");
            }
            return this.getInitialContext().getEnvironment();
        }

        @Override
        public void close() throws NamingException {
            Context ctx;
            if (CarbonContextDataHolder.isSubTenant(CarbonContextDataHolder.getThreadLocalCarbonContextHolder().getTenantId()) && !this.isBaseContextRequested()) {
                CarbonUtils.checkSecurity();
            }
            if (!(ctx = this.getInitialContext()).getClass().getName().equals("org.apache.naming.SelectorContext")) {
                ctx.close();
            }
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return this.getInitialContext().getNameInNamespace();
        }

        public int hashCode() {
            return this.initialContext.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof CarbonInitialJNDIContext && this.initialContext.equals(o);
        }

        private DirContext getDirectoryContext(Name name) throws NamingException {
            return this.getDirectoryContext(name.get(0));
        }

        private DirContext getDirectoryContext() throws NamingException {
            return this.getDirectoryContext((String)null);
        }

        private DirContext getDirectoryContext(String name) throws NamingException {
            Context initialContext = this.getInitialContext(name);
            if (initialContext instanceof DirContext) {
                return (DirContext)initialContext;
            }
            throw new NamingException("The given Context is not an instance of " + DirContext.class.getName());
        }

        @Override
        public Attributes getAttributes(Name name) throws NamingException {
            return this.getDirectoryContext(name).getAttributes(name);
        }

        @Override
        public Attributes getAttributes(String s) throws NamingException {
            return this.getDirectoryContext(s).getAttributes(s);
        }

        @Override
        public Attributes getAttributes(Name name, String[] strings) throws NamingException {
            return this.getDirectoryContext(name).getAttributes(name, strings);
        }

        @Override
        public Attributes getAttributes(String s, String[] strings) throws NamingException {
            return this.getDirectoryContext(s).getAttributes(s, strings);
        }

        @Override
        public void modifyAttributes(Name name, int i, Attributes attributes) throws NamingException {
            this.getDirectoryContext(name).modifyAttributes(name, i, attributes);
        }

        @Override
        public void modifyAttributes(String s, int i, Attributes attributes) throws NamingException {
            this.getDirectoryContext(s).modifyAttributes(s, i, attributes);
        }

        @Override
        public void modifyAttributes(Name name, ModificationItem[] modificationItems) throws NamingException {
            this.getDirectoryContext(name).modifyAttributes(name, modificationItems);
        }

        @Override
        public void modifyAttributes(String s, ModificationItem[] modificationItems) throws NamingException {
            this.getDirectoryContext(s).modifyAttributes(s, modificationItems);
        }

        @Override
        public void bind(Name name, Object o, Attributes attributes) throws NamingException {
            this.getDirectoryContext(name).bind(name, o, attributes);
        }

        @Override
        public void bind(String s, Object o, Attributes attributes) throws NamingException {
            this.getDirectoryContext(s).bind(s, o, attributes);
        }

        @Override
        public void rebind(Name name, Object o, Attributes attributes) throws NamingException {
            this.getDirectoryContext(name).rebind(name, o, attributes);
        }

        @Override
        public void rebind(String s, Object o, Attributes attributes) throws NamingException {
            this.getDirectoryContext(s).rebind(s, o, attributes);
        }

        @Override
        public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
            return this.getDirectoryContext(name).createSubcontext(name, attributes);
        }

        @Override
        public DirContext createSubcontext(String s, Attributes attributes) throws NamingException {
            return this.getDirectoryContext(s).createSubcontext(s, attributes);
        }

        @Override
        public DirContext getSchema(Name name) throws NamingException {
            return this.getDirectoryContext(name).getSchema(name);
        }

        @Override
        public DirContext getSchema(String s) throws NamingException {
            return this.getDirectoryContext(s).getSchema(s);
        }

        @Override
        public DirContext getSchemaClassDefinition(Name name) throws NamingException {
            return this.getDirectoryContext(name).getSchemaClassDefinition(name);
        }

        @Override
        public DirContext getSchemaClassDefinition(String s) throws NamingException {
            return this.getDirectoryContext(s).getSchemaClassDefinition(s);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, Attributes attributes, String[] strings) throws NamingException {
            return this.getDirectoryContext(name).search(name, attributes, strings);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String s, Attributes attributes, String[] strings) throws NamingException {
            return this.getDirectoryContext(s).search(s, attributes, strings);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, Attributes attributes) throws NamingException {
            return this.getDirectoryContext(name).search(name, attributes);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String s, Attributes attributes) throws NamingException {
            return this.getDirectoryContext(s).search(s, attributes);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls searchControls) throws NamingException {
            return this.getDirectoryContext(name).search(name, filter, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String s, String filter, SearchControls searchControls) throws NamingException {
            return this.getDirectoryContext(s).search(s, filter, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(Name name, String filter, Object[] objects, SearchControls searchControls) throws NamingException {
            return this.getDirectoryContext(name).search(name, filter, objects, searchControls);
        }

        @Override
        public NamingEnumeration<SearchResult> search(String s, String filter, Object[] objects, SearchControls searchControls) throws NamingException {
            return this.getDirectoryContext(s).search(s, filter, objects, searchControls);
        }

        private LdapContext getLdapContext() throws NamingException {
            DirContext dirContext = this.getDirectoryContext();
            if (dirContext instanceof EventContext) {
                return (LdapContext)dirContext;
            }
            throw new NamingException("The given Context is not an instance of " + LdapContext.class.getName());
        }

        @Override
        public ExtendedResponse extendedOperation(ExtendedRequest extendedRequest) throws NamingException {
            return this.getLdapContext().extendedOperation(extendedRequest);
        }

        @Override
        public LdapContext newInstance(Control[] controls) throws NamingException {
            return this.getLdapContext().newInstance(controls);
        }

        @Override
        public void reconnect(Control[] controls) throws NamingException {
            this.getLdapContext().reconnect(controls);
        }

        @Override
        public Control[] getConnectControls() throws NamingException {
            return this.getLdapContext().getConnectControls();
        }

        @Override
        public void setRequestControls(Control[] controls) throws NamingException {
            this.getLdapContext().setRequestControls(controls);
        }

        @Override
        public Control[] getRequestControls() throws NamingException {
            return this.getLdapContext().getRequestControls();
        }

        @Override
        public Control[] getResponseControls() throws NamingException {
            return this.getLdapContext().getResponseControls();
        }

        private EventContext getEventContext(Name name) throws NamingException {
            return this.getEventContext(name.get(0));
        }

        private EventContext getEventContext() throws NamingException {
            return this.getEventContext((String)null);
        }

        private EventContext getEventContext(String name) throws NamingException {
            Context initialContext = this.getInitialContext(name);
            if (initialContext instanceof EventContext) {
                return (EventContext)initialContext;
            }
            throw new NamingException("The given Context is not an instance of " + EventContext.class.getName());
        }

        @Override
        public void addNamingListener(Name name, int i, NamingListener namingListener) throws NamingException {
            CarbonUtils.checkSecurity();
            this.getEventContext(name).addNamingListener(name, i, namingListener);
        }

        @Override
        public void addNamingListener(String s, int i, NamingListener namingListener) throws NamingException {
            CarbonUtils.checkSecurity();
            this.getEventContext(s).addNamingListener(s, i, namingListener);
        }

        @Override
        public void removeNamingListener(NamingListener namingListener) throws NamingException {
            CarbonUtils.checkSecurity();
            this.getEventContext().removeNamingListener(namingListener);
        }

        @Override
        public boolean targetMustExist() throws NamingException {
            return this.getEventContext().targetMustExist();
        }

        private EventDirContext getEventDirContext(Name name) throws NamingException {
            return this.getEventDirContext(name.get(0));
        }

        private EventDirContext getEventDirContext(String name) throws NamingException {
            EventContext eventContext = this.getEventContext(name);
            if (eventContext instanceof EventDirContext) {
                return (EventDirContext)eventContext;
            }
            throw new NamingException("The given Context is not an instance of " + EventDirContext.class.getName());
        }

        @Override
        public void addNamingListener(Name name, String filter, SearchControls searchControls, NamingListener namingListener) throws NamingException {
            CarbonUtils.checkSecurity();
            this.getEventDirContext(name).addNamingListener(name, filter, searchControls, namingListener);
        }

        @Override
        public void addNamingListener(String s, String filter, SearchControls searchControls, NamingListener namingListener) throws NamingException {
            CarbonUtils.checkSecurity();
            this.getEventDirContext(s).addNamingListener(s, filter, searchControls, namingListener);
        }

        @Override
        public void addNamingListener(Name name, String filter, Object[] objects, SearchControls searchControls, NamingListener namingListener) throws NamingException {
            CarbonUtils.checkSecurity();
            this.getEventDirContext(name).addNamingListener(name, filter, objects, searchControls, namingListener);
        }

        @Override
        public void addNamingListener(String s, String filter, Object[] objects, SearchControls searchControls, NamingListener namingListener) throws NamingException {
            CarbonUtils.checkSecurity();
            this.getEventDirContext(s).addNamingListener(s, filter, objects, searchControls, namingListener);
        }

        static {
            CarbonContextDataHolder.registerUnloadTenantTask(contextCleanupTask);
            superTenantOnlyUrlContextSchemes = Arrays.asList(CarbonUtils.getServerConfiguration().getProperties("JNDI.Restrictions.SuperTenantOnly.UrlContexts.UrlContext.Scheme"));
            allTenantUrlContextSchemes = Arrays.asList(CarbonUtils.getServerConfiguration().getProperties("JNDI.Restrictions.AllTenants.UrlContexts.UrlContext.Scheme"));
        }

        private static class ContextCleanupTask
        implements UnloadTenantTask<Context> {
            private Map<Integer, ArrayList<Context>> contexts = new ConcurrentHashMap<Integer, ArrayList<Context>>();

            private ContextCleanupTask() {
            }

            public void register(int tenantId, Context context) {
                ArrayList<Context> list = this.contexts.get(tenantId);
                if (list == null) {
                    list = new ArrayList();
                    list.add(context);
                    this.contexts.put(tenantId, list);
                } else if (!list.contains(context)) {
                    list.add(context);
                }
            }

            public void cleanup(int tenantId) {
                ArrayList<Context> list = this.contexts.remove(tenantId);
                if (list != null) {
                    Collections.reverse(list);
                    for (Context context : list) {
                        try {
                            context.close();
                        }
                        catch (NamingException ignore) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Exception while outine cleanup", (Throwable)ignore);
                        }
                    }
                    list.clear();
                }
            }
        }
    }

    private static class CarbonInitialJNDIContextFactory
    implements InitialContextFactory {
        private InitialContextFactory factory;

        public CarbonInitialJNDIContextFactory(InitialContextFactory factory) {
            this.factory = factory;
        }

        @Override
        public Context getInitialContext(Hashtable<?, ?> h) throws NamingException {
            return new CarbonInitialJNDIContext(this.factory.getInitialContext(h));
        }
    }

    private static class CarbonInitialJNDIContextFactoryBuilder
    implements InitialContextFactoryBuilder {
        private static final String defaultInitialContextFactory = CarbonUtils.getServerConfiguration().getFirstProperty("JNDI.DefaultInitialContextFactory");

        private CarbonInitialJNDIContextFactoryBuilder() {
        }

        @Override
        public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> h) throws NamingException {
            try {
                String factoryClassName = (String)h.get("java.naming.factory.initial");
                if (factoryClassName != null) {
                    Class factoryClass = CarbonContextDataHolder.classForName(factoryClassName);
                    return (InitialContextFactory)factoryClass.newInstance();
                }
                factoryClassName = defaultInitialContextFactory;
                if (factoryClassName == null) {
                    throw new NoInitialContextException("Failed to create InitialContext. No factory specified in hash table.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading JNDI Initial Context Factory: " + factoryClassName));
                }
                Class factoryClass = CarbonContextDataHolder.classForName(factoryClassName);
                InitialContextFactory initialContextFactory = null;
                String defaultInitialContextFactoryClassName = CarbonUtils.getServerConfiguration().getFirstProperty("JNDI.CarbonInitialJNDIContextFactory");
                if (defaultInitialContextFactoryClassName != null) {
                    try {
                        Class defaultInitialContextFactoryBuilderClass = CarbonContextDataHolder.classForName(defaultInitialContextFactoryClassName);
                        initialContextFactory = (InitialContextFactory)defaultInitialContextFactoryBuilderClass.getConstructor(InitialContextFactory.class).newInstance(factoryClass.newInstance());
                    }
                    catch (ClassNotFoundException e) {
                        log.warn((Object)("The specified InitialContextFactoryBuilder " + defaultInitialContextFactoryClassName + " is not there in the class path.Using the default InitialContextFactoryBuilder "), (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        log.warn((Object)("The specified InitialContextFactoryBuilder " + defaultInitialContextFactoryClassName + " could not be instantiated.Using the default InitialContextFactoryBuilder "), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        log.warn((Object)("The specified InitialContextFactoryBuilder " + defaultInitialContextFactoryClassName + " could not be accessed.Using the default InitialContextFactoryBuilder "), (Throwable)e);
                    }
                }
                if (initialContextFactory != null) {
                    return initialContextFactory;
                }
                return new CarbonInitialJNDIContextFactory((InitialContextFactory)factoryClass.newInstance());
            }
            catch (Exception e) {
                NoInitialContextException nex = new NoInitialContextException("Failed to create InitialContext using factory specified in hash table.");
                nex.setRootCause(e);
                throw nex;
            }
        }
    }

    private static class InternalCarbonQueueManager
    extends CarbonQueueManager {
        private AtomicReference<MultitenantCarbonQueueManager> queueManager = new AtomicReference();

        private InternalCarbonQueueManager() {
        }

        public CarbonQueue<?> getQueue(String name) {
            int tenantId = CarbonContextDataHolder.getThreadLocalCarbonContextHolder().getTenantId();
            if (this.queueManager.get() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retrieving named queue: " + name));
                }
                return this.queueManager.get().getQueue(name, CarbonContextDataHolder.isSubTenant(tenantId) ? tenantId : -1234);
            }
            return null;
        }

        public synchronized void setQueueManager(MultitenantCarbonQueueManager queueManager) throws QueuingException {
            CarbonUtils.checkSecurity();
            if (CarbonContextDataHolder.getThreadLocalCarbonContextHolder().getTenantId() != -1234) {
                throw new QueuingException("Only the super-tenant can set the queue manager.");
            }
            Object carbonQueueManager = null;
            if (this.queueManager.get() != null) {
                throw new QueuingException("The queue manager has already been set.");
            }
            this.queueManager.set(queueManager);
        }

        public synchronized void removeQueueManager() throws QueuingException {
            CarbonUtils.checkSecurity();
            if (CarbonContextDataHolder.getThreadLocalCarbonContextHolder().getTenantId() != -1234) {
                throw new QueuingException("Only the super-tenant can remove the queue manager.");
            }
            this.queueManager.set(null);
        }
    }
}

