/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;

public class AuditLog {
    public static final String IMPERSONATOR_ID = "impersonator";
    private final String id;
    private final String recordedAt;
    private final String requestId;
    private final String initiatorId;
    private final String initiatorType;
    private final String targetId;
    private final String targetType;
    private final String action;
    private final String impersonatorId;
    private final Map<String, Object> data;

    private AuditLog(AuditLogBuilder auditLogBuilder) {
        this.id = auditLogBuilder.id;
        this.recordedAt = auditLogBuilder.recordedAt;
        this.requestId = auditLogBuilder.requestId;
        this.initiatorId = auditLogBuilder.initiatorId;
        this.initiatorType = auditLogBuilder.initiatorType;
        this.targetId = auditLogBuilder.targetId;
        this.targetType = auditLogBuilder.targetType;
        this.action = auditLogBuilder.action;
        this.impersonatorId = auditLogBuilder.impersonatorId;
        this.data = auditLogBuilder.data;
    }

    public String getId() {
        return this.id;
    }

    public String getRecordedAt() {
        return this.recordedAt;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public String getInitiatorType() {
        return this.initiatorType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getAction() {
        return this.action;
    }

    public String getImpersonatorId() {
        return this.impersonatorId;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public static class AuditLogBuilder {
        private String id;
        private String recordedAt;
        private String requestId;
        private String impersonatorId;
        private final String initiatorId;
        private final String targetId;
        private final String initiatorType;
        private final String targetType;
        private final String action;
        private Map<String, Object> data;

        public AuditLogBuilder(String initiatorId, String initiatorType, String targetId, String targetType, String action) {
            this.initiatorId = initiatorId;
            this.targetId = targetId;
            this.initiatorType = initiatorType;
            this.targetType = targetType;
            this.action = action;
        }

        public AuditLogBuilder data(String key, Object value) {
            if (value == null) {
                return this;
            }
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            this.data.put(key, value);
            return this;
        }

        public AuditLogBuilder data(Map<String, ?> data) {
            if (data == null) {
                return this;
            }
            if (this.data == null) {
                this.data = new HashMap<String, Object>();
            }
            this.data.putAll(data);
            return this;
        }

        public AuditLog build() {
            if (StringUtils.isEmpty((String)this.initiatorId) || StringUtils.isEmpty((String)this.initiatorType) || StringUtils.isEmpty((String)this.targetId) || StringUtils.isEmpty((String)this.targetType) || StringUtils.isEmpty((String)this.action)) {
                throw new IllegalStateException("Action, initiatorId, initiatorType, targetId and targetType must not be null.");
            }
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
            }
            if (this.recordedAt == null) {
                this.recordedAt = Instant.now().toString();
            }
            if (this.impersonatorId == null) {
                this.impersonatorId = MDC.get((String)AuditLog.IMPERSONATOR_ID);
            }
            if (this.requestId == null) {
                this.requestId = MDC.get((String)"Correlation-ID");
            }
            return new AuditLog(this);
        }
    }
}

