/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.util.Optional;
import javax.net.ssl.SSLException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.http.conn.ssl.AbstractVerifier;

public class CustomHostNameVerifier
extends AbstractVerifier {
    private static final String[] LOCALHOSTS = new String[]{"::1", "127.0.0.1", "localhost", "localhost.localdomain"};

    public void verify(String hostname, String[] commonNames, String[] subjectAlternativeNames) throws SSLException {
        Object[] subjectAltsWithLocalhosts = (String[])ArrayUtils.addAll((Object[])subjectAlternativeNames, (Object[])LOCALHOSTS);
        boolean hasValidCommonNames = Optional.ofNullable(commonNames).filter(names -> ((String[])names).length > 0).map(names -> names[0]).isPresent();
        if (hasValidCommonNames && !ArrayUtils.contains((Object[])subjectAlternativeNames, (Object)commonNames[0])) {
            subjectAltsWithLocalhosts = (String[])ArrayUtils.add((Object[])subjectAltsWithLocalhosts, (Object)commonNames[0]);
        }
        super.verify(hostname, commonNames, (String[])subjectAltsWithLocalhosts, false);
    }
}

