/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.MDC;

public class DiagnosticLog {
    public static final String CORRELATION_ID_MDC = "Correlation-ID";
    public static final String FLOW_ID_MDC = "Flow-ID";
    private final String logId;
    private final Instant recordedAt;
    private final String requestId;
    private final String flowId;
    private final String resultStatus;
    private final String resultMessage;
    private final String actionId;
    private final String componentId;
    private final Map<String, Object> input;
    private final Map<String, Object> configurations;
    private final LogDetailLevel logDetailLevel;

    @Deprecated
    public DiagnosticLog(String logId, Instant recordedAt, String requestId, String flowId, String resultStatus, String resultMessage, String actionId, String componentId, Map<String, Object> input, Map<String, Object> configurations) {
        this.logId = logId;
        this.recordedAt = recordedAt;
        this.requestId = requestId;
        this.flowId = flowId;
        this.resultStatus = resultStatus;
        this.resultMessage = resultMessage;
        this.actionId = actionId;
        this.componentId = componentId;
        this.input = input;
        this.configurations = configurations;
        this.logDetailLevel = LogDetailLevel.INTERNAL_SYSTEM;
    }

    private DiagnosticLog(DiagnosticLogBuilder builder) {
        this.logId = builder.logId;
        this.recordedAt = builder.recordedAt;
        this.requestId = builder.requestId;
        this.flowId = builder.flowId;
        this.resultStatus = String.valueOf((Object)builder.resultStatus);
        this.resultMessage = builder.resultMessage;
        this.actionId = builder.actionId;
        this.componentId = builder.componentId;
        this.input = builder.input;
        this.configurations = builder.configurations;
        this.logDetailLevel = builder.logDetailLevel;
    }

    public String getLogId() {
        return this.logId;
    }

    public Instant getRecordedAt() {
        return this.recordedAt;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public String getResultStatus() {
        return this.resultStatus;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    public String getActionId() {
        return this.actionId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Map<String, Object> getInput() {
        return this.input;
    }

    public Map<String, Object> getConfigurations() {
        return this.configurations;
    }

    public LogDetailLevel getLogDetailLevel() {
        return this.logDetailLevel;
    }

    public static class DiagnosticLogBuilder {
        private String logId;
        private Instant recordedAt;
        private String requestId;
        private String flowId;
        private ResultStatus resultStatus;
        private String resultMessage;
        private final String actionId;
        private final String componentId;
        private Map<String, Object> input;
        private Map<String, Object> configurations;
        private LogDetailLevel logDetailLevel;

        public DiagnosticLogBuilder(String componentId, String actionId) {
            this.componentId = componentId;
            this.actionId = actionId;
        }

        public DiagnosticLogBuilder resultStatus(ResultStatus resultStatus) {
            this.resultStatus = resultStatus;
            return this;
        }

        public DiagnosticLogBuilder resultMessage(String resultMessage) {
            this.resultMessage = resultMessage;
            return this;
        }

        public DiagnosticLogBuilder inputParam(String key, Object value) {
            if (this.input == null) {
                this.input = new HashMap<String, Object>();
            }
            this.input.put(key, value);
            return this;
        }

        public DiagnosticLogBuilder configParam(String key, Object value) {
            if (this.configurations == null) {
                this.configurations = new HashMap<String, Object>();
            }
            this.configurations.put(key, value);
            return this;
        }

        public DiagnosticLogBuilder inputParams(Map<String, ?> input) {
            if (this.input == null) {
                this.input = new HashMap<String, Object>();
            }
            this.input.putAll(input);
            return this;
        }

        public DiagnosticLogBuilder configParams(Map<String, ?> configurations) {
            if (this.configurations == null) {
                this.configurations = new HashMap<String, Object>();
            }
            this.configurations.putAll(configurations);
            return this;
        }

        public DiagnosticLogBuilder logDetailLevel(LogDetailLevel logDetailLevel) {
            this.logDetailLevel = logDetailLevel;
            return this;
        }

        public DiagnosticLog build() {
            if (this.componentId == null || this.actionId == null) {
                throw new IllegalStateException("componentId and actionId must not be null.");
            }
            if (this.resultMessage == null && this.input == null) {
                throw new IllegalStateException("Either resultMessage or input must be provided.");
            }
            this.logId = UUID.randomUUID().toString();
            this.recordedAt = Instant.now();
            this.requestId = MDC.get((String)DiagnosticLog.CORRELATION_ID_MDC);
            this.flowId = MDC.get((String)DiagnosticLog.FLOW_ID_MDC);
            if (this.logDetailLevel == null) {
                this.logDetailLevel = LogDetailLevel.INTERNAL_SYSTEM;
            }
            return new DiagnosticLog(this);
        }
    }

    public static enum ResultStatus {
        SUCCESS,
        FAILED;

    }

    public static enum LogDetailLevel {
        APPLICATION,
        INTERNAL_SYSTEM;

    }
}

