/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.deployment;

import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.wso2.carbon.utils.deployment.BundleClassLoader;

public class Axis2ModuleRegistry {
    private static Log log = LogFactory.getLog(Axis2ModuleRegistry.class);
    private AxisConfiguration axisConfig;
    private final Lock lock = new ReentrantLock();
    private Map<Bundle, AxisModule> moduleMap;

    public Axis2ModuleRegistry(AxisConfiguration axisConfiguration) {
        this.axisConfig = axisConfiguration;
        this.moduleMap = new ConcurrentHashMap<Bundle, AxisModule>();
    }

    public void register(Bundle[] bundles) {
        for (Bundle bundle : bundles) {
            this.register(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Bundle bundle) {
        this.lock.lock();
        try {
            if (this.moduleMap.containsKey(bundle)) {
                return;
            }
            Enumeration enumeration = bundle.findEntries("META-INF", "module.xml", true);
            while (enumeration != null && enumeration.hasMoreElements()) {
                URL xmlURL = (URL)enumeration.nextElement();
                AxisModule axisModule = this.populateModule(bundle, xmlURL);
                this.deployModule(axisModule);
                this.moduleMap.put(bundle, axisModule);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Deploying Module: " + axisModule.getName() + "-" + axisModule.getVersion() + " in bundle " + bundle.getSymbolicName()));
            }
        }
        catch (Throwable e) {
            String msg = "Error while deploying the module from bunlde : " + bundle.getSymbolicName() + "-" + bundle.getVersion();
            log.error((Object)msg, e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void unRegister(Bundle bundle) {
        this.lock.lock();
        try {
            AxisModule axisModule = this.moduleMap.get(bundle);
            if (axisModule != null) {
                this.axisConfig.removeModule(axisModule.getName(), axisModule.getVersion());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Stopping" + axisModule.getName() + ":" + axisModule.getVersion() + " moduel in Bundle - " + bundle.getSymbolicName()));
                }
                this.moduleMap.remove(bundle);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            default: 
        }
    }

    private void deployModule(AxisModule axisModule) throws AxisFault {
        HashMap<String, AxisModule> moduleMap = new HashMap<String, AxisModule>(1);
        moduleMap.put(axisModule.getName(), axisModule);
        Utils.calculateDefaultModuleVersion(moduleMap, (AxisConfiguration)this.axisConfig);
        DeploymentEngine.addNewModule((AxisModule)axisModule, (AxisConfiguration)this.axisConfig);
    }

    private AxisModule populateModule(Bundle bundle, URL xmlURL) throws Exception {
        BundleClassLoader loader = new BundleClassLoader(bundle, Axis2ModuleRegistry.class.getClassLoader());
        AxisModule axisModule = new AxisModule();
        axisModule.setModuleClassLoader((ClassLoader)loader);
        ModuleBuilder builder = new ModuleBuilder(xmlURL.openStream(), axisModule, this.axisConfig);
        this.setModuleNameAndVersion(bundle, axisModule);
        builder.populateModule();
        axisModule.setParent(this.axisConfig);
        AxisModule module = this.axisConfig.getModule(axisModule.getName());
        if (module != null) {
            log.warn((Object)("Module : " + axisModule.getName() + "-" + axisModule.getVersion() + " is already available."));
        }
        return axisModule;
    }

    private void setModuleNameAndVersion(Bundle bundle, AxisModule axismodule) throws AxisFault {
        Dictionary headers = bundle.getHeaders();
        String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
        String bundleVersion = (String)headers.get("Bundle-Version");
        if (bundleSymbolicName != null && bundleSymbolicName.length() != 0) {
            axismodule.setName(bundleSymbolicName);
        }
        if (bundleVersion != null && bundleVersion.length() != 0) {
            String moduleVersion = "SNAPSHOT";
            String[] versionSplit = bundleVersion.split("\\.");
            if (versionSplit.length == 4) {
                moduleVersion = versionSplit[0] + "." + versionSplit[1] + versionSplit[2] + "-" + versionSplit[3];
            } else if (versionSplit.length == 3) {
                String result = versionSplit[2];
                moduleVersion = result.matches(".*\\d.*") ? versionSplit[0] + "." + versionSplit[1] + "." + result : versionSplit[0] + "." + versionSplit[1] + "-" + result;
            } else if (versionSplit.length == 2) {
                String result = versionSplit[1];
                moduleVersion = result.matches(".*\\d.*") ? versionSplit[0] + "." + result : versionSplit[0] + "-" + result;
                moduleVersion = versionSplit[0] + "." + versionSplit[1];
            } else if (versionSplit.length == 1) {
                moduleVersion = versionSplit[0];
            }
            try {
                axismodule.setVersion(new Version(moduleVersion));
            }
            catch (Exception e) {
                String msg = "Error while setting the version " + moduleVersion + " for the module : " + axismodule.getName();
                log.error((Object)msg);
                throw new AxisFault(msg, (Throwable)e);
            }
            axismodule.addParameter(this.createManagedModuleParam());
        }
    }

    private Parameter createManagedModuleParam() {
        Parameter parameter = new Parameter("managedModule", (Object)Boolean.TRUE.toString());
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace ns = fac.createOMNamespace("", "");
        OMElement paramEle = fac.createOMElement("parameter", ns);
        paramEle.addAttribute("name", "managedModule", ns);
        paramEle.setText(Boolean.TRUE.toString());
        parameter.setParameterElement(paramEle);
        return parameter;
    }
}

