/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;

public class CarbonAuditLog
implements Log {
    private static final String IMPERSONATOR = "impersonator";
    public static final Log AUDIT_LOG = LogFactory.getLog((String)"AUDIT_LOG");

    public void debug(Object o) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.debug((Object)message);
        }
    }

    public void debug(Object o, Throwable throwable) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.debug((Object)message, throwable);
        }
    }

    public void error(Object o) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.error((Object)message);
        }
    }

    public void error(Object o, Throwable throwable) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.error((Object)message, throwable);
        }
    }

    public void fatal(Object o) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.fatal((Object)message);
        }
    }

    public void fatal(Object o, Throwable throwable) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.fatal((Object)message, throwable);
        }
    }

    public void info(Object o) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.info((Object)message);
        }
    }

    public void info(Object o, Throwable throwable) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.info((Object)message, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return AUDIT_LOG.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return AUDIT_LOG.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return AUDIT_LOG.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return AUDIT_LOG.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return AUDIT_LOG.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return AUDIT_LOG.isWarnEnabled();
    }

    public void trace(Object o) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.trace((Object)message);
        }
    }

    public void trace(Object o, Throwable throwable) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.trace((Object)message, throwable);
        }
    }

    public void warn(Object o) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.warn((Object)message);
        }
    }

    public void warn(Object o, Throwable throwable) {
        if (o != null) {
            String message = this.appendMDCProperties(o.toString());
            AUDIT_LOG.warn((Object)message, throwable);
        }
    }

    private String appendMDCProperties(String message) {
        StringBuilder auditLogBuilder = new StringBuilder(message);
        auditLogBuilder.append(this.appendImpersonationDetails());
        return auditLogBuilder.toString();
    }

    private String appendImpersonationDetails() {
        String impersonator = MDC.get((String)IMPERSONATOR);
        if (impersonator != null) {
            return " | Impersonator : " + impersonator;
        }
        return "";
    }
}

