/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.utils.CarbonUtils;

public class KeystoreUtils {
    private static Log LOG = LogFactory.getLog(KeystoreUtils.class);
    private static final String FALLBACK_TENANTED_KEYSTORE_FILE_TYPE = "JKS";
    private static final String KEY_STORES = "/repository/security/key-stores";

    public static String getExtensionByFileType(String fileType) {
        return StoreFileType.getExtension(StoreFileType.valueOf(fileType));
    }

    public static String getFileTypeByExtension(String extension) throws CarbonException {
        for (StoreFileType fileTypes : StoreFileType.values()) {
            if (!StoreFileType.getExtension(fileTypes).equals(extension)) continue;
            return fileTypes.name();
        }
        throw new CarbonException("Unsupported store file extension type:" + extension);
    }

    public static String getKeyStoreFileLocation(String tenantDomain) {
        if ("carbon.super".equals(tenantDomain)) {
            return CarbonUtils.getServerConfiguration().getFirstProperty("Security.KeyStore.Location");
        }
        return tenantDomain.trim().replace(".", "-") + KeystoreUtils.getKeyStoreFileExtension(tenantDomain);
    }

    public static String getKeyStoreFileType(String tenantDomain) {
        String keystoreType = CarbonUtils.getServerConfiguration().getFirstProperty("Security.KeyStore.Type");
        try {
            StoreFileType.validateFileType(keystoreType);
        }
        catch (CarbonException e) {
            LOG.error((Object)"Unsupported file type for key store file", (Throwable)e);
        }
        if ("carbon.super".equals(tenantDomain)) {
            return keystoreType;
        }
        String ksName = tenantDomain.trim().replace(".", "-");
        if (KeystoreUtils.isFileExistInRegistry(ksName + KeystoreUtils.getExtensionByFileType(keystoreType))) {
            return keystoreType;
        }
        return FALLBACK_TENANTED_KEYSTORE_FILE_TYPE;
    }

    public static String getKeyStoreFileExtension(String tenantDomain) {
        return KeystoreUtils.getExtensionByFileType(KeystoreUtils.getKeyStoreFileType(tenantDomain));
    }

    public static String getTrustStoreFileLocation() {
        return CarbonUtils.getServerConfiguration().getFirstProperty("Security.TrustStore.Location");
    }

    public static String getTrustStoreFileType() {
        String truststore = CarbonUtils.getServerConfiguration().getFirstProperty("Security.TrustStore.Type");
        try {
            StoreFileType.validateFileType(truststore);
        }
        catch (CarbonException e) {
            LOG.error((Object)"Unsupported file type for trust store file", (Throwable)e);
        }
        return truststore;
    }

    public static String getTrustStoreFileExtension() {
        return KeystoreUtils.getExtensionByFileType(KeystoreUtils.getTrustStoreFileType());
    }

    private static boolean isFileExistInRegistry(String keyStoreName) {
        boolean isKeyStoreExists = false;
        try {
            if (PrivilegedCarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_GOVERNANCE).resourceExists("/repository/security/key-stores/" + keyStoreName)) {
                isKeyStoreExists = true;
            }
        }
        catch (RegistryException e) {
            String msg = "Error while checking the existance of keystore.  ";
            LOG.error((Object)(msg + e.getMessage()));
        }
        return isKeyStoreExists;
    }

    public static KeyStore getKeystoreInstance(String keyStoreType) throws KeyStoreException, NoSuchProviderException {
        if ("PKCS12".equals(keyStoreType)) {
            return KeyStore.getInstance(keyStoreType, KeystoreUtils.getJCEProvider());
        }
        return KeyStore.getInstance(keyStoreType);
    }

    private static String getJCEProvider() {
        String provider = ServerConfiguration.getInstance().getFirstProperty("JCEProvider");
        if (!StringUtils.isBlank((CharSequence)provider)) {
            return provider;
        }
        return "BC";
    }

    public static enum StoreFileType {
        JKS(".jks"),
        PKCS12(".p12");

        private final String extension;
        private static final String defaultFileType = "PKCS12";

        private StoreFileType(String extension) {
            this.extension = extension;
        }

        public static String getExtension(StoreFileType tileType) {
            return tileType.extension;
        }

        public static String defaultFileType() {
            String keystoreTypesForNewTenants = CarbonUtils.getServerConfiguration().getFirstProperty("Security.TenantKeyStore.Type");
            if (StringUtils.isNotBlank((CharSequence)keystoreTypesForNewTenants)) {
                return keystoreTypesForNewTenants;
            }
            return KeystoreUtils.FALLBACK_TENANTED_KEYSTORE_FILE_TYPE;
        }

        public static void validateFileType(String fileType) throws CarbonException {
            try {
                StoreFileType.valueOf(fileType);
            }
            catch (IllegalArgumentException e) {
                throw new CarbonException("Unsupported store file type:" + fileType);
            }
        }
    }
}

