/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;

public class TenantAwarePatternLayout
extends PatternLayout {
    public static final String DEFAULT_TENANT_PATTERN = "[%T][%S]";
    private static String tenantPattern = "[%T][%S]";
    private static String superTenantText = null;
    private static UUID logUUID;
    private static Log log;

    public TenantAwarePatternLayout() {
    }

    public TenantAwarePatternLayout(String pattern) {
        super(pattern);
    }

    protected PatternParser createPatternParser(String pattern) {
        return new TenantAwarePatternParser(pattern);
    }

    public synchronized void setTenantPattern(String tenantPattern) {
        TenantAwarePatternLayout.tenantPattern = tenantPattern;
    }

    public synchronized void setLogUUIDUpdateInterval(String logUUIDUpdateInterval) {
        if (logUUIDUpdateInterval != null && !logUUIDUpdateInterval.isEmpty()) {
            try {
                int updateInterval = 0;
                updateInterval = Integer.parseInt(logUUIDUpdateInterval);
                if (updateInterval > 0) {
                    ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
                    scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                        @Override
                        public void run() {
                            UUID newLogUUID = UUID.randomUUID();
                            log.info((Object)("New log UUID: " + newLogUUID));
                            logUUID = newLogUUID;
                        }
                    }, updateInterval, updateInterval, TimeUnit.HOURS);
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)"LogUUIDUpdateInterval cannot be converted to an integer.");
            }
        }
    }

    public static void setSuperTenantText(String superTenantText) {
        TenantAwarePatternLayout.superTenantText = superTenantText;
    }

    static {
        log = LogFactory.getLog(TenantAwarePatternLayout.class);
        logUUID = UUID.randomUUID();
    }

    private static class TenantAwarePatternParser
    extends PatternParser {
        InetAddress inetAddress;
        String address;
        String serverName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ServerConfiguration.getInstance().getFirstProperty("ServerKey");
            }
        });

        public TenantAwarePatternParser(String pattern) {
            super(pattern);
            try {
                this.inetAddress = InetAddress.getLocalHost();
                this.address = this.inetAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                this.address = "127.0.0.1";
            }
        }

        protected void finalizeConverter(char c) {
            TenantAwareNamedPatternConverter pc = null;
            switch (c) {
                case 'D': {
                    pc = new TenantDomainPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case '@': {
                    pc = new AtSignPatternConverter(this.formattingInfo);
                    break;
                }
                case 'P': {
                    pc = new TenantPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'T': {
                    pc = new TenantIdPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'S': {
                    pc = new ServerNamePatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.serverName);
                    break;
                }
                case 'U': {
                    pc = new UserNamePatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'A': {
                    pc = new AppNamePatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'H': {
                    pc = new HostNamePatternConverter(this.formattingInfo, this.extractPrecisionOption(), this.address);
                    break;
                }
                case 'I': {
                    pc = new InstanceIdPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'K': {
                    pc = new LogUUIDPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                default: {
                    super.finalizeConverter(c);
                }
            }
            if (pc != null) {
                this.currentLiteral.setLength(0);
                this.addConverter(pc);
            }
        }

        private static class LogUUIDPatternConverter
        extends TenantAwareNamedPatternConverter {
            public LogUUIDPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            protected String getFullyQualifiedName(LoggingEvent event) {
                return logUUID.toString();
            }
        }

        private static class TenantPatternConverter
        extends TenantAwareNamedPatternConverter {
            public TenantPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                int tenantId = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                    @Override
                    public Integer run() {
                        return CarbonContext.getThreadLocalCarbonContext().getTenantId();
                    }
                });
                if (tenantId != -1 && tenantId != -1234) {
                    return new TenantAwarePatternLayout(tenantPattern).format(event);
                }
                return superTenantText;
            }
        }

        private static class AtSignPatternConverter
        extends TenantAwareNamedPatternConverter {
            public AtSignPatternConverter(FormattingInfo formattingInfo) {
                super(formattingInfo, -1);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (CarbonContext.getThreadLocalCarbonContext().getTenantDomain() != null) {
                    return "@";
                }
                return null;
            }
        }

        private static class AppNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            public AppNamePatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (event instanceof TenantAwareLoggingEvent) {
                    if (((TenantAwareLoggingEvent)event).getServiceName() != null) {
                        return ((TenantAwareLoggingEvent)event).getServiceName();
                    }
                    return "";
                }
                String appName = CarbonContext.getThreadLocalCarbonContext().getApplicationName();
                if (appName != null) {
                    return appName;
                }
                return "";
            }
        }

        private static class InstanceIdPatternConverter
        extends TenantAwareNamedPatternConverter {
            public InstanceIdPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                String stratosInstance = System.getProperty("carbon.instance.name");
                if (stratosInstance != null) {
                    return stratosInstance;
                }
                return "";
            }
        }

        private static class HostNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            String address;

            public HostNamePatternConverter(FormattingInfo formattingInfo, int precision, String hostAddress) {
                super(formattingInfo, precision);
                this.address = hostAddress;
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return this.address;
            }
        }

        private static class ServerNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            String name;

            public ServerNamePatternConverter(FormattingInfo formattingInfo, int precision, String serverName) {
                super(formattingInfo, precision);
                this.name = serverName;
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return this.name;
            }
        }

        private static class TenantDomainPatternConverter
        extends TenantAwareNamedPatternConverter {
            public TenantDomainPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            }
        }

        private static class UserNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            public UserNamePatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return CarbonContext.getThreadLocalCarbonContext().getUsername();
            }
        }

        private static class TenantIdPatternConverter
        extends TenantAwareNamedPatternConverter {
            public TenantIdPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (event instanceof TenantAwareLoggingEvent) {
                    return ((TenantAwareLoggingEvent)event).getTenantId();
                }
                int tenantId = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                    @Override
                    public Integer run() {
                        return CarbonContext.getThreadLocalCarbonContext().getTenantId();
                    }
                });
                if (tenantId != -1) {
                    return Integer.toString(tenantId);
                }
                return null;
            }
        }

        private static abstract class TenantAwareNamedPatternConverter
        extends PatternConverter {
            private int precision;

            public TenantAwareNamedPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo);
                this.precision = precision;
            }

            protected abstract String getFullyQualifiedName(LoggingEvent var1);

            public String convert(LoggingEvent event) {
                String n = this.getFullyQualifiedName(event);
                if (n == null) {
                    return "";
                }
                if (this.precision <= 0) {
                    return n;
                }
                int len = n.length();
                int end = len - 1;
                for (int i = this.precision; i > 0; --i) {
                    if ((end = n.lastIndexOf(46, end - 1)) != -1) continue;
                    return n;
                }
                return n.substring(end + 1, len);
            }
        }
    }
}

