/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.wso2.carbon.utils.UnsupportedSecretTypeException;

public class Secret {
    private char[] chars;
    private byte[] bytes;
    private int accessCount;

    private Secret(char[] chars) {
        this.chars = chars;
        this.accessCount = 0;
    }

    public char[] getChars() {
        if (this.chars == null) {
            this.chars = ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        return this.chars;
    }

    public byte[] getBytes() {
        return this.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] getBytes(Charset charset) {
        this.clearBytes(this.bytes);
        CharBuffer charBuffer = CharBuffer.wrap(this.getChars());
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        this.bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return this.bytes;
    }

    public boolean isEmpty() {
        return this.chars == null || this.chars.length < 1;
    }

    public void setChars(char[] chars) {
        this.clearChars(this.chars);
        this.chars = chars;
    }

    public void addChars(char[] chars) {
        char[] previous = this.getChars();
        this.setChars(ArrayUtils.addAll((char[])previous, (char[])chars));
        this.clearChars(previous);
    }

    public void clear() {
        --this.accessCount;
        if (this.accessCount < 0) {
            this.clearChars(this.chars);
            this.clearBytes(this.bytes);
        }
    }

    public static Secret getSecret(Object secret) throws UnsupportedSecretTypeException {
        if (secret != null) {
            if (secret instanceof Secret) {
                Secret secretObj = (Secret)secret;
                ++secretObj.accessCount;
                return secretObj;
            }
            if (secret instanceof char[]) {
                char[] secretChars = (char[])secret;
                return new Secret(Arrays.copyOf(secretChars, secretChars.length));
            }
            if (secret instanceof String) {
                return new Secret(((String)secret).trim().toCharArray());
            }
            throw new UnsupportedSecretTypeException("Unsupported Secret Type. Can handle only string type or character array type secrets");
        }
        return new Secret(ArrayUtils.EMPTY_CHAR_ARRAY);
    }

    private void clearChars(char[] chars) {
        if (chars != null) {
            Arrays.fill(chars, '\u0000');
        }
    }

    private void clearBytes(byte[] bytes) {
        if (bytes != null) {
            Arrays.fill(bytes, (byte)0);
        }
    }
}

