/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging.appenders;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.bootstrap.logging.LoggingBridge;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.utils.logging.LoggingUtils;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;

public class CarbonDailyRollingFileAppender
extends DailyRollingFileAppender
implements LoggingBridge {
    private String maskingPatternFile;
    private List<Pattern> maskingPatterns;

    public void push(LogRecord record) {
        LoggingEvent loggingEvent = LoggingUtils.getLogEvent(record);
        this.doAppend(loggingEvent);
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        int tenantId = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return CarbonContext.getThreadLocalCarbonContext().getTenantId();
            }
        });
        String serviceName = CarbonContext.getThreadLocalCarbonContext().getApplicationName();
        final TenantAwareLoggingEvent tenantAwareLoggingEvent = LoggingUtils.getTenantAwareLogEvent(this.maskingPatterns, loggingEvent, tenantId, serviceName);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                CarbonDailyRollingFileAppender.super.subAppend(tenantAwareLoggingEvent);
                return null;
            }
        });
    }

    public String getMaskingPatternFile() {
        return this.maskingPatternFile;
    }

    public void setMaskingPatternFile(String maskingPatternFile) {
        this.maskingPatterns = LoggingUtils.loadMaskingPatterns(maskingPatternFile);
    }
}

