/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging;

import java.util.ArrayList;
import java.util.List;

public class CircularBuffer<E> {
    private List<E> bufferList;
    private static final int MAX_ALLOWED_SIZE = 10000;
    private int startIndex;
    private int endIndex;
    private final int size;

    public CircularBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Requested size of circular buffer (" + size + ") is invalid");
        }
        if (size > 10000) {
            throw new IllegalArgumentException("Requested size of circular buffer (" + size + ") is greater than the allowed max size " + 10000);
        }
        this.size = size;
        this.bufferList = new ArrayList(this.getSize());
        this.startIndex = 0;
        this.endIndex = -1;
    }

    public CircularBuffer() {
        this(10000);
    }

    public synchronized void append(E element) {
        if (element == null) {
            throw new IllegalArgumentException("Circular buffer doesn't support null values to be added to buffer");
        }
        if (this.startIndex == this.getSize() - 1) {
            this.startIndex = 0;
        } else if (this.endIndex == this.getSize() - 1) {
            this.endIndex = -1;
            this.startIndex = 1;
        } else if (this.startIndex != 0) {
            ++this.startIndex;
        }
        ++this.endIndex;
        if (this.getSize() == this.bufferList.size()) {
            this.bufferList.set(this.endIndex, element);
        } else {
            this.bufferList.add(this.endIndex, element);
        }
    }

    public synchronized List<E> get(int amount) {
        if (this.bufferList.isEmpty()) {
            return new ArrayList();
        }
        if (amount <= 0) {
            return new ArrayList();
        }
        int amountOfElementsInContainer = this.bufferList.size();
        ArrayList<E> result = new ArrayList<E>(amountOfElementsInContainer);
        int i = this.startIndex;
        for (int amountToRetrieve = amount; amountOfElementsInContainer > 0 && amountToRetrieve > 0; --amountToRetrieve, --amountOfElementsInContainer) {
            result.add(this.bufferList.get(i % this.size));
            ++i;
        }
        return result;
    }

    public synchronized Object[] getObjects(int amount) {
        List<E> objectsList = this.get(amount);
        return objectsList.toArray(new Object[objectsList.size()]);
    }

    public synchronized void clear() {
        this.bufferList.clear();
        this.startIndex = 0;
        this.endIndex = -1;
    }

    public int getSize() {
        return this.size;
    }
}

