/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;
import org.wso2.carbon.utils.xml.StringUtils;

@Deprecated
public class LoggingUtils {
    private static final String REPLACEMENT_STRING = "*****";
    private static final String DEFAULT_MASKING_PATTERNS_FILE_NAME = "wso2-log-masking.properties";
    private static final Logger log = Logger.getLogger(LoggingUtils.class);

    public static LoggingEvent getLogEvent(LogRecord record) {
        org.apache.log4j.Level level = LoggingUtils.getLogLevel(record.getLevel());
        return new LoggingEvent(record.getSourceClassName(), (Category)Logger.getLogger((String)record.getSourceClassName()), (Priority)level, (Object)record.getMessage(), record.getThrown());
    }

    @Deprecated
    public static TenantAwareLoggingEvent getTenantAwareLogEvent(LoggingEvent loggingEvent, int tenantId, String serviceName) {
        Logger logger = Logger.getLogger((String)loggingEvent.getLoggerName());
        ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
        Throwable throwable = null == throwableInformation ? null : throwableInformation.getThrowable();
        TenantAwareLoggingEvent tenantAwareLoggingEvent = new TenantAwareLoggingEvent(loggingEvent.fqnOfCategoryClass, (Category)logger, loggingEvent.timeStamp, (Priority)loggingEvent.getLevel(), loggingEvent.getMessage(), throwable);
        tenantAwareLoggingEvent.setTenantId(Integer.toString(tenantId));
        tenantAwareLoggingEvent.setServiceName(serviceName);
        return tenantAwareLoggingEvent;
    }

    public static TenantAwareLoggingEvent getTenantAwareLogEvent(List<Pattern> maskingPatterns, LoggingEvent loggingEvent, int tenantId, String serviceName) {
        Logger logger = Logger.getLogger((String)loggingEvent.getLoggerName());
        ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
        Throwable throwable = null == throwableInformation ? null : throwableInformation.getThrowable();
        String logMessage = LoggingUtils.getLogMessage(loggingEvent);
        if (logMessage != null && maskingPatterns != null && maskingPatterns.size() > 0) {
            for (Pattern pattern : maskingPatterns) {
                Matcher matcher = pattern.matcher(logMessage);
                StringBuffer stringBuffer = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(stringBuffer, REPLACEMENT_STRING);
                }
                matcher.appendTail(stringBuffer);
                logMessage = stringBuffer.toString();
            }
        }
        TenantAwareLoggingEvent tenantAwareLoggingEvent = new TenantAwareLoggingEvent(loggingEvent.fqnOfCategoryClass, (Category)logger, loggingEvent.timeStamp, (Priority)loggingEvent.getLevel(), logMessage, throwable);
        tenantAwareLoggingEvent.setTenantId(Integer.toString(tenantId));
        tenantAwareLoggingEvent.setServiceName(serviceName);
        return tenantAwareLoggingEvent;
    }

    private static String getLogMessage(LoggingEvent loggingEvent) {
        if (loggingEvent.getMessage() == null) {
            return null;
        }
        return loggingEvent.getMessage().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Pattern> loadMaskingPatterns(String maskingFilePath) {
        String defaultFile = CarbonUtils.getCarbonConfigDirPath() + File.separatorChar + DEFAULT_MASKING_PATTERNS_FILE_NAME;
        ArrayList<Pattern> maskingPatterns = new ArrayList<Pattern>();
        Properties properties = new Properties();
        InputStream propsStream = null;
        try {
            if (!StringUtils.isEmpty(maskingFilePath)) {
                if (!Files.exists(Paths.get(maskingFilePath, new String[0]), new LinkOption[0]) || Files.isDirectory(Paths.get(maskingFilePath, new String[0]), new LinkOption[0])) {
                    log.error((Object)("Could not load the masking patterns from the provided file : " + maskingFilePath));
                    ArrayList<Pattern> arrayList = maskingPatterns;
                    return arrayList;
                }
                propsStream = new FileInputStream(maskingFilePath);
            } else {
                if (!Files.exists(Paths.get(defaultFile, new String[0]), new LinkOption[0])) {
                    ArrayList<Pattern> arrayList = maskingPatterns;
                    return arrayList;
                }
                propsStream = new FileInputStream(defaultFile);
            }
            properties.load(propsStream);
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                Pattern maskingPattern = Pattern.compile((String)entry.getValue());
                maskingPatterns.add(maskingPattern);
            }
            return maskingPatterns;
        }
        catch (IOException e) {
            log.error((Object)("Error loading the masking patterns, due to : " + e.getMessage()));
            return maskingPatterns;
        }
        finally {
            if (propsStream != null) {
                try {
                    propsStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static org.apache.log4j.Level getLogLevel(Level level) {
        if (level == Level.OFF) {
            return org.apache.log4j.Level.OFF;
        }
        if (level == Level.SEVERE) {
            return org.apache.log4j.Level.ERROR;
        }
        if (level == Level.WARNING) {
            return org.apache.log4j.Level.WARN;
        }
        if (level == Level.INFO) {
            return org.apache.log4j.Level.INFO;
        }
        if (level == Level.CONFIG || level == Level.FINE) {
            return org.apache.log4j.Level.DEBUG;
        }
        return org.apache.log4j.Level.TRACE;
    }
}

