/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.context.internal.CarbonContextDataHolder;
import org.wso2.carbon.context.internal.OSGiDataHolder;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.user.api.TenantManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserRealmService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class PrivilegedCarbonContext
extends CarbonContext {
    private static OSGiDataHolder dataHolder = OSGiDataHolder.getInstance();
    private static final Log log = LogFactory.getLog(PrivilegedCarbonContext.class);

    private PrivilegedCarbonContext(CarbonContextDataHolder carbonContextHolder) {
        super(carbonContextHolder);
    }

    public static void startTenantFlow() {
        CarbonUtils.checkSecurity();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().getCarbonContextDataHolder().startTenantFlow();
    }

    public static void endTenantFlow() {
        CarbonUtils.checkSecurity();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().getCarbonContextDataHolder().endTenantFlow();
    }

    public static void unloadTenant(int tenantId) {
        CarbonUtils.checkSecurity();
        CarbonContextDataHolder.unloadTenant(tenantId);
    }

    public static void destroyCurrentContext() {
        CarbonUtils.checkSecurity();
        CarbonContextDataHolder.destroyCurrentCarbonContextHolder();
    }

    public static PrivilegedCarbonContext getThreadLocalCarbonContext() {
        CarbonUtils.checkSecurity();
        return new PrivilegedCarbonContext(CarbonContextDataHolder.getThreadLocalCarbonContextHolder());
    }

    public void setTenantId(int tenantId) {
        this.setTenantId(tenantId, false);
    }

    public void setTenantId(int tenantId, boolean resolveTenantDomain) {
        this.getCarbonContextDataHolder().setTenantId(tenantId);
        if (!resolveTenantDomain) {
            return;
        }
        if (tenantId == -1234) {
            this.setTenantDomain("carbon.super");
            return;
        }
        this.resolveTenantDomain(tenantId);
    }

    public void setUsername(String username) {
        this.getCarbonContextDataHolder().setUsername(username);
    }

    public void setUserId(String userId) {
        this.getCarbonContextDataHolder().setUserId(userId);
    }

    public void setOrganizationId(String organizationId) {
        this.getCarbonContextDataHolder().setOrganizationId(organizationId);
    }

    public void setTenantDomain(String tenantDomain) {
        this.setTenantDomain(tenantDomain, false);
    }

    public void setTenantDomain(String tenantDomain, boolean resolveTenantId) {
        this.getCarbonContextDataHolder().setTenantDomain(tenantDomain);
        if (!resolveTenantId) {
            return;
        }
        this.resolveTenantId(tenantDomain);
    }

    public String getTenantDomain(boolean resolve) {
        if (resolve && this.getTenantDomain() == null && (this.getTenantId() > 0 || this.getTenantId() == -1234)) {
            this.resolveTenantDomain(this.getTenantId());
        }
        return this.getTenantDomain();
    }

    public int getTenantId(boolean resolve) {
        if (resolve && this.getTenantId() == -1 && this.getTenantDomain() != null) {
            this.resolveTenantId(this.getTenantDomain());
        }
        return this.getTenantId();
    }

    private void resolveTenantDomain(int tenantId) {
        TenantManager tenantManager = this.getTenantManager();
        if (tenantManager != null) {
            try {
                log.debug((Object)"Resolving tenant domain from tenant id");
                this.setTenantDomain(tenantManager.getDomain(tenantId));
            }
            catch (UserStoreException userStoreException) {
                // empty catch block
            }
        }
    }

    private void resolveTenantId(String tenantDomain) {
        TenantManager tenantManager = this.getTenantManager();
        if (tenantManager != null) {
            try {
                log.debug((Object)"Resolving tenant id from tenant domain");
                this.setTenantId(tenantManager.getTenantId(tenantDomain));
            }
            catch (UserStoreException userStoreException) {
                // empty catch block
            }
        }
    }

    private TenantManager getTenantManager() {
        try {
            UserRealmService realmService = dataHolder.getUserRealmService();
            if (realmService != null) {
                return realmService.getTenantManager();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setRegistry(RegistryType type, Registry registry) {
        if (registry != null) {
            CarbonContextDataHolder carbonContextDataHolder = this.getCarbonContextDataHolder();
            switch (type) {
                case USER_CONFIGURATION: {
                    log.trace((Object)"Setting config user registry instance.");
                    carbonContextDataHolder.setConfigUserRegistry(registry);
                    break;
                }
                case SYSTEM_CONFIGURATION: {
                    log.trace((Object)"Setting config system registry instance.");
                    carbonContextDataHolder.setConfigSystemRegistry(registry);
                    break;
                }
                case USER_GOVERNANCE: {
                    log.trace((Object)"Setting governance user registry instance.");
                    carbonContextDataHolder.setGovernanceUserRegistry(registry);
                    break;
                }
                case SYSTEM_GOVERNANCE: {
                    log.trace((Object)"Setting governance system registry instance.");
                    carbonContextDataHolder.setGovernanceSystemRegistry(registry);
                    break;
                }
                case LOCAL_REPOSITORY: {
                    log.trace((Object)"Setting local repository instance.");
                    carbonContextDataHolder.setLocalRepository(registry);
                }
            }
        }
    }

    @Override
    public Registry getRegistry(RegistryType type) {
        Registry registry = super.getRegistry(type);
        if (registry != null) {
            return registry;
        }
        switch (type) {
            case SYSTEM_CONFIGURATION: {
                try {
                    int tenantId = this.getTenantId();
                    if (tenantId != -1) {
                        registry = dataHolder.getRegistryService().getConfigSystemRegistry(tenantId);
                        this.setRegistry(RegistryType.SYSTEM_CONFIGURATION, registry);
                        return registry;
                    }
                }
                catch (Exception tenantId) {
                    // empty catch block
                }
                return null;
            }
            case SYSTEM_GOVERNANCE: {
                try {
                    int tenantId = this.getTenantId();
                    if (tenantId != -1) {
                        registry = dataHolder.getRegistryService().getGovernanceSystemRegistry(tenantId);
                        this.setRegistry(RegistryType.SYSTEM_GOVERNANCE, registry);
                        return registry;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public void setUserRealm(UserRealm userRealm) {
        this.getCarbonContextDataHolder().setUserRealm(userRealm);
    }

    @Override
    @Deprecated
    public Object getOSGiService(Class clazz) {
        return this.getOSGiService(clazz, null);
    }

    @Override
    @Deprecated
    public List<Object> getOSGiServices(Class clazz) {
        return this.getOSGiServices(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getOSGiService(Class clazz, Hashtable<String, String> props) {
        try (ServiceTracker serviceTracker = null;){
            BundleContext bundleContext = dataHolder.getBundleContext();
            Filter osgiFilter = this.createFilter(bundleContext, clazz, props);
            serviceTracker = new ServiceTracker(bundleContext, osgiFilter, null);
            serviceTracker.open();
            Object object = serviceTracker.getServices()[0];
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> getOSGiServices(Class clazz, Hashtable<String, String> props) {
        ArrayList<Object> services = new ArrayList<Object>();
        try (ServiceTracker serviceTracker = null;){
            BundleContext bundleContext = dataHolder.getBundleContext();
            Filter osgiFilter = this.createFilter(bundleContext, clazz, props);
            serviceTracker = new ServiceTracker(bundleContext, osgiFilter, null);
            serviceTracker.open();
            Collections.addAll(services, serviceTracker.getServices());
        }
        return services;
    }

    public void setApplicationName(String applicationName) {
        this.getCarbonContextDataHolder().setApplicationName(applicationName);
    }
}

