/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiMessageReceiver
extends Thread {
    private Log log = LogFactory.getLog(MultiMessageReceiver.class);
    private int port;
    private ServerSocket providerSocket;
    private Socket connection = null;
    private boolean stopServer = false;
    private List<String> incomingMessages;

    public MultiMessageReceiver(int port) {
        this.port = port;
        this.incomingMessages = new ArrayList<String>();
    }

    public void stopServer() {
        this.stopServer = true;
    }

    public void startServer() {
        new Thread(this).start();
    }

    public List<String> getIncomingMessages() throws InterruptedException {
        return this.incomingMessages;
    }

    public synchronized int getMessageQueueSize() {
        return this.incomingMessages.size();
    }

    @Override
    public void run() {
        try {
            this.providerSocket = new ServerSocket(this.port, 10);
            this.providerSocket.setSoTimeout(5000);
            while (!this.stopServer) {
                try {
                    this.connection = this.providerSocket.accept();
                }
                catch (SocketTimeoutException e) {
                    this.log.info((Object)"........Socket is timed out..........");
                    continue;
                }
                Reader reader = new Reader();
                reader.connectionReceived = this.connection;
                new Thread(reader).start();
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        finally {
            try {
                this.providerSocket.close();
            }
            catch (Exception exception) {}
        }
        this.log.info((Object)"Closing connection");
    }

    class Reader
    implements Runnable {
        private Socket connectionReceived;
        private String response = "";

        Reader() {
        }

        @Override
        public void run() {
            MultiMessageReceiver.this.log.info((Object)("Connection received from " + this.connectionReceived.getInetAddress().getHostName()));
            BufferedReader rd = null;
            try {
                rd = new BufferedReader(new InputStreamReader(this.connectionReceived.getInputStream()));
                String line = "";
                while ((line = rd.readLine()) != null) {
                    this.response = this.response + line;
                }
            }
            catch (IOException e) {
                MultiMessageReceiver.this.log.error((Object)("Error while reading the input stream" + e.getMessage()));
            }
            MultiMessageReceiver.this.log.info((Object)"..............................................");
            MultiMessageReceiver.this.log.info((Object)this.response);
            MultiMessageReceiver.this.log.info((Object)"..............................................");
            MultiMessageReceiver.this.incomingMessages.add(this.response);
            try {
                rd.close();
                this.connectionReceived.close();
            }
            catch (IOException e) {
                MultiMessageReceiver.this.log.error((Object)"Error while closing the connection");
            }
        }
    }
}

