/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.impl;

import javax.cache.spi.AnnotationProvider;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.caching.impl.AnnotationProviderImpl;
import org.wso2.carbon.caching.impl.CachingProviderImpl;
import org.wso2.carbon.caching.impl.DistributedMapProvider;

public class DataHolder {
    private static final Log log = LogFactory.getLog(DataHolder.class);
    private static DataHolder instance = new DataHolder();
    private DistributedMapProvider distributedMapProvider;
    private ServerConfigurationService serverConfigurationService;
    private ClusteringAgent clusteringAgent;
    private CachingProviderImpl cachingProvider = new CachingProviderImpl();
    private AnnotationProvider annotationProvider = new AnnotationProviderImpl();

    public static DataHolder getInstance() {
        return instance;
    }

    private DataHolder() {
    }

    public DistributedMapProvider getDistributedMapProvider() {
        return this.distributedMapProvider;
    }

    public ServerConfigurationService getServerConfigurationService() {
        if (this.serverConfigurationService == null) {
            String msg = "Before activating javax caching  bundle, an instance of ServerConfigurationService should be in existence";
            log.error((Object)msg);
        }
        return this.serverConfigurationService;
    }

    public void setDistributedMapProvider(DistributedMapProvider distributedMapProvider) {
        this.distributedMapProvider = distributedMapProvider;
        try {
            if (distributedMapProvider != null) {
                this.cachingProvider.switchToDistributedMode();
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot setDistributedMapProvider", (Throwable)e);
        }
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setClusteringAgent(ClusteringAgent clusteringAgent) {
        this.clusteringAgent = clusteringAgent;
    }

    public CachingProviderImpl getCachingProvider() {
        return this.cachingProvider;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public ClusteringAgent getClusteringAgent() {
        return this.clusteringAgent;
    }
}

