/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2.generate.feature;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.maven.p2.generate.feature.AdviceFile;
import org.wso2.maven.p2.generate.feature.Bundle;
import org.wso2.maven.p2.generate.feature.ImportBundle;
import org.wso2.maven.p2.generate.feature.ImportFeature;
import org.wso2.maven.p2.generate.feature.IncludedFeature;
import org.wso2.maven.p2.generate.feature.Property;
import org.wso2.maven.p2.generate.utils.FileManagementUtil;
import org.wso2.maven.p2.generate.utils.MavenUtils;
import org.wso2.maven.p2.generate.utils.P2Utils;
import org.wso2.maven.p2.generate.utils.PropertyReplacer;

public class FeatureGenMojo
extends AbstractMojo {
    private String id;
    private String version;
    private String label;
    private String description;
    private String providerName;
    private String copyright;
    private String licenceUrl;
    private String licence;
    private File manifest;
    private File propertiesFile;
    private Properties properties;
    private ArrayList bundles;
    private ArrayList importBundles;
    private ArrayList importFeatures;
    private ArrayList includedFeatures;
    private AdviceFile adviceFile;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private ArtifactRepository deploymentRepository;
    private ArtifactMetadataSource artifactMetadataSource;
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private ArrayList<Bundle> processedBundles;
    private ArrayList<ImportBundle> processedImportBundles;
    private ArrayList<ImportFeature> processedImportfeatures;
    private ArrayList<Property> processedAdviceProperties;
    private ArrayList<IncludedFeature> processedIncludedFeatures;
    private File destFolder;
    private File featureBaseDir;
    private File featuresDir;
    private File FOLDER_FEATURES_FEATURE;
    private File pluginsDir;
    private File FOLDER_RESOURCES;
    private File FILE_FEATURE_XML;
    private File FILE_P2_INF;
    private File FILE_FEATURE_PROPERTIES;
    private File FILE_FEATURE_MANIFEST;
    private File FILE_FEATURE_ZIP;
    private boolean isPropertiesLoadedFromFile = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getProcessedBundlesList();
        this.getProcessedImportBundlesList();
        this.getProcessedImportFeaturesList();
        this.getProcessedAdviceProperties();
        this.createAndSetupPaths();
        this.copyResources();
        this.createFeatureXml();
        this.createPropertiesFile();
        this.createManifestMFFile();
        this.createP2Inf();
        this.copyAllDependencies();
        this.createArchive();
        this.deployArtifact();
        this.performMopUp();
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    private ArrayList<Bundle> getProcessedBundlesList() throws MojoExecutionException {
        if (this.processedBundles != null) {
            return this.processedBundles;
        }
        if (this.bundles == null || this.bundles.size() == 0) {
            return null;
        }
        this.processedBundles = new ArrayList();
        for (Object obj : this.bundles) {
            Bundle b = obj instanceof Bundle ? (Bundle)obj : (obj instanceof String ? Bundle.getBundle(obj.toString()) : (Bundle)obj);
            b.resolveVersion(this.project);
            b.setArtifact(this.getResolvedArtifact(b));
            this.processedBundles.add(b);
        }
        return this.processedBundles;
    }

    private ArrayList<ImportBundle> getProcessedImportBundlesList() throws MojoExecutionException {
        if (this.processedImportBundles != null) {
            return this.processedImportBundles;
        }
        if (this.importBundles == null || this.importBundles.size() == 0) {
            return null;
        }
        this.processedImportBundles = new ArrayList();
        for (Object obj : this.importBundles) {
            ImportBundle b = obj instanceof ImportBundle ? (ImportBundle)obj : (obj instanceof String ? ImportBundle.getBundle(obj.toString()) : (ImportBundle)obj);
            b.resolveVersion(this.project);
            if (!b.isExclude()) {
                b.setArtifact(this.getResolvedArtifact(b));
            } else {
                b.resolveOSGIInfo();
            }
            this.processedImportBundles.add(b);
        }
        return this.processedImportBundles;
    }

    private ArrayList<ImportFeature> getProcessedImportFeaturesList() throws MojoExecutionException {
        if (this.processedImportfeatures != null) {
            return this.processedImportfeatures;
        }
        if (this.importFeatures == null || this.importFeatures.size() == 0) {
            return null;
        }
        this.processedImportfeatures = new ArrayList();
        for (Object obj : this.importFeatures) {
            ImportFeature f = obj instanceof ImportFeature ? (ImportFeature)obj : (obj instanceof String ? ImportFeature.getFeature(obj.toString()) : (ImportFeature)obj);
            f.setFeatureVersion(this.project.getVersion());
            this.processedImportfeatures.add(f);
        }
        return this.processedImportfeatures;
    }

    private ArrayList<IncludedFeature> getIncludedFeatures() throws MojoExecutionException {
        if (this.processedIncludedFeatures != null) {
            return this.processedIncludedFeatures;
        }
        if (this.includedFeatures == null || this.includedFeatures.size() == 0) {
            return null;
        }
        this.processedIncludedFeatures = new ArrayList(this.includedFeatures.size());
        for (Object obj : this.includedFeatures) {
            IncludedFeature includedFeature;
            if (!(obj instanceof String) || (includedFeature = IncludedFeature.getIncludedFeature((String)obj)) == null) continue;
            includedFeature.setFeatureVersion(this.project.getVersion());
            Artifact artifact = this.artifactFactory.createArtifact(includedFeature.getGroupId(), includedFeature.getArtifactId(), includedFeature.getArtifactVersion(), "runtime", "zip");
            includedFeature.setArtifact(MavenUtils.getResolvedArtifact(artifact, this.remoteRepositories, this.localRepository, this.resolver));
            this.processedIncludedFeatures.add(includedFeature);
        }
        return this.processedIncludedFeatures;
    }

    private Artifact getResolvedArtifact(Bundle bundle) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createArtifact(bundle.getGroupId(), bundle.getArtifactId(), bundle.getVersion(), "runtime", "jar");
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("ERROR", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("ERROR", (Exception)((Object)e));
        }
        return artifact;
    }

    private void createAndSetupPaths() {
        this.destFolder = new File(this.project.getBasedir(), "target");
        this.featureBaseDir = new File(this.destFolder, "raw");
        this.featuresDir = new File(this.featureBaseDir, "features");
        this.FOLDER_FEATURES_FEATURE = new File(this.featuresDir, this.id + "_" + Bundle.getOSGIVersion(this.getVersion()));
        this.pluginsDir = new File(this.featureBaseDir, "plugins");
        this.FOLDER_RESOURCES = new File(this.project.getBasedir(), "src");
        File FOLDER_FEATURES_FEATURE_META_INF = new File(this.FOLDER_FEATURES_FEATURE, "META-INF");
        this.FILE_FEATURE_XML = new File(this.FOLDER_FEATURES_FEATURE, "feature.xml");
        this.FILE_FEATURE_PROPERTIES = new File(this.FOLDER_FEATURES_FEATURE, "feature.properties");
        this.FILE_P2_INF = new File(this.FOLDER_FEATURES_FEATURE, "p2.inf");
        this.FILE_FEATURE_MANIFEST = new File(FOLDER_FEATURES_FEATURE_META_INF, "MANIFEST.MF");
        this.FILE_FEATURE_ZIP = new File(this.destFolder, this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip");
        FOLDER_FEATURES_FEATURE_META_INF.mkdirs();
        this.pluginsDir.mkdirs();
    }

    private Document getManifestDocument() throws MojoExecutionException {
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new MojoExecutionException("Unable to load feature manifest", (Exception)e1);
        }
        if (this.getManifest() != null && this.getManifest().exists()) {
            try {
                document = documentBuilder.parse(new FileInputStream(this.getManifest()));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to load feature manifest", e);
            }
        } else {
            document = documentBuilder.newDocument();
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private void createFeatureXml() throws MojoExecutionException {
        Node license;
        Node copyright;
        Node description;
        NodeList descriptionTags;
        this.getLog().info((CharSequence)"Generating feature manifest");
        Document document = this.getManifestDocument();
        Element rootElement = document.getDocumentElement();
        if (rootElement == null) {
            rootElement = document.createElement("feature");
            document.appendChild(rootElement);
        }
        if (!rootElement.hasAttribute("id")) {
            rootElement.setAttribute("id", this.id);
        }
        if (!rootElement.hasAttribute("label")) {
            rootElement.setAttribute("label", this.getLabel());
        }
        if (!rootElement.hasAttribute("version")) {
            rootElement.setAttribute("version", Bundle.getOSGIVersion(this.getVersion()));
        }
        if (!rootElement.hasAttribute("provider-name")) {
            rootElement.setAttribute("provider-name", this.getProviderName());
        }
        if ((descriptionTags = rootElement.getElementsByTagName("description")).getLength() == 0) {
            description = document.createElement("description");
            description.setTextContent(this.getDescription());
            rootElement.appendChild(description);
        } else {
            description = descriptionTags.item(0);
        }
        NodeList copyrightTags = rootElement.getElementsByTagName("copyright");
        if (copyrightTags.getLength() == 0) {
            copyright = document.createElement("copyright");
            copyright.setTextContent(this.getCopyright());
            rootElement.appendChild(copyright);
        } else {
            copyright = copyrightTags.item(0);
        }
        NodeList licenseTags = rootElement.getElementsByTagName("license");
        if (licenseTags.getLength() == 0) {
            license = document.createElement("license");
            license.setAttribute("url", this.getLicenceUrl());
            license.setTextContent(this.getLicence());
            rootElement.appendChild(license);
        } else {
            license = licenseTags.item(0);
        }
        ArrayList<Object> processedMissingPlugins = this.getMissingPlugins(document);
        ArrayList<Object> processedMissingImportPlugins = this.getMissingImportPlugins(document);
        ArrayList<Object> processedMissingImportFeatures = this.getMissingImportFeatures(document);
        ArrayList<IncludedFeature> includedFeatures = this.getIncludedFeatures();
        if (processedMissingPlugins != null) {
            for (Bundle bundle : processedMissingPlugins) {
                Element plugin = document.createElement("plugin");
                plugin.setAttribute("id", bundle.getBundleSymbolicName());
                plugin.setAttribute("version", bundle.getBundleVersion());
                plugin.setAttribute("unpack", "false");
                rootElement.appendChild(plugin);
            }
        }
        if (processedMissingImportPlugins != null || processedMissingImportFeatures != null) {
            void var14_18;
            NodeList requireNodes = document.getElementsByTagName("require");
            if (requireNodes == null || requireNodes.getLength() == 0) {
                Element element = document.createElement("require");
                rootElement.appendChild(element);
            } else {
                Node node = requireNodes.item(0);
            }
            if (processedMissingImportPlugins != null) {
                for (ImportBundle importBundle : processedMissingImportPlugins) {
                    Element plugin = document.createElement("import");
                    plugin.setAttribute("plugin", importBundle.getBundleSymbolicName());
                    plugin.setAttribute("version", importBundle.getBundleVersion());
                    plugin.setAttribute("match", P2Utils.getMatchRule(importBundle.getCompatibility()));
                    var14_18.appendChild(plugin);
                }
            }
            if (processedMissingImportFeatures != null) {
                for (Object object : processedMissingImportFeatures) {
                    ImportFeature feature = (ImportFeature)object;
                    if (feature.isOptional()) continue;
                    Element plugin = document.createElement("import");
                    plugin.setAttribute("feature", feature.getFeatureId());
                    plugin.setAttribute("version", feature.getFeatureVersion());
                    if (P2Utils.isPatch(feature.getCompatibility())) {
                        plugin.setAttribute("patch", "true");
                    } else {
                        plugin.setAttribute("match", P2Utils.getMatchRule(feature.getCompatibility()));
                    }
                    var14_18.appendChild(plugin);
                }
            }
        }
        if (includedFeatures != null) {
            for (IncludedFeature includedFeature : includedFeatures) {
                Element includeElement = document.createElement("includes");
                includeElement.setAttribute("id", includedFeature.getFeatureID());
                includeElement.setAttribute("version", includedFeature.getFeatureVersion());
                includeElement.setAttribute("optional", Boolean.toString(includedFeature.isOptional()));
                rootElement.appendChild(includeElement);
            }
        }
        if (processedMissingImportFeatures != null) {
            for (Object object : processedMissingImportFeatures) {
                ImportFeature feature = (ImportFeature)object;
                if (!feature.isOptional()) continue;
                Element element = document.createElement("includes");
                element.setAttribute("id", feature.getFeatureId());
                element.setAttribute("version", feature.getFeatureVersion());
                element.setAttribute("optional", Boolean.toString(feature.isOptional()));
                rootElement.appendChild(element);
            }
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult streamResult = new StreamResult(this.FILE_FEATURE_XML);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, streamResult);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create feature manifest", e);
        }
    }

    private ArrayList<Object> getMissingPlugins(Document document) throws MojoExecutionException {
        HashMap<String, Bundle> missingPlugins = new HashMap<String, Bundle>();
        ArrayList<Bundle> processedBundlesList = this.getProcessedBundlesList();
        if (processedBundlesList == null) {
            return null;
        }
        for (Bundle bundle : processedBundlesList) {
            missingPlugins.put(bundle.getArtifactId(), bundle);
        }
        NodeList existingPlugins = document.getDocumentElement().getElementsByTagName("plugin");
        for (int i = 0; i < existingPlugins.getLength(); ++i) {
            Node node = existingPlugins.item(i);
            Node namedItem = node.getAttributes().getNamedItem("id");
            if (namedItem == null || namedItem.getTextContent() == null || !missingPlugins.containsKey(namedItem.getTextContent())) continue;
            missingPlugins.remove(namedItem.getTextContent());
        }
        return this.returnArrayList(missingPlugins.values().toArray());
    }

    private void createPropertiesFile() throws MojoExecutionException {
        Properties props = this.getProperties();
        if (props == null) {
            return;
        }
        if (!props.isEmpty()) {
            try {
                this.getLog().info((CharSequence)"Generating feature properties");
                props.store(new FileOutputStream(this.FILE_FEATURE_PROPERTIES), "Properties of " + this.id);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to create the feature properties", e);
            }
        }
    }

    private void createManifestMFFile() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Generating MANIFEST.MF");
            BufferedWriter out = new BufferedWriter(new FileWriter(this.FILE_FEATURE_MANIFEST));
            out.write("Manifest-Version: 1.0\n\n");
            out.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create manifest file", e);
        }
    }

    private void createP2Inf() throws MojoExecutionException {
        BufferedWriter out = null;
        List<String> p2infStringList = null;
        try {
            ArrayList<Property> list = this.getProcessedAdviceProperties();
            if (this.FILE_P2_INF.exists()) {
                p2infStringList = this.readAdviceFile(this.FILE_P2_INF.getAbsolutePath());
                this.getLog().info((CharSequence)"Updating Advice file (p2.inf)");
            } else {
                this.getLog().info((CharSequence)"Generating Advice file (p2.inf)");
            }
            out = new BufferedWriter(new FileWriter(this.FILE_P2_INF.getAbsolutePath()));
            Properties properties = new Properties();
            properties.setProperty("feature.version", Bundle.getOSGIVersion(this.getVersion()));
            if (p2infStringList != null && p2infStringList.size() > 0) {
                for (String str : p2infStringList) {
                    out.write(PropertyReplacer.replaceProperties(str, properties) + "\n");
                }
            }
            if (list.size() == 0) {
                return;
            }
            int nextIndex = P2Utils.getLastIndexOfProperties(this.FILE_P2_INF) + 1;
            Iterator<Property> iterator = list.iterator();
            while (iterator.hasNext()) {
                Property category;
                Property cat = category = iterator.next();
                out.write("\nproperties." + nextIndex + ".name=" + cat.getKey());
                out.write("\nproperties." + nextIndex + ".value=" + cat.getValue());
                ++nextIndex;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create/open p2.inf file", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to finalize p2.inf file", (Exception)e);
                }
            }
        }
    }

    private List<String> readAdviceFile(String absolutePath) throws MojoExecutionException {
        ArrayList<String> stringList = new ArrayList<String>();
        String inputLine = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(absolutePath));
            while ((inputLine = br.readLine()) != null) {
                stringList.add(inputLine);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Unable to create/open p2.inf file", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while reading from p2.inf file", (Exception)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to finalize p2.inf file", (Exception)e);
                }
            }
        }
        return stringList;
    }

    private ArrayList<Object> getMissingImportPlugins(Document document) throws MojoExecutionException {
        HashMap<String, ImportBundle> missingImportPlugins = new HashMap<String, ImportBundle>();
        ArrayList<ImportBundle> processedImportBundlesList = this.getProcessedImportBundlesList();
        if (processedImportBundlesList == null) {
            return null;
        }
        for (ImportBundle bundle : processedImportBundlesList) {
            missingImportPlugins.put(bundle.getArtifactId(), bundle);
        }
        NodeList requireNodeList = document.getDocumentElement().getElementsByTagName("require");
        if (requireNodeList == null || requireNodeList.getLength() == 0) {
            return this.returnArrayList(missingImportPlugins.values().toArray());
        }
        Node requireNode = requireNodeList.item(0);
        if (requireNode instanceof Element) {
            Element requireElement = (Element)requireNode;
            NodeList importNodes = requireElement.getElementsByTagName("import");
            if (importNodes == null) {
                return this.returnArrayList(missingImportPlugins.values().toArray());
            }
            for (int i = 0; i < importNodes.getLength(); ++i) {
                Node node = importNodes.item(i);
                Node namedItem = node.getAttributes().getNamedItem("plugin");
                if (namedItem == null || namedItem.getTextContent() == null || !missingImportPlugins.containsKey(namedItem.getTextContent())) continue;
                missingImportPlugins.remove(namedItem.getTextContent());
            }
        }
        return this.returnArrayList(missingImportPlugins.values().toArray());
    }

    private ArrayList<Object> getMissingImportFeatures(Document document) throws MojoExecutionException {
        HashMap<String, ImportFeature> missingImportFeatures = new HashMap<String, ImportFeature>();
        ArrayList<ImportFeature> processedImportFeaturesList = this.getProcessedImportFeaturesList();
        if (processedImportFeaturesList == null) {
            return null;
        }
        for (ImportFeature feature : processedImportFeaturesList) {
            missingImportFeatures.put(feature.getFeatureId(), feature);
        }
        NodeList requireNodeList = document.getDocumentElement().getElementsByTagName("require");
        if (requireNodeList == null || requireNodeList.getLength() == 0) {
            return this.returnArrayList(missingImportFeatures.values().toArray());
        }
        Node requireNode = requireNodeList.item(0);
        if (requireNode instanceof Element) {
            Element requireElement = (Element)requireNode;
            NodeList importNodes = requireElement.getElementsByTagName("import");
            if (importNodes == null) {
                return this.returnArrayList(missingImportFeatures.values().toArray());
            }
            for (int i = 0; i < importNodes.getLength(); ++i) {
                Node node = importNodes.item(i);
                Node namedItem = node.getAttributes().getNamedItem("feature");
                if (namedItem == null || namedItem.getTextContent() == null || !missingImportFeatures.containsKey(namedItem.getTextContent())) continue;
                missingImportFeatures.remove(namedItem.getTextContent());
            }
        }
        return this.returnArrayList(missingImportFeatures.values().toArray());
    }

    private ArrayList<Object> returnArrayList(Object[] arr) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : arr) {
            arrayList.add(object);
        }
        return arrayList;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setCopyright(String copyrite) {
        this.copyright = copyrite;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setLicenceUrl(String licenceUrl) {
        this.licenceUrl = licenceUrl;
    }

    public String getLicenceUrl() {
        return this.licenceUrl;
    }

    public void setLicence(String licence) {
        this.licence = licence;
    }

    public String getLicence() {
        return this.licence;
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public File getManifest() {
        return this.manifest;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() throws MojoExecutionException {
        if (!this.isPropertiesLoadedFromFile) {
            this.isPropertiesLoadedFromFile = true;
            if (this.getPropertiesFile() != null && this.getPropertiesFile().exists()) {
                Properties props = new Properties();
                try {
                    props.load(new FileInputStream(this.getPropertiesFile()));
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Unable to load the given properties file", e);
                }
                if (this.properties != null) {
                    for (Object key : this.properties.keySet().toArray()) {
                        props.setProperty(key.toString(), this.properties.getProperty(key.toString()));
                    }
                }
                this.setProperties(props);
            }
        }
        return this.properties;
    }

    private ArrayList<Property> getProcessedAdviceProperties() throws MojoExecutionException {
        if (this.processedAdviceProperties != null) {
            return this.processedAdviceProperties;
        }
        this.processedAdviceProperties = new ArrayList();
        if (this.adviceFile != null && this.adviceFile.getProperties() != null) {
            for (Object property : this.adviceFile.getProperties()) {
                Property prop = null;
                if (property instanceof Property) {
                    prop = (Property)property;
                } else if (property instanceof String) {
                    prop = Property.getProperty(property.toString());
                } else {
                    throw new MojoExecutionException("Unknown advice property definition: " + property.toString());
                }
                this.processedAdviceProperties.add(prop);
            }
        }
        return this.processedAdviceProperties;
    }

    private void copyAllDependencies() throws MojoExecutionException {
        ArrayList<ImportBundle> processedImportBundlesList;
        ArrayList<Bundle> processedBundlesList = this.getProcessedBundlesList();
        if (processedBundlesList != null) {
            this.getLog().info((CharSequence)"Copying bundle dependencies");
            for (Bundle bundle : processedBundlesList) {
                try {
                    this.getLog().info((CharSequence)("   " + bundle.toOSGIString()));
                    String bundleName = bundle.getBundleSymbolicName() + "-" + bundle.getBundleVersion() + ".jar";
                    FileUtils.copyFile((File)bundle.getArtifact().getFile(), (File)new File(this.pluginsDir, bundleName));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable copy dependency: " + bundle.getArtifactId(), (Exception)e);
                }
            }
        }
        if ((processedImportBundlesList = this.getProcessedImportBundlesList()) != null) {
            this.getLog().info((CharSequence)"Copying import bundle dependencies");
            for (ImportBundle bundle : processedImportBundlesList) {
                try {
                    if (bundle.isExclude()) continue;
                    this.getLog().info((CharSequence)("   " + bundle.toOSGIString()));
                    String bundleName = bundle.getBundleSymbolicName() + "-" + bundle.getBundleVersion() + ".jar";
                    FileUtils.copyFile((File)bundle.getArtifact().getFile(), (File)new File(this.pluginsDir, bundleName));
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable copy import dependency: " + bundle.getArtifactId(), (Exception)e);
                }
            }
        }
        if (this.processedIncludedFeatures != null) {
            for (IncludedFeature includedFeature : this.processedIncludedFeatures) {
                try {
                    this.getLog().info((CharSequence)("Extracting feature " + includedFeature.getGroupId() + ":" + includedFeature.getArtifactId()));
                    FileManagementUtil.unzip(includedFeature.getArtifact().getFile(), this.featureBaseDir);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error occured when extracting the Feature Artifact: " + includedFeature.getGroupId() + ":" + includedFeature.getArtifactId(), e);
                }
            }
        }
    }

    private void createArchive() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Generating feature archive: " + this.FILE_FEATURE_ZIP.getAbsolutePath()));
        FileManagementUtil.zipFolder(this.featureBaseDir.getAbsolutePath(), this.FILE_FEATURE_ZIP.getAbsolutePath());
    }

    private void deployArtifact() {
        if (this.FILE_FEATURE_ZIP != null && this.FILE_FEATURE_ZIP.exists()) {
            this.project.getArtifact().setFile(this.FILE_FEATURE_ZIP);
            this.projectHelper.attachArtifact(this.project, "zip", null, this.FILE_FEATURE_ZIP);
        }
    }

    private void copyResources() throws MojoExecutionException {
        List resources = this.project.getResources();
        for (Resource resource : resources) {
            String sourcePath = resource.getDirectory();
            if (!new File(sourcePath).exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(resource.getDirectory());
            if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                scanner.setIncludes(resource.getIncludes().toArray(new String[0]));
            } else {
                scanner.setIncludes(new String[]{"**/**"});
            }
            List excludes = resource.getExcludes();
            if (excludes != null && !excludes.isEmpty()) {
                scanner.setExcludes(excludes.toArray(new String[0]));
            }
            scanner.addDefaultExcludes();
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            this.getLog().info((CharSequence)("   " + resource.getDirectory()));
            for (String name : includedFiles) {
                File fromPath = new File(sourcePath, name);
                File toPath = new File(this.FOLDER_FEATURES_FEATURE, name);
                try {
                    if (fromPath.isDirectory() && !toPath.exists()) {
                        toPath.mkdirs();
                        continue;
                    }
                    FileManagementUtil.copy(fromPath, toPath);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable copy resources: " + resource.getDirectory(), (Exception)e);
                }
            }
        }
    }

    private void performMopUp() {
        try {
            FileUtils.deleteDirectory((File)this.featureBaseDir);
        }
        catch (Exception e) {
            this.getLog().warn((Throwable)new MojoExecutionException("Unable complete mop up operation", e));
        }
    }
}

