/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.car.artifact;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.json.JSONObject;
import org.wso2.maven.car.artifact.CAppHandler;
import org.wso2.maven.car.artifact.impl.CAppMgtApiHelperServiceImpl;

public class MICAppHandler
implements CAppHandler {
    private final CAppMgtApiHelperServiceImpl capppMgtApiHelperServiceImpl;
    private final Log logger;

    public MICAppHandler(Log logger) {
        this.logger = logger;
        this.capppMgtApiHelperServiceImpl = new CAppMgtApiHelperServiceImpl();
    }

    @Override
    public void deployCApp(String username, String password, String serverUrl, File carFile) throws Exception {
        JSONObject resObj = this.capppMgtApiHelperServiceImpl.doAuthenticate(serverUrl, username, password);
        if (resObj != null) {
            this.logger.info((CharSequence)("Authentication to " + serverUrl + " successful."));
            String accessToken = resObj.getString("AccessToken");
            if (MICAppHandler.isNotBlank(accessToken) && this.capppMgtApiHelperServiceImpl.deployCApp(carFile, accessToken, serverUrl)) {
                this.logger.info((CharSequence)("Uploaded " + carFile.getName() + " to " + serverUrl + " ..."));
            }
        }
    }

    @Override
    public void unDeployCApp(String username, String password, String serverUrl, MavenProject project) throws Exception {
        JSONObject resObj = this.capppMgtApiHelperServiceImpl.doAuthenticate(serverUrl, username, password);
        if (resObj != null) {
            this.logger.info((CharSequence)("Authentication to " + serverUrl + " successful."));
            String accessToken = resObj.getString("AccessToken");
            if (MICAppHandler.isNotBlank(accessToken) && this.capppMgtApiHelperServiceImpl.unDeployCApp(accessToken, serverUrl, project.getArtifactId() + "_" + project.getVersion())) {
                this.logger.info((CharSequence)("Located the C-App " + project.getArtifactId() + "_" + project.getVersion() + " and undeployed ..."));
            }
        }
    }

    private static boolean isNotBlank(String accessToken) {
        return accessToken != null && !accessToken.trim().isEmpty();
    }
}

