/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.capp.model;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.maven.capp.model.ArtifactDependency;
import org.wso2.maven.core.model.AbstractXMLDoc;

public class Artifact
extends AbstractXMLDoc
implements Observer {
    String name;
    String version;
    String serverRole;
    String type;
    String file;
    private Artifact parent;
    private boolean anonymouse = false;
    List<ArtifactDependency> dependencies;
    List<Artifact> subArtifacts;
    private long modificationStamp;
    private boolean superArtifact = false;
    private File source;
    private Map<Artifact, ArtifactDependency> allPosibleLocalDependencies;
    private String carTimestamp = "";
    private List<OMElement> dependenciesElements;
    private String timestampedVersion;
    private List<Observer> observers;

    public Artifact() {
    }

    public Artifact(File source) {
        this.setSource(source);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getServerRole() {
        return this.serverRole;
    }

    public void setServerRole(String serverRole) {
        this.serverRole = serverRole;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public File getFile() {
        return new File(this.getSource().getParentFile(), this.file);
    }

    public void setFile(String file) {
        this.file = file;
    }

    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
        this.getObservers().add(o);
    }

    public synchronized void deleteObserver(Observer o) {
        super.deleteObserver(o);
        this.getObservers().remove(o);
    }

    public synchronized void deleteObservers() {
        super.deleteObservers();
        this.getObservers().clear();
    }

    public List<ArtifactDependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ArtifactDependency>();
            if (this.dependenciesElements != null) {
                for (OMElement element : this.dependenciesElements) {
                    String dependancyName = this.getAttribute(element, "artifact");
                    String dependencyVersion = this.getAttribute(element, "version");
                    String includeStr = this.getAttribute(element, "include");
                    boolean isInclude = false;
                    if (includeStr != null) {
                        isInclude = Boolean.parseBoolean(includeStr);
                    }
                    ArtifactDependency artifactDependency = new ArtifactDependency(this);
                    artifactDependency.setName(dependancyName);
                    artifactDependency.setVersion(dependencyVersion);
                    artifactDependency.setInclude(isInclude);
                    String serverRole = this.getAttribute(element, "serverRole");
                    if (serverRole != null && !serverRole.equals("")) {
                        artifactDependency.setServerRole(serverRole);
                    }
                    this.getDependencies().add(artifactDependency);
                }
            }
        }
        return this.dependencies;
    }

    public void setDependencies(List<ArtifactDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public List<Artifact> getSubArtifacts() {
        if (this.subArtifacts == null) {
            this.subArtifacts = new ArrayList<Artifact>();
        }
        return this.subArtifacts;
    }

    public void setSubArtifacts(List<Artifact> subArtifacts) {
        this.subArtifacts = subArtifacts;
    }

    public String serialize() {
        String result = null;
        OMDocument document = factory.createOMDocument();
        OMElement documentElement = this.getDocumentElement();
        document.addChild((OMNode)documentElement);
        try {
            result = this.getPretifiedString(documentElement);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }

    protected void deserialize(OMElement documentElement) {
        this.setName(this.getAttribute(documentElement, "name"));
        this.setVersion(this.getAttribute(documentElement, "version"));
        this.setType(this.getAttribute(documentElement, "type"));
        this.setServerRole(this.getAttribute(documentElement, "serverRole"));
        List elements = this.getChildElements(documentElement, "file");
        if (elements.size() > 0) {
            this.setFile(((OMElement)elements.get(0)).getText());
        }
        this.setDependencies(null);
        this.dependenciesElements = this.getChildElements(documentElement, "dependency");
        this.getSubArtifacts().clear();
        elements = this.getChildElements(documentElement, "subArtifacts");
        if (elements.size() > 0) {
            elements = this.getChildElements((OMElement)elements.get(0), "artifact");
            for (OMElement element : elements) {
                Artifact artifact = new Artifact(null);
                artifact.deserialize(element);
                artifact.setParent(this);
                this.getSubArtifacts().add(artifact);
            }
        }
    }

    public OMElement getDocumentElement() {
        OMElement documentElement = this.getElement("artifact", "");
        if (!this.isAnonymouse()) {
            this.addAttribute(documentElement, "name", this.name);
        }
        if (!this.isAnonymouse() && this.version != null) {
            this.addAttribute(documentElement, "version", this.version);
        }
        if (this.type != null) {
            this.addAttribute(documentElement, "type", this.type);
        }
        if (this.serverRole != null) {
            this.addAttribute(documentElement, "serverRole", this.serverRole);
        }
        if (this.file != null) {
            documentElement.addChild((OMNode)this.getElement("file", this.file));
        }
        for (ArtifactDependency dependency : this.getDependencies()) {
            OMElement dependecyElement = this.getElement("dependency", "");
            dependecyElement = this.addAttribute(dependecyElement, "artifact", dependency.getName());
            dependecyElement = this.addAttribute(dependecyElement, "version", dependency.getVersion());
            if (dependency.isInclude()) {
                dependecyElement = this.addAttribute(dependecyElement, "include", Boolean.toString(dependency.isInclude()));
            }
            if (dependency.getServerRole() != null) {
                dependecyElement = this.addAttribute(dependecyElement, "serverRole", dependency.getServerRole());
            }
            documentElement.addChild((OMNode)dependecyElement);
        }
        if (this.getSubArtifacts().size() > 0) {
            OMElement subArtifactElement = this.getElement("subArtifacts", "");
            for (Artifact subArtifact : this.getSubArtifacts()) {
                subArtifactElement.addChild((OMNode)subArtifact.getDocumentElement());
            }
            documentElement.addChild((OMNode)subArtifactElement);
        }
        return documentElement;
    }

    public void setAnonymouse(boolean anonymouse) {
        this.anonymouse = anonymouse;
    }

    public boolean isAnonymouse() {
        return this.name == null || this.anonymouse;
    }

    public Artifact clone() {
        Artifact artifact = new Artifact(this.getSource());
        return this.clone(artifact);
    }

    public Artifact clone(Artifact artifact) {
        try {
            artifact.deserialize(this.serialize());
            artifact.setDependencies(this.getDependencies());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        artifact.setModificationStamp(this.getModificationStamp());
        return artifact;
    }

    public Artifact cloneData() {
        Artifact artifact = new Artifact(this.getSource());
        return this.cloneData(artifact);
    }

    public Artifact cloneData(Artifact artifact) {
        try {
            artifact.deserialize(this.serialize());
            artifact.setSuperArtifact(this.isSuperArtifact());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        artifact.setModificationStamp(this.getModificationStamp());
        return artifact;
    }

    public void setParent(Artifact parent) {
        this.parent = parent;
    }

    public Artifact getParent() {
        return this.parent;
    }

    public String getCaption() {
        return this.getName() + " - " + this.getVersion() + "";
    }

    public String getDefaultName() {
        return "artifact.xml";
    }

    public void setModificationStamp(long modificationStamp) {
        this.modificationStamp = modificationStamp;
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public void setSuperArtifact(boolean superArtifact) {
        this.superArtifact = superArtifact;
    }

    public boolean isSuperArtifact() {
        return this.superArtifact;
    }

    public boolean isEqual(String name, String version, String serverRole) {
        return this.isEqual(name, version) && this.getServerRole().equals(serverRole);
    }

    public boolean isEqual(String name, String version) {
        return this.getName().equals(name) && this.getVersion().equals(version);
    }

    public void setSource(File source) {
        this.source = source;
    }

    public File getSource() {
        return this.source;
    }

    public void fromFile(File file) throws FactoryConfigurationError, Exception {
        this.setSource(file);
        if (this.getSource().exists()) {
            this.deserialize(this.getSource());
            this.setModificationStamp(this.getSource().lastModified());
        }
    }

    private void updated() {
        this.setChanged();
        this.notifyObservers();
    }

    public void notifySourceModification() {
        this.updated();
    }

    public File toFile() throws Exception {
        File savedFile = new File(this.toFile(this.getSource()).toString());
        this.updated();
        return savedFile;
    }

    public void release() {
    }

    public void removeDependencies() {
        this.getDependencies().clear();
    }

    public void setAllPosibleLocalDependencies(Map<Artifact, ArtifactDependency> allPosibleLocalDependencies) {
        this.allPosibleLocalDependencies = allPosibleLocalDependencies;
    }

    public Map<Artifact, ArtifactDependency> getAllPosibleLocalDependencies() {
        if (this.allPosibleLocalDependencies == null) {
            this.allPosibleLocalDependencies = new HashMap<Artifact, ArtifactDependency>();
        }
        return this.allPosibleLocalDependencies;
    }

    public ArtifactDependency getDependencyForArtifact(Artifact artifact) {
        if (!this.getAllPosibleLocalDependencies().containsKey(artifact)) {
            ArtifactDependency artifactDependency = new ArtifactDependency(this);
            artifactDependency.setInclude(false);
            this.getAllPosibleLocalDependencies().put(artifact, artifactDependency);
        }
        return this.getAllPosibleLocalDependencies().get(artifact);
    }

    public boolean isDependencyPresent(Artifact artifact) {
        return this.isDependencyPresent(artifact.getName(), artifact.getVersion());
    }

    public boolean isDependencyPresent(String name, String version) {
        for (ArtifactDependency dependency : this.getDependencies()) {
            if (!dependency.getName().equals(name) || !dependency.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }

    public String getTimestampedVersion() {
        this.timestampedVersion = this.carTimestamp == null ? this.getVersion() : this.getVersion() + ".v" + this.carTimestamp;
        return this.timestampedVersion;
    }

    public void setCarTimestamp(String carTimestamp) {
        this.carTimestamp = carTimestamp;
    }

    public String getCarTimestamp() {
        return this.carTimestamp;
    }

    public List<Observer> getObservers() {
        if (this.observers == null) {
            this.observers = new ArrayList<Observer>();
        }
        return this.observers;
    }
}

