/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.capp.bundleartifact;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.Artifact;
import org.wso2.maven.capp.model.BundlesDataInfo;
import org.wso2.maven.capp.model.LibraryArtifact;
import org.wso2.maven.capp.model.ProjectMapping;
import org.wso2.maven.capp.mojo.AbstractPOMGenMojo;
import org.wso2.maven.capp.utils.CAppMavenUtils;

public abstract class AbstractBundlePOMGenMojo
extends AbstractPOMGenMojo {
    public MavenProject project;
    public MavenProjectHelper projectHelper;
    public File outputLocation;
    public File artifactLocation;
    public File moduleProject;
    public String groupId;
    public String typeList;
    private BundlesDataInfo bundlesDataInfo;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        CAppMavenUtils.setMavenMetadata((ArtifactFactory)this.getArtifactFactory(), (ArtifactResolver)this.getResolver(), (ArtifactRepository)this.getLocalRepository(), this.getRemoteRepositories());
        super.execute();
    }

    @Override
    protected void addPlugins(MavenProject artifactMavenProject, Artifact artifact) {
    }

    protected void addMavenBundlePlugin(MavenProject artifactMavenProject, Artifact artifact) throws FactoryConfigurationError {
        artifactMavenProject.setPackaging("bundle");
        artifactMavenProject.getModel().addProperty("CApp.type", this.getArtifactType());
        Plugin plugin = CAppMavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"2.3.4", (boolean)true);
        Xpp3Dom config = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom instructionNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)config, (String)"instructions");
        Xpp3Dom symbolicNameNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Bundle-SymbolicName");
        symbolicNameNode.setValue(artifact.getName());
        Xpp3Dom bundleNameNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Bundle-Name");
        bundleNameNode.setValue(artifact.getName());
        String bundleActivatorClass = this.getBundleActivatorClass(artifact);
        if (bundleActivatorClass != null) {
            Xpp3Dom activatorClassNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Bundle-Activator");
            activatorClassNode.setValue(bundleActivatorClass);
        }
        Xpp3Dom exportPackageNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Export-Package");
        exportPackageNode.setValue(this.getBundlesDataInfo(null, artifact).getAllPackagesString());
        Xpp3Dom dynamicImportNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"DynamicImport-Package");
        dynamicImportNode.setValue("*");
    }

    protected void addRestrictedMavenBundlePlugin(MavenProject artifactMavenProject, Artifact artifact) throws FactoryConfigurationError {
        artifactMavenProject.setPackaging("bundle");
        artifactMavenProject.getModel().addProperty("CApp.type", this.getArtifactType());
        Plugin plugin = CAppMavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"2.3.4", (boolean)true);
        Xpp3Dom config = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom instructionNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)config, (String)"instructions");
        Xpp3Dom symbolicNameNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Bundle-SymbolicName");
        symbolicNameNode.setValue(artifact.getName());
        Xpp3Dom bundleNameNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Bundle-Name");
        bundleNameNode.setValue(artifact.getName());
        String bundleActivatorClass = this.getBundleActivatorClass(artifact);
        if (bundleActivatorClass != null) {
            Xpp3Dom activatorClassNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Bundle-Activator");
            activatorClassNode.setValue(bundleActivatorClass);
        }
        Xpp3Dom exportPackageNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Export-Package");
        exportPackageNode.setValue(this.getBundlesDataInfo(null, artifact).getAllPackagesString());
        Xpp3Dom dynamicImportNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"DynamicImport-Package");
        dynamicImportNode.setValue("*");
        Xpp3Dom importPackageNode = CAppMavenUtils.createConfigurationNode((Xpp3Dom)instructionNode, (String)"Import-Package");
        importPackageNode.setValue("!javax.xml.namespace,javax.xml.namespace; version=0.0.0,*");
    }

    @Override
    protected void addDependencies(MavenProject artifactMavenProject, Artifact artifact, File projectLocation) {
        this.getBundlesDataInfo(projectLocation, artifact);
        List<LibraryArtifact> libraries = this.getBundlesDataInfo(null, artifact).getLibraries();
        for (LibraryArtifact libraryArtifact : libraries) {
            try {
                String groupId = libraryArtifact.getGroupId();
                String artifactId = libraryArtifact.getArtifactId();
                String version = libraryArtifact.getVersion();
                String scope = null;
                String systemPath = null;
                String type = null;
                if (libraryArtifact.isLocal()) {
                    scope = libraryArtifact.getScope();
                    systemPath = "${basedir}/" + FileUtils.getRelativePath((File)this.getProjectLocation(), (File)libraryArtifact.getArtifactFile());
                }
                Dependency dependency = CAppMavenUtils.createDependency((String)groupId, (String)artifactId, (String)version, (String)scope, type, systemPath);
                artifactMavenProject.getModel().addDependency(dependency);
            }
            catch (MojoExecutionException e) {
                this.getLog().error((Throwable)e);
                break;
            }
        }
    }

    @Override
    protected void copyResources(MavenProject project, File projectLocation, Artifact artifact) throws IOException {
        this.setProjectLocation(projectLocation);
        this.getBundlesDataInfo(projectLocation, artifact);
    }

    protected BundlesDataInfo getBundlesDataInfo(File targetProjectLocation, Artifact artifact) throws FactoryConfigurationError {
        if (this.bundlesDataInfo == null) {
            try {
                this.bundlesDataInfo = new BundlesDataInfo();
                this.bundlesDataInfo.setProjects(this.getProjectMappings());
                this.bundlesDataInfo.loadFromFile(artifact.getFile());
                List<LibraryArtifact> libraries = this.bundlesDataInfo.getLibraries();
                if (targetProjectLocation != null) {
                    File libFolder = new File(targetProjectLocation, "src" + File.separator + "main" + File.separator + "resources" + File.separator + "lib");
                    for (LibraryArtifact libraryArtifact : libraries) {
                        if (!libraryArtifact.isLocal()) continue;
                        libFolder.mkdirs();
                        File artifactFile = libraryArtifact.getArtifactFile();
                        File file = new File(libFolder, artifactFile.getName());
                        FileUtils.copy((File)artifactFile, (File)file);
                        libraryArtifact.setArtifactFile(file);
                    }
                }
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
            }
        }
        return this.bundlesDataInfo;
    }

    protected List<ProjectMapping> getProjectMappings() throws Exception {
        List<String> projects = this.getProjectMapStrings();
        ArrayList<ProjectMapping> projectMappings = new ArrayList<ProjectMapping>();
        if (projects != null) {
            for (String project : projects) {
                projectMappings.add(ProjectMapping.getMapping(project));
            }
        }
        return projectMappings;
    }

    protected abstract String getBundleActivatorClass(Artifact var1);

    protected abstract List<String> getProjectMapStrings();

    public abstract ArtifactFactory getArtifactFactory();

    public abstract ArtifactResolver getResolver();

    public abstract ArtifactRepository getLocalRepository();

    public abstract List<?> getRemoteRepositories();
}

