/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.capp.model;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.capp.model.CAppArtifactDependency;
import org.wso2.maven.core.model.AbstractXMLDoc;

public class CAppArtifact
extends AbstractXMLDoc {
    private MavenProject project;
    private String serverRole;
    private List<CAppArtifactDependency> dependencyList;
    List<CAppArtifactDependency> dependencies;
    private List<CAppArtifactDependency> dummyDependencies = new ArrayList<CAppArtifactDependency>();
    private List<String> ignoreDependencies = new ArrayList<String>();
    List<CAppArtifact> subArtifacts;
    private long modificationStamp;
    private String carTimestamp = "";
    private String timestampedVersion;
    private String file;
    private boolean root;
    private String type;
    private static final String MAIN_SEQUENCE = "mainSequence";

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public CAppArtifact(MavenProject project, String serverRole) {
        this.setProject(project);
        this.setServerRole(serverRole);
    }

    public String getId() {
        return this.getProject().getGroupId() + ":" + this.getProject().getArtifactId() + ":" + this.getProject().getVersion();
    }

    public String getName() {
        return this.getProject().getArtifactId();
    }

    public String getVersion() {
        return this.getProject().getVersion();
    }

    public List<CAppArtifactDependency> getDependencies() throws MojoExecutionException {
        if (this.dependencyList != null) {
            return this.dependencyList;
        }
        ArrayList<CAppArtifactDependency> dependencies = new ArrayList<CAppArtifactDependency>();
        Properties properties = this.getProject().getProperties();
        for (Object object : this.getProject().getDependencies()) {
            String[] scopeElements;
            String dependencyServerRole;
            CAppArtifactDependency artifactDependency;
            Dependency dependency = (Dependency)object;
            String property = properties.getProperty(dependency.getGroupId() + "_._" + dependency.getArtifactId());
            if (property == null || !property.toLowerCase().startsWith("capp") || this.ignoreDependencies.contains((artifactDependency = new CAppArtifactDependency(dependency, dependencyServerRole = (scopeElements = property.split("/")).length > 1 ? scopeElements[1] : this.getServerRole())).getName() + ":" + artifactDependency.getVersion())) continue;
            dependencies.add(artifactDependency);
        }
        for (CAppArtifactDependency cAppArtifactDependency : this.getDummyDependencies()) {
            if (this.ignoreDependencies.contains(cAppArtifactDependency.getName() + ":" + cAppArtifactDependency.getVersion())) continue;
            dependencies.add(cAppArtifactDependency);
        }
        this.dependencyList = new ArrayList<CAppArtifactDependency>(dependencies);
        return dependencies;
    }

    public void addIgnoreDependency(CAppArtifactDependency cAppArtifactDependency) {
        this.ignoreDependencies.add(cAppArtifactDependency.getName() + ":" + cAppArtifactDependency.getVersion());
    }

    public String getType() {
        if (this.type == null) {
            String packagingType = this.getProject().getPackaging();
            Properties properties = this.getProject().getProperties();
            this.type = properties.containsKey("CApp.type") ? properties.get("CApp.type").toString() : packagingType;
        }
        return this.type;
    }

    private Map<String, CAppArtifactDependency> getDependencyMap() throws MojoExecutionException {
        HashMap<String, CAppArtifactDependency> dependencyMap = new HashMap<String, CAppArtifactDependency>();
        List<CAppArtifactDependency> dependencies = this.getDependencies();
        for (CAppArtifactDependency dependency : dependencies) {
            dependencyMap.put(dependency.getDependencyId(), dependency);
        }
        return dependencyMap;
    }

    public void addDependencies(CAppArtifactDependency dependency) throws MojoExecutionException {
        if (dependency.isDummyDependency()) {
            this.getDummyDependencies().add(dependency);
        } else {
            String dependencyId;
            Map<String, CAppArtifactDependency> dependencyMap = this.getDependencyMap();
            if (!dependencyMap.containsKey(dependencyId = dependency.getDependencyId())) {
                this.project.getModel().addDependency(dependency.getMavenDependency());
            }
        }
    }

    public String getCaption() {
        return this.getName() + " - " + this.getVersion() + "";
    }

    public String getDefaultName() {
        return "artifact.xml";
    }

    public boolean isDependencyPresent(CAppArtifact artifact) throws MojoExecutionException {
        return this.isDependencyPresent(artifact.getName(), artifact.getVersion());
    }

    public boolean isDependencyPresent(String name, String version) throws MojoExecutionException {
        for (CAppArtifactDependency dependency : this.getDependencies()) {
            if (!dependency.getName().equals(name) || !dependency.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }

    public String getTimestampedVersion() {
        this.timestampedVersion = this.carTimestamp == null ? this.getVersion() : this.getVersion() + ".v" + this.carTimestamp;
        return this.timestampedVersion;
    }

    public void setCarTimestamp(String carTimestamp) {
        this.carTimestamp = carTimestamp;
    }

    public String getCarTimestamp() {
        return this.carTimestamp;
    }

    public void setModificationStamp(long modificationStamp) {
        this.modificationStamp = modificationStamp;
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    public void setProject(MavenProject project) {
        this.type = null;
        this.project = project;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setServerRole(String serverRole) {
        this.serverRole = serverRole;
    }

    public String getServerRole() {
        return this.serverRole;
    }

    public String serialize() throws Exception {
        String result = null;
        OMDocument document = factory.createOMDocument();
        OMElement documentElement = this.getDocumentElement();
        document.addChild((OMNode)documentElement);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            CAppArtifact.prettify((OMElement)documentElement, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error serializing", e);
        }
        result = outputStream.toString();
        return result;
    }

    protected void deserialize(OMElement documentElement) {
    }

    public OMElement getDocumentElement() throws MojoExecutionException {
        OMElement documentElement = null;
        OMElement artifactElement = this.getElement("artifact", "");
        if (this.isRoot()) {
            documentElement = this.getElement("artifacts", "");
            documentElement.addChild((OMNode)artifactElement);
        } else {
            documentElement = artifactElement;
        }
        this.addAttribute(artifactElement, "name", this.getName());
        this.addAttribute(artifactElement, "version", this.getVersion());
        this.addAttribute(artifactElement, "type", this.getType());
        if (this.serverRole != null) {
            this.addAttribute(artifactElement, "serverRole", this.getServerRole());
        }
        if (this.getProject().getProperties().containsKey(MAIN_SEQUENCE)) {
            this.addAttribute(artifactElement, MAIN_SEQUENCE, this.getProject().getProperties().getProperty(MAIN_SEQUENCE));
        }
        if (this.getFile() != null) {
            artifactElement.addChild((OMNode)this.getElement("file", this.getFile()));
        }
        List<CAppArtifactDependency> artifactDependencies = this.getDependencies();
        Collections.sort(artifactDependencies);
        for (CAppArtifactDependency dependency : artifactDependencies) {
            OMElement dependecyElement = this.getElement("dependency", "");
            dependecyElement = this.addAttribute(dependecyElement, "artifact", dependency.getName());
            dependecyElement = this.addAttribute(dependecyElement, "version", dependency.getVersion());
            dependecyElement = this.addAttribute(dependecyElement, "include", Boolean.toString(true));
            if (dependency.getServerRole() != null) {
                dependecyElement = this.addAttribute(dependecyElement, "serverRole", dependency.getServerRole());
            }
            artifactElement.addChild((OMNode)dependecyElement);
        }
        return documentElement;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void setDummyDependencies(List<CAppArtifactDependency> dummyDependencies) {
        this.dummyDependencies = dummyDependencies;
    }

    public List<CAppArtifactDependency> getDummyDependencies() {
        return this.dummyDependencies;
    }
}

