/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.capp.model;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.developerstudio.eclipse.utils.archive.ArchiveManipulator;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.CAppArtifact;
import org.wso2.maven.capp.utils.CAppArtifactPriorityMapping;
import org.wso2.maven.capp.utils.CAppMavenUtils;

public class CAppArtifactDependency
implements Comparable<CAppArtifactDependency> {
    private CAppArtifact cAppArtifact;
    private Dependency mavenDependency;
    private File[] artifactFiles;
    private boolean dummyDependency = false;

    public CAppArtifactDependency(Dependency mavenDependency, String serverRole) throws MojoExecutionException {
        this.setMavenDependency(mavenDependency);
        Artifact resolvedArtifactPom = CAppMavenUtils.getResolvedArtifactPom((Dependency)mavenDependency, (ArtifactFactory)CAppMavenUtils.getArtifactFactory(), (List)CAppMavenUtils.getRemoteRepositories(), (ArtifactRepository)CAppMavenUtils.getLocalRepository(), (ArtifactResolver)CAppMavenUtils.getResolver());
        MavenProject mavenProject = CAppMavenUtils.getMavenProject((File)resolvedArtifactPom.getFile());
        this.setcAppArtifact(new CAppArtifact(mavenProject, serverRole));
    }

    public CAppArtifactDependency(MavenProject project, String type, String serverRole) {
        this.setcAppArtifact(new CAppArtifact(project, serverRole));
        this.getMavenDependency().setType(type);
    }

    public String getDependencyId() {
        return this.cAppArtifact.getId();
    }

    public String getName() {
        return this.cAppArtifact.getName();
    }

    public String getVersion() {
        return this.cAppArtifact.getVersion();
    }

    private Dependency createMavenDependency() {
        Dependency mavenDependency = new Dependency();
        MavenProject project = this.cAppArtifact.getProject();
        mavenDependency.setGroupId(project.getGroupId());
        mavenDependency.setArtifactId(project.getArtifactId());
        mavenDependency.setVersion(project.getVersion());
        mavenDependency.setScope("capp");
        return mavenDependency;
    }

    public void setArtifactFiles(File[] artifactFiles) {
        this.artifactFiles = artifactFiles;
    }

    public File[] getCappArtifactFile() throws MojoExecutionException, IOException {
        if (this.artifactFiles == null) {
            String artifactSystemPath;
            Artifact resolvedArtifact = null != this.getMavenDependency().getScope() ? (null != (artifactSystemPath = this.getArtifactSystemPath()) ? CAppMavenUtils.getResolvedArtifact((Dependency)this.getMavenDependency(), (ArtifactFactory)CAppMavenUtils.getArtifactFactory(), (List)CAppMavenUtils.getRemoteRepositories(), (ArtifactRepository)CAppMavenUtils.getLocalRepository(), (ArtifactResolver)CAppMavenUtils.getResolver(), (String)this.getMavenDependency().getScope(), (String)artifactSystemPath) : CAppMavenUtils.getResolvedArtifact((Dependency)this.getMavenDependency(), (ArtifactFactory)CAppMavenUtils.getArtifactFactory(), (List)CAppMavenUtils.getRemoteRepositories(), (ArtifactRepository)CAppMavenUtils.getLocalRepository(), (ArtifactResolver)CAppMavenUtils.getResolver(), (String)this.getMavenDependency().getScope(), (String)this.getMavenDependency().getSystemPath())) : CAppMavenUtils.getResolvedArtifact((Dependency)this.getMavenDependency(), (ArtifactFactory)CAppMavenUtils.getArtifactFactory(), (List)CAppMavenUtils.getRemoteRepositories(), (ArtifactRepository)CAppMavenUtils.getLocalRepository(), (ArtifactResolver)CAppMavenUtils.getResolver(), (String)"capp", null);
            File mavenArtifact = resolvedArtifact.getFile();
            String[] split = mavenArtifact.getName().split("\\.");
            if (this.getcAppArtifact().getType().equals("registry/resource")) {
                File[] listFiles;
                File tempDirectory = FileUtils.createTempDirectory();
                FileUtils.extract((File)mavenArtifact, (File)tempDirectory);
                for (File file : listFiles = tempDirectory.listFiles()) {
                    if (!file.isFile() || !file.getName().toLowerCase().endsWith(".xml")) continue;
                    this.getcAppArtifact().setFile(file.getName());
                }
                this.artifactFiles = listFiles;
            } else {
                this.getcAppArtifact().setFile(mavenArtifact.getName());
                this.artifactFiles = new File[]{mavenArtifact};
            }
        }
        return this.artifactFiles;
    }

    private String getArtifactSystemPath() throws IOException {
        Dependency artifactDependency = this.getMavenDependency();
        if (null != artifactDependency.getSystemPath()) {
            if ("xml".equals(artifactDependency.getType())) {
                return this.createSimpleSystemPath(artifactDependency, "xml");
            }
            if ("dbs".equals(artifactDependency.getType())) {
                return this.createSimpleSystemPath(artifactDependency, "dbs");
            }
            if ("zip".equals(artifactDependency.getType())) {
                String artifactName = artifactDependency.getArtifactId().concat("-" + artifactDependency.getVersion());
                String pomFileSystemPath = artifactDependency.getSystemPath();
                String baseDirPath = pomFileSystemPath.substring(0, pomFileSystemPath.lastIndexOf("pom.xml"));
                String resourcesDirPath = baseDirPath.concat("resources");
                File resourcesDir = new File(resourcesDirPath);
                String registryInfoFilePath = baseDirPath.concat("registry-info.xml");
                File registryInfoFile = new File(registryInfoFilePath);
                String destinationDirPath = baseDirPath.concat(artifactName);
                FileUtils.copyDirectory((File)resourcesDir, (File)new File(destinationDirPath.concat(File.separator + "resources")));
                FileUtils.copy((File)registryInfoFile, (File)new File(destinationDirPath.concat(File.separator + "registry-info.xml")));
                String zipFilePath = destinationDirPath.concat(".zip");
                File zipFile = new File(zipFilePath);
                ArchiveManipulator archiveManupulator = new ArchiveManipulator();
                archiveManupulator.archiveDir(zipFile, new File(destinationDirPath));
                File destinationDir = new File(destinationDirPath);
                if (destinationDir.exists()) {
                    FileUtils.deleteDir((File)destinationDir);
                }
                return zipFilePath;
            }
        }
        return null;
    }

    private String createSimpleSystemPath(Dependency artifactDependency, String dependencyType) {
        String artifactName = artifactDependency.getArtifactId().concat("-" + artifactDependency.getVersion() + "." + dependencyType);
        String pomFileSystemPath = artifactDependency.getSystemPath();
        return pomFileSystemPath.substring(0, pomFileSystemPath.lastIndexOf("pom.xml")).concat("target" + File.separator + artifactName);
    }

    public String toString() {
        return this.getCaption();
    }

    public String getCaption() {
        return this.getName() + " - " + this.getVersion();
    }

    public String getType() {
        return this.getMavenDependency().getType();
    }

    private void setcAppArtifact(CAppArtifact cAppArtifact) {
        this.cAppArtifact = cAppArtifact;
    }

    public CAppArtifact getcAppArtifact() {
        return this.cAppArtifact;
    }

    public String getServerRole() {
        return this.cAppArtifact.getServerRole();
    }

    public Dependency getMavenDependency() {
        if (this.mavenDependency == null) {
            this.mavenDependency = this.createMavenDependency();
        }
        return this.mavenDependency;
    }

    public void setMavenDependency(Dependency mavenDependency) {
        this.mavenDependency = mavenDependency;
    }

    public void setDummyDependency(boolean dummyDependency) {
        this.dummyDependency = dummyDependency;
    }

    public boolean isDummyDependency() {
        return this.dummyDependency;
    }

    @Override
    public int compareTo(CAppArtifactDependency compareArtifactDependency) {
        return CAppArtifactPriorityMapping.getPriority(this.getcAppArtifact().getType()) - CAppArtifactPriorityMapping.getPriority(compareArtifactDependency.getcAppArtifact().getType());
    }
}

