/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.capp.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.wso2.maven.capp.utils.CAppMavenUtils;

public class LibraryArtifact {
    private static final String SCOPE_SYSTEM = "system";
    private String groupId;
    private String artifactId;
    private String version;
    private File artifactFile;
    private String scope;
    private List<String> packages;

    public LibraryArtifact() {
    }

    public LibraryArtifact(String groupId, String artifactId, String version, File artifactFile) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
        this.setArtifactFile(artifactFile);
    }

    public LibraryArtifact(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getArtifactFile() throws MojoExecutionException {
        if (this.artifactFile == null) {
            Artifact resolvedArtifact = CAppMavenUtils.getResolvedArtifact((String)this.getGroupId(), (String)this.getArtifactId(), (String)this.getVersion(), (String)"jar", (String)"compile");
            this.artifactFile = resolvedArtifact.getFile();
        }
        return this.artifactFile;
    }

    public void setArtifactFile(File artifactFile) {
        this.scope = artifactFile == null ? null : SCOPE_SYSTEM;
        this.artifactFile = artifactFile;
    }

    public List<String> getPackages() {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        return this.packages;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isLocal() {
        return SCOPE_SYSTEM.equals(this.getScope());
    }
}

