/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.capp.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.wso2.maven.capp.model.Artifact;

public class CAppUtils {
    public static final String PROPERTY_CAPP_TYPE = "CApp.type";
    private static List<String> excludeList = new ArrayList<String>();

    public static List<Artifact> retrieveArtifacts(File path) {
        return CAppUtils.retrieveArtifacts(path, new ArrayList<Artifact>());
    }

    public static List<Artifact> retrieveArtifacts(File path, List<Artifact> artifacts) {
        if (path.exists()) {
            if (path.isFile()) {
                Artifact artifact = new Artifact();
                try {
                    artifact.fromFile(path);
                    if (artifact.getVersion() != null && artifact.getType() != null) {
                        artifact.setSuperArtifact(artifact.getType().equalsIgnoreCase("carbon/application"));
                        artifacts.add(artifact);
                    }
                }
                catch (Exception exception) {}
            } else {
                File[] files;
                for (File file : files = path.listFiles()) {
                    if (excludeList.contains(file.getName())) continue;
                    CAppUtils.retrieveArtifacts(file, artifacts);
                }
            }
        }
        return artifacts;
    }

    static {
        excludeList.add(".svn");
    }
}

