/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.maven.registry.RegistryArtifact;
import org.wso2.maven.registry.RegistryInfoProvider;
import org.wso2.maven.registry.beans.RegistryCollection;
import org.wso2.maven.registry.beans.RegistryElement;
import org.wso2.maven.registry.beans.RegistryItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralProjectArtifact
extends RegistryInfoProvider {
    private List<RegistryArtifact> registryArtifacts = new ArrayList<RegistryArtifact>();
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String TYPE = "type";
    private static final String SERVER_ROLE = "serverRole";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT = "artifact";
    private static final String ARTIFACTS = "artifacts";

    @Override
    protected void deserialize(OMElement documentElement) throws Exception {
        List artifactElements = this.getChildElements(documentElement, ARTIFACT);
        for (OMElement omElement : artifactElements) {
            RegistryArtifact artifact = new RegistryArtifact();
            artifact.setName(this.getAttribute(omElement, NAME));
            artifact.setVersion(this.getAttribute(omElement, VERSION));
            artifact.setType(this.getAttribute(omElement, TYPE));
            artifact.setServerRole(this.getAttribute(omElement, SERVER_ROLE));
            artifact.setGroupId(this.getAttribute(omElement, GROUP_ID));
            List itemElements = this.getChildElements(omElement, "item");
            for (OMElement omElement2 : itemElements) {
                RegistryItem item = this.getRegistryItem(omElement2);
                artifact.addRegistryElement(item);
            }
            List itemElements1 = this.getChildElements(omElement, "collection");
            for (OMElement omElement2 : itemElements1) {
                RegistryCollection item = this.getRegistryCollection(omElement2);
                artifact.addRegistryElement(item);
            }
            this.registryArtifacts.add(artifact);
        }
    }

    public void addESBArtifact(RegistryArtifact artifact) {
        this.registryArtifacts.add(artifact);
    }

    public boolean removeESBArtifact(RegistryArtifact artifact) {
        return this.registryArtifacts.remove(artifact);
    }

    public List<RegistryArtifact> getAllESBArtifacts() {
        return Collections.unmodifiableList(this.registryArtifacts);
    }

    @Override
    public OMElement getDocumentElement() {
        OMElement documentElement = this.getElement(ARTIFACTS, "");
        for (RegistryArtifact esbArtifact : this.registryArtifacts) {
            OMElement artifactElement = this.getElement(ARTIFACT, "");
            if (!esbArtifact.isAnonymous()) {
                this.addAttribute(artifactElement, NAME, esbArtifact.getName());
            }
            if (!esbArtifact.isAnonymous() && esbArtifact.getGroupId() != null) {
                this.addAttribute(artifactElement, GROUP_ID, esbArtifact.getGroupId());
            }
            if (!esbArtifact.isAnonymous() && esbArtifact.getVersion() != null) {
                this.addAttribute(artifactElement, VERSION, esbArtifact.getVersion());
            }
            if (esbArtifact.getType() != null) {
                this.addAttribute(artifactElement, TYPE, esbArtifact.getType());
            }
            if (esbArtifact.getServerRole() != null) {
                this.addAttribute(artifactElement, SERVER_ROLE, esbArtifact.getServerRole());
            }
            for (RegistryElement item : esbArtifact.getAllRegistryItems()) {
                OMElement element = this.getRegistryElementInfo(item);
                if (element == null) continue;
                artifactElement.addChild((OMNode)element);
            }
            documentElement.addChild((OMNode)artifactElement);
        }
        return documentElement;
    }
}

