/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.registry.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.wso2.maven.registry.GeneralProjectArtifact;
import org.wso2.maven.registry.RegistryArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralProjectMavenUtils {
    private static List<String> excludeList = new ArrayList<String>();

    public static List<RegistryArtifact> retrieveArtifacts(File path) {
        return GeneralProjectMavenUtils.retrieveArtifacts(new File(path, "artifact.xml"), new ArrayList<RegistryArtifact>());
    }

    private static List<RegistryArtifact> retrieveArtifacts(File path, List<RegistryArtifact> artifacts) {
        if (path.exists()) {
            if (path.isFile()) {
                GeneralProjectArtifact artifact = new GeneralProjectArtifact();
                try {
                    artifact.fromFile(path);
                    for (RegistryArtifact esbArtifact : artifact.getAllESBArtifacts()) {
                        if (esbArtifact.getVersion() == null || esbArtifact.getType() == null) continue;
                        artifacts.add(esbArtifact);
                    }
                }
                catch (Exception exception) {}
            } else {
                File[] files;
                for (File file : files = path.listFiles()) {
                    if (excludeList.contains(file.getName())) continue;
                    GeneralProjectMavenUtils.retrieveArtifacts(file, artifacts);
                }
            }
        }
        return artifacts;
    }

    static {
        excludeList.add(".svn");
    }
}

