/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.developerstudio.eclipse.utils.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.wso2.developerstudio.eclipse.utils.archive.ArchiveManipulator;
import org.wso2.developerstudio.eclipse.utils.data.ITemporaryFileTag;
import org.wso2.developerstudio.eclipse.utils.internal.model.TempFileTag;

public class FileUtils {
    private static Map<String, ITemporaryFileTag> temporaryTags;

    public static void copyFile(String src, String dest) throws Exception {
        FileInputStream is = null;
        FileOutputStream fos = null;
        try {
            is = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            int c = 0;
            byte[] array = new byte[1024];
            while ((c = ((InputStream)is).read(array)) >= 0) {
                fos.write(array, 0, c);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static File createFileAndParentDirectories(String fileName) throws Exception {
        File file = new File(fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        return file;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void deleteDirectories(File dir) {
        File[] children = dir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].list() != null && children[i].list().length > 0) {
                FileUtils.deleteDirectories(children[i]);
                continue;
            }
            children[i].delete();
        }
        dir.delete();
    }

    public static void deleteDirectories(String dir) {
        File directory = new File(dir);
        FileUtils.deleteDirectories(directory);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName) throws Exception {
        FileUtils.createTargetFile(sourceFileName, targetFileName, false);
    }

    public static void createTargetFile(String sourceFileName, String targetFileName, boolean overwrite) throws Exception {
        File idealResultFile = new File(targetFileName);
        if (overwrite || !idealResultFile.exists()) {
            FileUtils.createFileAndParentDirectories(targetFileName);
            FileUtils.copyFile(sourceFileName, targetFileName);
        }
    }

    public static boolean createDirectory(String directory) {
        boolean success = new File(directory).mkdir();
        if (!success) {
            // empty if block
        }
        return success;
    }

    public static boolean createDirectories(String directory) {
        boolean success = new File(directory).mkdirs();
        if (!success) {
            // empty if block
        }
        return success;
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdirs();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                FileUtils.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            FileUtils.copy(srcDir, dstDir);
        }
    }

    public static void copyDirectoryContents(File srcDir, File dstDir) throws IOException {
        File[] listFiles;
        for (File srcFile : listFiles = srcDir.listFiles()) {
            if (srcFile.isDirectory()) {
                FileUtils.copyDirectory(srcFile, new File(dstDir, srcFile.getName()));
                continue;
            }
            FileUtils.copy(srcFile, new File(dstDir, srcFile.getName()));
        }
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        if (dst.getParentFile() != null && !dst.getParentFile().exists()) {
            dst.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return currentPath + File.separator + newNode;
    }

    public static String addNodesToPath(String currentPath, String[] newNode) {
        StringBuffer sb = new StringBuffer();
        sb.append(currentPath);
        for (int i = 0; i < newNode.length; ++i) {
            sb.append(File.separator).append(newNode[i]);
        }
        return sb.toString();
    }

    public static String addNodesToPath(StringBuffer currentPath, String[] pathNodes) {
        for (int i = 0; i < pathNodes.length; ++i) {
            currentPath.append(File.separator).append(pathNodes[i]);
        }
        return currentPath.toString();
    }

    public static String addNodesToURL(String currentPath, String[] newNode) {
        StringBuffer sb = new StringBuffer();
        sb.append(currentPath);
        for (int i = 0; i < newNode.length; ++i) {
            sb.append("/").append(newNode[i]);
        }
        return sb.toString();
    }

    public static File[] getMatchingFiles(String sourceDir, String fileNamePrefix, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        File libDir = new File(sourceDir);
        String libDirPath = libDir.getAbsolutePath();
        File[] items = libDir.listFiles();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isDirectory()) {
                    FileUtils.getMatchingFiles(items[i].getPath(), fileNamePrefix, extension);
                    continue;
                }
                String item = items[i].getName();
                if (fileNamePrefix != null && extension != null) {
                    if (!item.startsWith(fileNamePrefix) || !item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix == null && extension != null) {
                    if (!item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix != null && extension == null) {
                    if (!item.startsWith(fileNamePrefix)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                fileList.add(new File(libDirPath + File.separator + item));
            }
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }

    public static File[] getAllMatchingFiles(String sourceDir, String fileNamePrefix, String extension, List fileList) {
        File libDir = new File(sourceDir);
        String libDirPath = libDir.getAbsolutePath();
        File[] items = libDir.listFiles();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isDirectory()) {
                    FileUtils.getAllMatchingFiles(items[i].getPath(), fileNamePrefix, extension, fileList);
                    continue;
                }
                String item = items[i].getName();
                if (fileNamePrefix != null && extension != null) {
                    if (!item.startsWith(fileNamePrefix) || !item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix == null && extension != null) {
                    if (!item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix != null && extension == null) {
                    if (!item.startsWith(fileNamePrefix)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                fileList.add(new File(libDirPath + File.separator + item));
            }
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }

    public static void filterOutRestrictedFiles(String sourceDir, String fileNamePrefix, String extension) {
        File[] resultedMatchingFiles = FileUtils.getMatchingFiles(sourceDir, fileNamePrefix, extension);
        for (int i = 0; i < resultedMatchingFiles.length; ++i) {
            File matchingFilePath = new File(resultedMatchingFiles[i].getAbsolutePath());
            matchingFilePath.delete();
        }
    }

    public static void createFile(File destinationFile, String content) throws IOException {
        if (destinationFile.getParentFile() != null && !destinationFile.getParentFile().exists()) {
            destinationFile.getParentFile().mkdirs();
        }
        ByteArrayInputStream dataStream = new ByteArrayInputStream(content.getBytes());
        FileUtils.createFile(destinationFile, dataStream);
    }

    public static void createFile(File destinationFile, InputStream dataStream) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(destinationFile);
        FileUtils.createFile(dataStream, (OutputStream)out);
    }

    public static void createFile(String content, OutputStream out) throws IOException {
        ByteArrayInputStream dataStream = new ByteArrayInputStream(content.getBytes());
        FileUtils.createFile(dataStream, out);
    }

    public static void createFile(InputStream dataStream, OutputStream out) throws IOException {
        int readLength;
        byte[] data = new byte[1024];
        while ((readLength = dataStream.read(data)) > 0) {
            out.write(data, 0, readLength);
        }
        dataStream.close();
        out.close();
    }

    public static void writeContent(File destinationFile, String content) throws IOException {
        FileUtils.createFile(destinationFile, content);
    }

    public static ITemporaryFileTag createNewTempTag() {
        TempFileTag tempFileTag = new TempFileTag();
        FileUtils.getTemporaryTags().put(tempFileTag.getId(), tempFileTag);
        return tempFileTag;
    }

    public static Map<String, ITemporaryFileTag> getTemporaryTags() {
        if (temporaryTags == null) {
            temporaryTags = new HashMap<String, ITemporaryFileTag>();
        }
        return temporaryTags;
    }

    private static void addFileToTempTags(File file) {
        for (ITemporaryFileTag tag : FileUtils.getTemporaryTags().values()) {
            if (tag.isTagEnded()) continue;
            tag.getLocations().add(file);
        }
    }

    public static File createTempFile() throws IOException {
        File tempFile = File.createTempFile("cstudio", ".tmp");
        FileUtils.addFileToTempTags(tempFile);
        return tempFile;
    }

    public static File createTempDirectory() throws IOException {
        File tempDirectory = FileUtils.createTempFile();
        tempDirectory.delete();
        tempDirectory.mkdirs();
        return tempDirectory;
    }

    public static boolean isPathValid(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static Map<File, ArrayList<String>> processJarList(File[] jarsList) throws IOException {
        HashMap<File, ArrayList<String>> jarInfoMap = new HashMap<File, ArrayList<String>>();
        for (File jarfile : jarsList) {
            File tempDir = FileUtils.extractJar(jarfile);
            List<File> classFiles = FileUtils.searchDir(tempDir);
            if (jarInfoMap.containsKey(jarfile)) continue;
            jarInfoMap.put(jarfile, FileUtils.exportedPackagesList(classFiles, tempDir));
        }
        return jarInfoMap;
    }

    public static ArrayList<String> exportedPackagesList(List<File> classFiles, File tempDir) {
        ArrayList<String> packagesTObeExported = new ArrayList<String>();
        if (classFiles != null && classFiles.size() != 0) {
            for (File classFile : classFiles) {
                String exportedpackage = classFile.getParent().substring(tempDir.getPath().length());
                String[] packagesInfo = exportedpackage.split(Pattern.quote(File.separator));
                if (packagesInfo.length <= 1) continue;
                StringBuffer sb = new StringBuffer();
                sb.append(packagesInfo[1]);
                for (int i = 0; i < packagesInfo.length - 2; ++i) {
                    sb.append(".").append(packagesInfo[i + 2]);
                }
                if (packagesTObeExported.contains(sb.toString())) continue;
                packagesTObeExported.add(sb.toString());
            }
        }
        return packagesTObeExported;
    }

    public static List<File> searchDir(File file) {
        ArrayList<File> classFiles = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            if (listFiles != null) {
                for (File file2 : listFiles) {
                    if (file2.isDirectory()) {
                        classFiles.addAll(FileUtils.searchDir(file2));
                        continue;
                    }
                    if (!file2.getName().endsWith(".class") || classFiles.contains(file2)) continue;
                    classFiles.add(file2);
                }
            } else if (file.getName().endsWith(".class") && !classFiles.contains(file)) {
                classFiles.add(file);
            }
        }
        return classFiles;
    }

    public static File extractJar(File jarfile) throws IOException {
        ArrayList classFiles = new ArrayList();
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        File tempDir = FileUtils.createTempDirectory();
        archiveManipulator.extract(jarfile.getPath(), tempDir.getPath());
        return tempDir;
    }

    public static String getContentAsString(URL url) throws IOException {
        InputStream openStream = url.openStream();
        String contentAsString = FileUtils.getContentAsString(openStream);
        openStream.close();
        return contentAsString;
    }

    public static String getContentAsString(InputStream dataStream) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int read = dataStream.read(b);
        while (read != -1) {
            stream.write(b, 0, read);
            read = dataStream.read(b);
        }
        String string = stream.toString();
        stream.close();
        return string;
    }

    public static String getContentAsString(File file) throws IOException {
        return FileUtils.getContentAsString(file.toURI().toURL());
    }

    public static String getResourceFileNameExtension(String resourceName) {
        String[] split = resourceName.split("\\.");
        if (split == null || split.length < 2) {
            return null;
        }
        return split[split.length - 1];
    }

    public static String getResourceFileName(String resourceName) {
        String extension = FileUtils.getResourceFileNameExtension(resourceName);
        if (extension == null) {
            return resourceName;
        }
        return resourceName.substring(0, resourceName.length() - extension.length() - 1);
    }

    public static URL getParentURL(URL url) throws MalformedURLException {
        int lastSlashPos;
        String path = url.toString();
        if (path == null || path.equals("") || path.equals("/")) {
            return null;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((lastSlashPos = path.lastIndexOf(47)) >= 0) {
            return new URL(path.substring(0, lastSlashPos));
        }
        return null;
    }

    public static String getFileName(URL url) {
        return FileUtils.getFileName(url.getFile(), "/");
    }

    public static String getFileName(String path) {
        return FileUtils.getFileName(path, File.pathSeparator);
    }

    public static String getFileName(String path, String pathSeparator) {
        String[] split = path.split(pathSeparator);
        if (split == null || split.length == 0) {
            return path;
        }
        return split[split.length - 1];
    }

    private static List<String> getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List<String> r, List<String> f) {
        int j;
        StringBuffer sb = new StringBuffer();
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            sb.append("..").append(File.separator);
            --i;
        }
        while (j >= 1) {
            sb.append(f.get(j)).append(File.separator);
            --j;
        }
        sb.append(f.get(j));
        return sb.toString();
    }

    public static String getRelativePath(File home, File f) {
        List<String> homelist = FileUtils.getPathList(home);
        List<String> filelist = FileUtils.getPathList(f);
        String s = FileUtils.matchPathLists(homelist, filelist);
        return s;
    }

    public static void extract(String archive, String extractDir) throws IOException {
        FileInputStream inputStream = new FileInputStream(archive);
        FileUtils.extractFromStream(inputStream, extractDir);
    }

    public static void extract(File archive, File extractDir) throws IOException {
        FileUtils.extract(archive.toString(), extractDir.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFromStream(InputStream inputStream, String extractDir) throws IOException {
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            File unzipped = new File(extractDir);
            zin = new ZipInputStream(inputStream);
            unzipped.mkdirs();
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                File f = new File(extractDir + File.separator + entryName);
                if (entryName.endsWith("/") && !f.exists()) {
                    f.mkdirs();
                    continue;
                }
                int lastIndexOfSlash = entryName.lastIndexOf("/");
                String dirPath = "";
                if (lastIndexOfSlash != -1) {
                    dirPath = entryName.substring(0, lastIndexOfSlash);
                    File dir = new File(extractDir + File.separator + dirPath);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                }
                if (f.isDirectory()) continue;
                FileOutputStream out = new FileOutputStream(f);
                try {
                    int len;
                    byte[] buf = new byte[40960];
                    while ((len = zin.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
        }
        catch (IOException e) {
            String msg = "Cannot unzip archive. It is probably corrupt";
            System.err.println(msg);
            throw e;
        }
        finally {
            if (zin != null) {
                zin.close();
            }
        }
    }
}

