/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.DeferredParsingException;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.wso2.maven.CARMojo;
import org.wso2.maven.Model.Artifact;
import org.wso2.maven.Model.ArtifactDependency;
import org.wso2.maven.Model.ArtifactDetails;
import org.wso2.maven.core.model.AbstractXMLDoc;

class CAppHandler
extends AbstractXMLDoc {
    private final String cAppName;
    private final CARMojo mojoInstance;
    private final List<ArtifactDetails> artifactTypeList;
    private final Map<String, String> apiList = new HashMap<String, String>();
    private final Map<String, String> proxyList = new HashMap<String, String>();

    public CAppHandler(String cAppName, CARMojo mojoInstance) {
        this.cAppName = cAppName;
        this.mojoInstance = mojoInstance;
        this.artifactTypeList = new ArrayList<ArtifactDetails>(Arrays.asList(new ArtifactDetails("apis", "synapse/api", "EnterpriseIntegrator"), new ArtifactDetails("endpoints", "synapse/endpoint", "EnterpriseIntegrator"), new ArtifactDetails("inbound-endpoints", "synapse/inbound-endpoint", "EnterpriseIntegrator"), new ArtifactDetails("local-entries", "synapse/local-entry", "EnterpriseIntegrator"), new ArtifactDetails("message-processors", "synapse/message-processors", "EnterpriseIntegrator"), new ArtifactDetails("message-stores", "synapse/message-store", "EnterpriseIntegrator"), new ArtifactDetails("proxy-services", "synapse/proxy-service", "EnterpriseIntegrator"), new ArtifactDetails("sequences", "synapse/sequence", "EnterpriseIntegrator"), new ArtifactDetails("tasks", "synapse/task", "EnterpriseIntegrator"), new ArtifactDetails("templates", "synapse/template", "EnterpriseIntegrator"), new ArtifactDetails("datasources", "datasource/datasource", "EnterpriseServiceBus"), new ArtifactDetails("dataservices", "service/dataservice", "EnterpriseServiceBus")));
    }

    void processArtifacts(File artifactsFolder, String archiveDirectory, List<ArtifactDependency> dependencies, String version) {
        if (!artifactsFolder.exists()) {
            this.mojoInstance.logInfo("Could not find artifacts folder in " + artifactsFolder.getAbsolutePath());
            return;
        }
        this.mojoInstance.logInfo("Processing artifacts in " + artifactsFolder.getAbsolutePath());
        for (ArtifactDetails artifactDetails : this.artifactTypeList) {
            File artifactFolder = new File(artifactsFolder, artifactDetails.getDirectory());
            this.processArtifactsInFolder(artifactFolder, dependencies, version, archiveDirectory, artifactDetails.getServerRole(), artifactDetails.getType());
        }
    }

    void processArtifactsInFolder(File artifactsDir, List<ArtifactDependency> dependencies, String version, String archiveDirectory, String serverRole, String type) {
        File[] configFiles = artifactsDir.listFiles();
        if (configFiles != null) {
            for (File configFile : configFiles) {
                if (!configFile.isFile()) continue;
                try {
                    String fileName;
                    String fileContent = FileUtils.readFileToString((File)configFile);
                    OMElement configElement = this.getElement(fileContent);
                    String name = configElement.getAttributeValue(new QName("name"));
                    if ("synapse/local-entry".equals(type)) {
                        name = configElement.getAttributeValue(new QName("key"));
                    }
                    if ("datasource/datasource".equals(type)) {
                        name = configFile.getName().substring(0, configFile.getName().length() - 4);
                    }
                    String configVersion = configElement.getAttributeValue(new QName("version"));
                    boolean apiHasVersion = true;
                    if ("synapse/api".equals(type)) {
                        this.apiList.put(name, configVersion);
                    }
                    if (configVersion == null) {
                        apiHasVersion = false;
                        configVersion = version;
                    }
                    if ("synapse/proxy-service".equals(type)) {
                        this.proxyList.put(name, configVersion);
                    }
                    String folderName = "";
                    if ("synapse/api".equals(type) && apiHasVersion) {
                        fileName = name + "_" + configVersion + "-" + configVersion;
                        folderName = name + "_" + configVersion + "_" + configVersion;
                    } else {
                        fileName = name + "-" + configVersion;
                        folderName = name + "_" + configVersion;
                    }
                    fileName = fileName.concat("service/dataservice".equals(type) ? ".dbs" : ".xml");
                    name = apiHasVersion ? name + "_" + configVersion : name;
                    dependencies.add(new ArtifactDependency(name, configVersion, serverRole, true));
                    this.writeArtifactAndFile(configFile, archiveDirectory, name, type, serverRole, configVersion, fileName, folderName);
                }
                catch (IOException | XMLStreamException | DeferredParsingException e) {
                    this.mojoInstance.logError("Error occurred while processing " + configFile.getName());
                    this.mojoInstance.logError(e.getMessage());
                }
            }
        }
    }

    void processResourcesFolder(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> dependencies, List<ArtifactDependency> metadataDependencies, String version) {
        if (!resourcesFolder.exists()) {
            this.mojoInstance.logInfo("Could not find resources folder in " + resourcesFolder.getAbsolutePath());
            return;
        }
        this.processConnectors(resourcesFolder, archiveDirectory, dependencies);
        this.processRegistryResources(resourcesFolder, archiveDirectory, dependencies);
        this.processMetadata(resourcesFolder, archiveDirectory, metadataDependencies, version);
    }

    void processConnectors(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> dependencies) {
        this.mojoInstance.logInfo("Processing connectors in " + resourcesFolder.getAbsolutePath());
        File connectorFolder = new File(resourcesFolder, "connectors");
        File[] connectorFiles = connectorFolder.listFiles();
        if (connectorFiles == null) {
            return;
        }
        for (File connector : connectorFiles) {
            if (!connector.isFile()) continue;
            String fileName = connector.getName();
            int lastIndex = fileName.lastIndexOf(45);
            String name = fileName.substring(0, lastIndex);
            String version = fileName.substring(lastIndex + 1, fileName.length() - 4);
            dependencies.add(new ArtifactDependency(name, version, "EnterpriseIntegrator", true));
            this.writeArtifactAndFile(connector, archiveDirectory, name, "synapse/lib", "EnterpriseIntegrator", version, fileName, name + "_" + version);
        }
    }

    void processRegistryResources(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> dependencies) {
        this.mojoInstance.logInfo("Processing registry resources in " + resourcesFolder.getAbsolutePath());
        File registryFolder = new File(resourcesFolder, "registry");
        File artifactFile = new File(registryFolder, "artifact.xml");
        if (!artifactFile.exists()) {
            return;
        }
        try {
            String artifactXmlFileAsString = FileUtils.readFileToString((File)artifactFile);
            OMElement artifactsElement = this.getElement(artifactXmlFileAsString);
            List artifactChildElements = this.getChildElements(artifactsElement, "artifact");
            for (OMElement artifact : artifactChildElements) {
                File registryResource;
                String path;
                String name = artifact.getAttributeValue(new QName("name"));
                String version = artifact.getAttributeValue(new QName("version"));
                String commonPath = Paths.get(archiveDirectory, name + "_" + version).toString();
                if (artifact.getFirstChildWithName(new QName("item")) != null) {
                    OMElement item = this.getFirstChildWithName(artifact, "item");
                    String fileName = item.getFirstChildWithName(new QName("file")).getText();
                    path = item.getFirstChildWithName(new QName("path")).getText();
                    if (path.startsWith("/_system/governance")) {
                        path = path.substring("/_system/governance".length());
                        registryResource = new File(registryFolder, "gov" + path + "/" + fileName);
                    } else {
                        path = path.substring("/_system/config".length());
                        registryResource = new File(registryFolder, "conf" + path + "/" + fileName);
                    }
                    if (!registryResource.exists()) {
                        this.mojoInstance.logError("Registry resource " + path + "/" + fileName + " does not exist");
                        continue;
                    }
                    org.wso2.developerstudio.eclipse.utils.file.FileUtils.copy((File)registryResource, (File)new File(Paths.get(archiveDirectory, name + "_" + version, "resources", fileName).toString()));
                    OMElement infoElement = this.getElement("resources", "");
                    infoElement.addChild((OMNode)item);
                    org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(commonPath, "registry-info.xml"), (String)this.serialize(infoElement));
                } else if (artifact.getFirstChildWithName(new QName("collection")) != null) {
                    OMElement collection = this.getFirstChildWithName(artifact, "collection");
                    String directory = collection.getFirstChildWithName(new QName("directory")).getText();
                    path = collection.getFirstChildWithName(new QName("path")).getText();
                    if (path.startsWith("/_system/governance")) {
                        path = path.substring("/_system/governance".length());
                        registryResource = new File(registryFolder, "gov" + path);
                    } else {
                        path = path.substring("/_system/config".length());
                        registryResource = new File(registryFolder, "conf" + path);
                    }
                    if (!registryResource.exists()) {
                        this.mojoInstance.logError("Registry resource " + path + " does not exist");
                        continue;
                    }
                    File destFile = new File(Paths.get(archiveDirectory, name + "_" + version, "resources", directory).toString());
                    destFile.mkdirs();
                    FileUtils.copyDirectory((File)registryResource, (File)destFile);
                    OMElement infoElement = this.getElement("resources", "");
                    infoElement.addChild((OMNode)collection);
                    org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(commonPath, "registry-info.xml"), (String)this.serialize(infoElement));
                }
                dependencies.add(new ArtifactDependency(name, version, "EnterpriseIntegrator", true));
                Artifact artifactObject = new Artifact();
                artifactObject.setName(name);
                artifactObject.setType("registry/resource");
                artifactObject.setVersion(version);
                artifactObject.setServerRole("EnterpriseIntegrator");
                artifactObject.setFile("registry-info.xml");
                String artifactDataAsString = this.createArtifactData(artifactObject);
                org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(commonPath, "artifact.xml"), (String)artifactDataAsString);
            }
        }
        catch (IOException | XMLStreamException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while processing registry resources");
            this.mojoInstance.logError(e.getMessage());
        }
    }

    void processMetadata(File resourcesFolder, String archiveDirectory, List<ArtifactDependency> metadataDependencies, String version) {
        this.mojoInstance.logInfo("Processing metadata in " + resourcesFolder.getAbsolutePath());
        File metadataFolder = new File(resourcesFolder, "metadata");
        if (this.apiList.size() > 0) {
            for (Map.Entry<String, String> entry : this.apiList.entrySet()) {
                String name;
                String apiName = entry.getKey();
                String apiVersion = entry.getValue();
                String swaggerFilename = apiName + "_swagger.yaml";
                String metadataFilename = apiName + "_metadata.yaml";
                boolean apiVersionExists = true;
                if (apiVersion != null) {
                    swaggerFilename = apiName + "_" + apiVersion + "_swagger.yaml";
                    metadataFilename = apiName + "_" + apiVersion + "_metadata.yaml";
                } else {
                    apiVersion = version;
                    apiVersionExists = false;
                }
                File swaggerFile = new File(metadataFolder, swaggerFilename);
                File metaFile = new File(metadataFolder, metadataFilename);
                if (!swaggerFile.exists() || !metaFile.exists()) continue;
                String folderName = "metadata/" + apiName + "_metadata_" + apiVersion;
                String fileName = apiName + "_metadata-" + apiVersion + ".yaml";
                if (apiVersionExists) {
                    fileName = apiName + "_" + apiVersion + "_metadata-" + apiVersion + ".yaml";
                    folderName = "metadata/" + apiName + "_" + apiVersion + "_metadata_" + apiVersion;
                    name = apiName + "_" + apiVersion + "_metadata";
                    metadataDependencies.add(new ArtifactDependency(name, apiVersion, "EnterpriseIntegrator", true));
                    this.writeArtifactAndFile(metaFile, archiveDirectory, name, "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
                } else {
                    metadataDependencies.add(new ArtifactDependency(apiName + "_metadata", version, "EnterpriseIntegrator", true));
                    this.writeArtifactAndFile(metaFile, archiveDirectory, apiName + "_metadata", "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
                }
                folderName = "metadata/" + apiName + "_swagger_" + apiVersion;
                fileName = apiName + "_swagger-" + apiVersion + ".yaml";
                if (apiVersionExists) {
                    fileName = apiName + "_" + apiVersion + "_swagger-" + apiVersion + ".yaml";
                    folderName = "metadata/" + apiName + "_" + apiVersion + "_swagger_" + apiVersion;
                    name = apiName + "_" + apiVersion + "_swagger";
                    metadataDependencies.add(new ArtifactDependency(name, apiVersion, "EnterpriseIntegrator", true));
                    this.writeArtifactAndFile(swaggerFile, archiveDirectory, name, "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
                    continue;
                }
                metadataDependencies.add(new ArtifactDependency(apiName + "_swagger", apiVersion, "EnterpriseIntegrator", true));
                this.writeArtifactAndFile(swaggerFile, archiveDirectory, apiName + "_swagger", "synapse/metadata", "EnterpriseIntegrator", apiVersion, fileName, folderName);
            }
        }
        if (this.proxyList.size() > 0) {
            for (Map.Entry<String, String> entry : this.proxyList.entrySet()) {
                String proxyName = entry.getKey();
                String proxyVersion = entry.getValue();
                File metaFile = new File(metadataFolder, proxyName + "_proxy_metadata.yaml");
                if (!metaFile.exists()) continue;
                this.writeArtifactAndFile(metaFile, archiveDirectory, proxyName + "_proxy_metadata", "synapse/metadata", "EnterpriseIntegrator", proxyVersion, proxyName + "_proxy_metadata-" + proxyVersion + ".yaml", "metadata/" + proxyName + "_proxy_metadata_" + proxyVersion);
                metadataDependencies.add(new ArtifactDependency(proxyName + "_proxy_metadata", proxyVersion, "EnterpriseIntegrator", true));
            }
        }
    }

    private void writeArtifactAndFile(File configFile, String archiveDirectory, String name, String type, String serverRole, String configVersion, String fileName, String folderName) {
        Artifact artifactObject = new Artifact();
        artifactObject.setName(name);
        artifactObject.setType(type);
        artifactObject.setVersion(configVersion);
        artifactObject.setServerRole(serverRole);
        artifactObject.setFile(fileName);
        try {
            String artifactDataAsString = this.createArtifactData(artifactObject);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(Paths.get(archiveDirectory, folderName).toString(), "artifact.xml"), (String)artifactDataAsString);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.copy((File)configFile, (File)new File(Paths.get(archiveDirectory, folderName, fileName).toString()));
        }
        catch (IOException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while creating " + fileName);
            this.mojoInstance.logError(e.getMessage());
        }
    }

    private String createArtifactData(Artifact artifact) throws MojoExecutionException {
        OMElement artifactElement = this.getElement("artifact", "");
        artifactElement = this.addAttribute(artifactElement, "name", artifact.getName());
        artifactElement = this.addAttribute(artifactElement, "version", artifact.getVersion());
        artifactElement = this.addAttribute(artifactElement, "type", artifact.getType());
        artifactElement = this.addAttribute(artifactElement, "serverRole", artifact.getServerRole());
        OMElement fileChildElement = this.getElement("file", artifact.getFile());
        artifactElement.addChild((OMNode)fileChildElement);
        return this.serialize(artifactElement);
    }

    void createDependencyArtifactsXmlFile(String archiveDirectory, List<ArtifactDependency> dependencies, List<ArtifactDependency> metaDependencies, MavenProject project) {
        String artifactsXmlFileDataAsString;
        OMElement dependencyElement;
        OMElement artifactsElement = this.getElement("artifacts", "");
        OMElement artifactElement = this.getElement("artifact", "");
        artifactElement = this.addAttribute(artifactElement, "name", project.getArtifactId() + "CompositeExporter");
        artifactElement = this.addAttribute(artifactElement, "version", project.getVersion());
        artifactElement = this.addAttribute(artifactElement, "type", "carbon/application");
        if (project.getProperties().containsKey("mainSequence")) {
            artifactElement = this.addAttribute(artifactElement, "mainSequence", project.getProperties().getProperty("mainSequence"));
        }
        for (ArtifactDependency dependency : dependencies) {
            dependencyElement = this.getElement("dependency", "");
            dependencyElement = this.addAttribute(dependencyElement, "artifact", dependency.getArtifact());
            dependencyElement = this.addAttribute(dependencyElement, "version", dependency.getVersion());
            dependencyElement = this.addAttribute(dependencyElement, "include", dependency.getInclude().toString());
            if (dependency.getServerRole() != null) {
                dependencyElement = this.addAttribute(dependencyElement, "serverRole", dependency.getServerRole());
            }
            artifactElement.addChild((OMNode)dependencyElement);
        }
        artifactsElement.addChild((OMNode)artifactElement);
        try {
            artifactsXmlFileDataAsString = this.serialize(artifactsElement);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(archiveDirectory, "artifacts.xml"), (String)artifactsXmlFileDataAsString);
        }
        catch (IOException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while creating artifacts.xml file");
            this.mojoInstance.logError(e.getMessage());
        }
        for (ArtifactDependency dependency : metaDependencies) {
            dependencyElement = this.getElement("dependency", "");
            dependencyElement = this.addAttribute(dependencyElement, "artifact", dependency.getArtifact());
            dependencyElement = this.addAttribute(dependencyElement, "version", dependency.getVersion());
            dependencyElement = this.addAttribute(dependencyElement, "include", dependency.getInclude().toString());
            if (dependency.getServerRole() != null) {
                dependencyElement = this.addAttribute(dependencyElement, "serverRole", dependency.getServerRole());
            }
            artifactElement.addChild((OMNode)dependencyElement);
        }
        artifactsElement.addChild((OMNode)artifactElement);
        try {
            artifactsXmlFileDataAsString = this.serialize(artifactsElement);
            org.wso2.developerstudio.eclipse.utils.file.FileUtils.createFile((File)new File(archiveDirectory, "metadata.xml"), (String)artifactsXmlFileDataAsString);
        }
        catch (IOException | MojoExecutionException e) {
            this.mojoInstance.logError("Error occurred while creating metadata.xml file");
            this.mojoInstance.logError(e.getMessage());
        }
    }

    void processClassMediators(List<ArtifactDependency> dependencies, MavenProject project) {
        String jarName = project.getArtifactId() + "-" + project.getVersion() + ".jar";
        File jarFile = new File(Paths.get(project.getBasedir().toString(), "target", jarName).toString());
        if (jarFile.exists()) {
            dependencies.add(new ArtifactDependency(project.getArtifactId(), project.getVersion(), "EnterpriseIntegrator", true));
            this.writeArtifactAndFile(jarFile, project.getBasedir().toString() + File.separator + "tmp", project.getArtifactId(), "lib/synapse/mediator", "EnterpriseIntegrator", project.getVersion(), jarName, project.getArtifactId() + "_" + project.getVersion());
        }
    }

    protected void deserialize(OMElement documentElement) throws Exception {
    }

    protected String serialize() throws Exception {
        return null;
    }

    private String serialize(OMElement element) throws MojoExecutionException {
        OMDocument document = factory.createOMDocument();
        document.addChild((OMNode)element);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            CAppHandler.prettify((OMElement)element, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error serializing", e);
        }
        return outputStream.toString();
    }

    protected String getDefaultName() {
        return null;
    }
}

