/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.Invoker;

public class MavenUtils {
    private static final Logger LOGGER = Logger.getLogger(MavenUtils.class.getName());

    public static String getMavenHome() throws MojoExecutionException {
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome != null) {
            return mavenHome;
        }
        mavenHome = System.getenv("M2_HOME");
        if (mavenHome != null) {
            return mavenHome;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            processBuilder.command("cmd.exe", "/c", "mvn -v");
        } else {
            processBuilder.command("sh", "-c", "mvn -v");
        }
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains("Maven home: ")) continue;
                return line.split("Maven home: ")[1].trim();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not determine Maven home.", (Exception)e);
        }
        throw new MojoExecutionException("Could not determine Maven home.");
    }

    public static void setupInvoker(Invoker invoker, String projectPath) throws MojoExecutionException {
        boolean useMavenWrapper;
        File mvnwFile = new File(projectPath, System.getProperty("os.name").toLowerCase().contains("win") ? "mvnw.cmd" : "mvnw");
        boolean bl = useMavenWrapper = mvnwFile.exists() && mvnwFile.canExecute() && !MavenUtils.useLocalMaven(projectPath);
        if (useMavenWrapper) {
            invoker.setMavenExecutable(mvnwFile);
            invoker.setMavenHome(new File(projectPath));
        } else {
            invoker.setMavenHome(new File(MavenUtils.getMavenHome()));
        }
        invoker.setOutputHandler(new InvocationOutputHandler(){

            public void consumeLine(String line) {
                if (!line.contains("BUILD SUCCESS")) {
                    System.out.println(line);
                }
            }
        });
    }

    public static boolean isConnectorPackingSupported(MavenProject project) {
        String runtimeVersion = project.getProperties().getProperty("project.runtime.version");
        if (runtimeVersion != null) {
            ComparableVersion currentVersion = new ComparableVersion(runtimeVersion);
            ComparableVersion targetVersion = new ComparableVersion("4.4.0");
            return currentVersion.compareTo(targetVersion) >= 0;
        }
        return false;
    }

    public static File createPomFile(List<String> dependencies, List<String> repositories) throws IOException {
        File tempPom = File.createTempFile("temp-pom", ".xml");
        try (FileWriter writer = new FileWriter(tempPom);){
            writer.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>temp</groupId>\n    <artifactId>temp</artifactId>\n    <version>1.0-SNAPSHOT</version>\n    <dependencies>\n");
            for (String dependency : dependencies) {
                String[] parts = dependency.split(":");
                if (parts.length > 3) {
                    writer.write(String.format("        <dependency>\n            <groupId>%s</groupId>\n            <artifactId>%s</artifactId>\n            <version>%s</version>\n            <type>%s</type>\n            <exclusions>\n                <exclusion>\n                    <groupId>*</groupId>\n                    <artifactId>*</artifactId>\n                </exclusion>\n            </exclusions>\n        </dependency>\n", parts[0], parts[1], parts[2], parts[3]));
                    continue;
                }
                writer.write(String.format("        <dependency>\n            <groupId>%s</groupId>\n            <artifactId>%s</artifactId>\n            <version>%s</version>\n            <exclusions>\n                <exclusion>\n                    <groupId>*</groupId>\n                    <artifactId>*</artifactId>\n                </exclusion>\n            </exclusions>\n        </dependency>\n", parts[0], parts[1], parts[2]));
            }
            writer.write("    </dependencies>\n");
            if (repositories != null && !repositories.isEmpty()) {
                writer.write("    <repositories>\n");
                for (String repository : repositories) {
                    writer.write(String.format("        <repository>\n            <id>repo-%d</id>\n            <url>%s</url>\n        </repository>\n", repositories.indexOf(repository) + 1, repository));
                }
                writer.write("    </repositories>\n");
            }
            writer.write("</project>\n");
        }
        return tempPom;
    }

    public static boolean useLocalMaven(String projectPath) {
        try {
            File settingsFile = Paths.get(projectPath, ".vscode", "settings.json").toFile();
            if (!settingsFile.exists()) {
                return false;
            }
            String content = new String(Files.readAllBytes(settingsFile.toPath()), StandardCharsets.UTF_8);
            JsonObject jsonObject = new JsonParser().parse(content).getAsJsonObject();
            if (jsonObject.has("MI.useLocalMaven")) {
                return jsonObject.get("MI.useLocalMaven").getAsBoolean();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error occurred while reading project settings file", e);
        }
        return false;
    }

    public static boolean isVersionedDeployment(MavenProject project) {
        String versionedDeployment = project.getProperties().getProperty("versionedDeployment");
        return Boolean.parseBoolean(versionedDeployment);
    }
}

