/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.datamapper;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.wso2.maven.datamapper.DataMapperException;

public class Utils {
    public static String convertToHex(byte[] messageDigest) {
        BigInteger bigint = new BigInteger(1, messageDigest);
        String hexText = bigint.toString(16);
        while (hexText.length() < 32) {
            hexText = "0".concat(hexText);
        }
        return hexText;
    }

    public static String getFileChecksum(Path filePath) throws DataMapperException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] fileBytes = Files.readAllBytes(filePath);
            byte[] digest = md.digest(fileBytes);
            return Utils.convertToHex(digest);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new DataMapperException("Failed to calculate checksum for file: " + filePath, e);
        }
    }

    public static String getHash(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            return Utils.convertToHex(messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

