/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.libraries;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.maven.CARMojo;
import org.wso2.maven.CAppDependency;
import org.wso2.maven.MavenUtils;
import org.wso2.maven.model.ArtifactDependency;

public class CAppDependencyResolver {
    public static void resolveDependencies(CARMojo carMojo, MavenProject project, String archiveDir, List<ArtifactDependency> dependencies, List<ArtifactDependency> metaDependencies) throws Exception {
        File dependenciesDir = new File("target" + File.separator + "dependency");
        CAppDependencyResolver.executeDependencyCopy(project.getBasedir(), new File(project.getBasedir(), "pom.xml"), dependenciesDir);
        boolean fatCarEnabled = CAppDependencyResolver.isFatCarEnabled(project);
        if (fatCarEnabled) {
            ArrayList<File> cAppFiles = CAppDependencyResolver.getResolvedDependentCAppFiles(project.getBasedir(), dependenciesDir, project.getArtifactId(), project.getVersion(), carMojo);
            String dependencyDir = archiveDir + File.separator + "dependencies";
            for (File cappFile : cAppFiles) {
                FileUtils.copyFile((File)cappFile, (File)new File(dependencyDir, cappFile.getName()));
            }
        }
    }

    public static boolean isFatCarEnabled(MavenProject project) {
        String fatCarEnabled = project.getProperties().getProperty("fat.car.enable");
        return Boolean.parseBoolean(fatCarEnabled);
    }

    public static void handleConfigPropertiesFile(File srcDir, File targetDir) throws IOException {
        File srcConfigFile = new File(srcDir, "config.properties");
        File targetConfigFile = new File(targetDir, "config.properties");
        if (!srcConfigFile.exists()) {
            return;
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if (!targetConfigFile.exists()) {
            targetConfigFile.createNewFile();
        }
        CAppDependencyResolver.mergePropertiesFiles(srcConfigFile, targetConfigFile);
    }

    public static void mergePropertiesFiles(File sourceFile, File targetFile) throws IOException {
        ArrayList<String> mergedLines = new ArrayList<String>();
        try (BufferedReader sourceReader = new BufferedReader(new FileReader(sourceFile));
             BufferedReader targetReader = new BufferedReader(new FileReader(targetFile));){
            String line;
            while ((line = sourceReader.readLine()) != null) {
                if (line.trim().isEmpty() || mergedLines.contains(line)) continue;
                mergedLines.add(line);
            }
            while ((line = targetReader.readLine()) != null) {
                if (line.trim().isEmpty() || mergedLines.contains(line)) continue;
                mergedLines.add(line);
            }
        }
        catch (IOException e) {
            throw new IOException("Error reading properties files: " + e.getMessage(), e);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile));){
            for (String mergedLine : mergedLines) {
                writer.write(mergedLine);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new IOException("Error writing merged properties file: " + e.getMessage(), e);
        }
    }

    public static void updateArtifactDependencies(File artifactDependencyFile, List<ArtifactDependency> artifactDependencies, CARMojo carMojo) throws Exception {
        if (artifactDependencyFile.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(artifactDependencyFile);
                document.getDocumentElement().normalize();
                NodeList artifactsNodes = document.getElementsByTagName("artifacts");
                for (int i = 0; i < artifactsNodes.getLength(); ++i) {
                    Element artifactsElement = (Element)artifactsNodes.item(i);
                    NodeList artifactNodes = artifactsElement.getElementsByTagName("artifact");
                    for (int j = 0; j < artifactNodes.getLength(); ++j) {
                        Element artifactElement = (Element)artifactNodes.item(j);
                        NodeList dependencyNodes = artifactElement.getElementsByTagName("dependency");
                        for (int k = 0; k < dependencyNodes.getLength(); ++k) {
                            Element dependencyElement = (Element)dependencyNodes.item(k);
                            String artifact = dependencyElement.getAttribute("artifact");
                            String version = dependencyElement.getAttribute("version");
                            String include = dependencyElement.getAttribute("include");
                            String serverRole = dependencyElement.getAttribute("serverRole");
                            ArtifactDependency artifactDependency = new ArtifactDependency(artifact, version, serverRole, Boolean.parseBoolean(include));
                            boolean exists = CAppDependencyResolver.artifactDependencyExists(artifactDependencies, artifactDependency);
                            if (exists) continue;
                            artifactDependencies.add(artifactDependency);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Error while reading artifacts XML file: " + artifactDependencyFile.getAbsolutePath(), e);
            }
        } else {
            throw new Exception("Artifacts XML file not found: " + artifactDependencyFile.getAbsolutePath());
        }
    }

    private static boolean artifactDependencyExists(List<ArtifactDependency> dependencies, ArtifactDependency artifactDependency) {
        for (ArtifactDependency dep : dependencies) {
            if (!dep.getArtifact().equals(artifactDependency.getArtifact()) || !dep.getVersion().equals(artifactDependency.getVersion()) || !dep.getServerRole().equals(artifactDependency.getServerRole()) || !dep.getInclude().equals(artifactDependency.getInclude())) continue;
            return true;
        }
        return false;
    }

    public static void unzipFile(File zipFile, File extractDir) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(zipFile.toPath(), new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                File extractedFile = new File(extractDir, entry.getName());
                if (entry.isDirectory()) {
                    extractedFile.mkdirs();
                } else {
                    try (FileOutputStream outputStream = new FileOutputStream(extractedFile);){
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = zipInputStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, length);
                        }
                    }
                }
                zipInputStream.closeEntry();
            }
        }
    }

    static void executeDependencyCopy(File projectDir, File pomFile, File outputDir) throws MavenInvocationException, MojoExecutionException {
        DefaultInvoker invoker = new DefaultInvoker();
        MavenUtils.setupInvoker((Invoker)invoker, projectDir.getPath());
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setBaseDirectory(projectDir);
        request.setGoals(Collections.singletonList(String.format("-f %s dependency:copy-dependencies -DincludeTypes=car -DoutputDirectory=%s", pomFile.getAbsolutePath(), outputDir.getAbsolutePath())));
        invoker.execute((InvocationRequest)request);
    }

    public static ArrayList<File> getResolvedDependentCAppFiles(File projectDir, File dependenciesDir, String artifactId, String version, CARMojo carMojo) throws Exception {
        if (!dependenciesDir.exists()) {
            return new ArrayList<File>();
        }
        ArrayList<File> cAppFiles = new ArrayList<File>();
        HashSet<String> visited = new HashSet<String>();
        visited.add(artifactId + "-" + version);
        for (File file : Objects.requireNonNull(dependenciesDir.listFiles())) {
            if (!file.getName().endsWith(".car")) continue;
            cAppFiles.add(file);
        }
        for (File file : Objects.requireNonNull(dependenciesDir.listFiles())) {
            if (!file.getName().endsWith(".car")) continue;
            String baseName = file.getName().replace(".car", "");
            visited.add(baseName);
            CAppDependencyResolver.collectDependentCAppFiles(projectDir, dependenciesDir, file, cAppFiles, visited, carMojo);
        }
        return cAppFiles;
    }

    public static void collectDependentCAppFiles(File projectDir, File dependenciesDir, File carFile, ArrayList<File> cAppFiles, Set<String> visited, CARMojo carMojo) throws Exception {
        try (ZipFile zipFile = new ZipFile(carFile);){
            ZipEntry descriptorEntry = zipFile.getEntry("descriptor.xml");
            if (descriptorEntry == null) {
                return;
            }
            InputStream inputStream = zipFile.getInputStream(descriptorEntry);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            document.getDocumentElement().normalize();
            NodeList dependencyNodes = document.getElementsByTagName("dependency");
            carMojo.logInfo("Processing " + dependencyNodes.getLength() + " dependencies in " + carFile.getName());
            for (int i = 0; i < dependencyNodes.getLength(); ++i) {
                String key;
                Element dependencyElement = (Element)dependencyNodes.item(i);
                String groupId = dependencyElement.getAttribute("groupId");
                String artifactId = dependencyElement.getAttribute("artifactId");
                String version = dependencyElement.getAttribute("version");
                carMojo.logInfo("Resolving dependency: " + groupId + ":" + artifactId + ":" + version);
                if (!StringUtils.isNotEmpty((String)artifactId) || !StringUtils.isNotEmpty((String)version) || visited.contains(key = artifactId + "-" + version)) continue;
                visited.add(key);
                File dependentCarFile = CAppDependencyResolver.findCarFileInDependencies(dependenciesDir, artifactId, version);
                if (dependentCarFile != null && !cAppFiles.contains(dependentCarFile)) {
                    cAppFiles.add(dependentCarFile);
                    CAppDependencyResolver.collectDependentCAppFiles(projectDir, dependenciesDir, dependentCarFile, cAppFiles, visited, carMojo);
                    continue;
                }
                File copiedFile = CAppDependencyResolver.fetchCarFileFromMavenRepo(projectDir, dependenciesDir, groupId, artifactId, version, carMojo);
                if (copiedFile != null) {
                    cAppFiles.add(copiedFile);
                    CAppDependencyResolver.collectDependentCAppFiles(projectDir, dependenciesDir, copiedFile, cAppFiles, visited, carMojo);
                    continue;
                }
                throw new Exception("Could not find .car in maven repository for groupId: " + groupId + ", artifactId: " + artifactId + ", version: " + version);
            }
        }
    }

    public static File findCarFileInDependencies(File dependenciesDir, String artifactId, String version) {
        for (File file : Objects.requireNonNull(dependenciesDir.listFiles())) {
            if (!file.getName().endsWith(".car") || !file.getName().equals(artifactId + "-" + version + ".car")) continue;
            return file;
        }
        return null;
    }

    public static File fetchCarFileFromMavenRepo(File projectDir, File dependenciesDir, String groupId, String artifactId, String version, CARMojo carMojo) throws Exception {
        File tempPomFile = MavenUtils.createPomFile(Collections.singletonList(groupId + ":" + artifactId + ":" + version + ":car"), Collections.emptyList());
        try {
            CAppDependencyResolver.executeDependencyCopy(projectDir, tempPomFile, dependenciesDir);
            File fetchedCarFile = new File(dependenciesDir, artifactId + "-" + version + ".car");
            if (fetchedCarFile.exists()) {
                return fetchedCarFile;
            }
            if (!tempPomFile.delete()) {
                carMojo.getLog().warn((CharSequence)("Failed to delete temporary pom.xml: " + tempPomFile.getAbsolutePath()));
            }
        }
        catch (MavenInvocationException e) {
            throw new Exception("Error while fetching .car from Maven repo: " + e.getMessage(), e);
        }
        return null;
    }

    public static List<CAppDependency> getTopLevelCAppDependencies(MavenProject project) {
        ArrayList<CAppDependency> cAppDependencies = new ArrayList<CAppDependency>();
        for (Object depObj : project.getDependencies()) {
            Dependency dep;
            if (!(depObj instanceof Dependency) || !"car".equals((dep = (Dependency)depObj).getType())) continue;
            CAppDependency cAppDependency = new CAppDependency(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
            cAppDependencies.add(cAppDependency);
        }
        return cAppDependencies;
    }
}

