/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.libraries;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.maven.CARMojo;
import org.wso2.maven.Constants;
import org.wso2.maven.MavenUtils;
import org.wso2.maven.libraries.LibraryResolverException;
import org.yaml.snakeyaml.Yaml;

public class ConnectorDependencyResolver {
    private static Map<String, String> connectionTypeMap;
    private static boolean scannedConnections;

    public static void resolveDependencies(CARMojo carMojo, MavenProject project) throws Exception {
        String extractedDir = "target" + File.separator + "extracted-connectors";
        String libDir = "target" + File.separator + "libs";
        new File(extractedDir).mkdirs();
        File libDirFile = new File(libDir);
        libDirFile.mkdirs();
        String libDirPath = libDirFile.getAbsolutePath();
        DefaultInvoker invoker = new DefaultInvoker();
        MavenUtils.setupInvoker((Invoker)invoker, project.getBasedir().getAbsolutePath());
        ArrayList<File> connectorZips = ConnectorDependencyResolver.resolveConnectorZips((Invoker)invoker);
        if (!MavenUtils.isConnectorPackingSupported(project)) {
            return;
        }
        List<String> directories = Arrays.asList("connectors", "inbound-connectors");
        for (String directoryName : directories) {
            ConnectorDependencyResolver.resolveConnectorZipsFromResources(connectorZips, directoryName);
        }
        HashMap<QName, File> dependencyFiles = new HashMap<QName, File>();
        for (File file : connectorZips) {
            String targetExtractDir = extractedDir + File.separator + file.getName().replace(".zip", "");
            if (new File(targetExtractDir).exists()) {
                carMojo.logInfo("Connector already extracted: " + file.getName());
                continue;
            }
            ConnectorDependencyResolver.extractZipFile(file, targetExtractDir);
            QName qualifiedConnectorName = ConnectorDependencyResolver.extractConnectorInfo(carMojo, targetExtractDir);
            if (qualifiedConnectorName == null) {
                carMojo.logError("Failed to extract connector information from " + file.getName());
                continue;
            }
            File descriptorYaml = new File(targetExtractDir + File.separator + "descriptor.yml");
            if (!descriptorYaml.exists()) continue;
            carMojo.getLog().info((CharSequence)("Found descriptor file: " + descriptorYaml.getPath()));
            dependencyFiles.put(qualifiedConnectorName, descriptorYaml);
        }
        if (!dependencyFiles.isEmpty()) {
            for (Map.Entry entry : dependencyFiles.entrySet()) {
                carMojo.logInfo("Resolving dependencies for " + entry.getKey());
                ConnectorDependencyResolver.resolveMavenDependencies((File)entry.getValue(), libDirPath, (Invoker)invoker, carMojo, ((QName)entry.getKey()).toString(), project.getBasedir());
            }
        }
        carMojo.logInfo("All dependencies resolved and extracted successfully.");
    }

    private static ArrayList<File> resolveConnectorZips(Invoker invoker) throws MavenInvocationException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File("pom.xml"));
        request.setGoals(Collections.singletonList("dependency:copy-dependencies -DincludeTypes=zip"));
        invoker.execute((InvocationRequest)request);
        File dependenciesDir = new File("target" + File.separator + "dependency");
        if (!dependenciesDir.exists()) {
            return new ArrayList<File>();
        }
        ArrayList<File> connectorZips = new ArrayList<File>();
        for (File file : dependenciesDir.listFiles()) {
            if (!file.getName().endsWith(".zip")) continue;
            connectorZips.add(file);
        }
        return connectorZips;
    }

    private static void resolveConnectorZipsFromResources(ArrayList<File> connectorZips, String directoryName) {
        File connectorsDir = new File(Constants.RESOURCES_FOLDER_PATH, directoryName);
        if (!connectorsDir.exists()) {
            return;
        }
        for (File file : Objects.requireNonNull(connectorsDir.listFiles())) {
            if (!file.getName().endsWith(".zip")) continue;
            connectorZips.add(file);
        }
    }

    private static void extractZipFile(File zipFile, String outputDir) throws IOException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = ConnectorDependencyResolver.newFile(outputDir, zipEntry);
            if (zipEntry.isDirectory()) {
                newFile.mkdirs();
            } else {
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private static File newFile(String outputDir, ZipEntry zipEntry) {
        String fileName = zipEntry.getName();
        return new File(outputDir + File.separator + fileName);
    }

    private static void resolveMavenDependencies(File descriptorYaml, String libDir, Invoker invoker, CARMojo carMojo, String connectorName, File projectDir) throws Exception {
        if (!descriptorYaml.exists()) {
            return;
        }
        Yaml yaml = new Yaml();
        Map yamlData = (Map)yaml.load(Files.newInputStream(descriptorYaml.toPath(), new OpenOption[0]));
        List repositories = (List)yamlData.get("repositories");
        ArrayList<String> repositoriesList = new ArrayList<String>();
        if (repositories != null) {
            for (int i = 0; i < repositories.size(); ++i) {
                repositoriesList.add((String)((Map)repositories.get(i)).get("url"));
            }
        }
        List dependencies = (List)yamlData.get("dependencies");
        HashSet<CallSite> dependencySet = new HashSet<CallSite>();
        if (dependencies != null) {
            for (Map dependency : dependencies) {
                String groupId = (String)dependency.get("groupId");
                String artifactId = (String)dependency.get("artifactId");
                String version = (String)dependency.get("version");
                if (dependency.containsKey("connectionType")) {
                    String connectionType = (String)dependency.get("connectionType");
                    if (!scannedConnections) {
                        carMojo.logInfo("Scanning local entries folder for connections.");
                        connectionTypeMap = ConnectorDependencyResolver.scanLocalEntriesForConnections(Constants.LOCAL_ENTRIES_FOLDER_PATH, carMojo);
                        scannedConnections = true;
                    }
                    if (connectionTypeMap == null || !connectionTypeMap.containsKey(connectionType)) {
                        carMojo.logInfo("Skipping dependency: " + groupId + ":" + artifactId + ":" + version + " as the connectionType: " + connectionType + " is not found in the local entries.");
                        continue;
                    }
                }
                dependencySet.add((CallSite)((Object)(groupId + ":" + artifactId + ":" + version)));
            }
        }
        ArrayList<String> dependenciesList = new ArrayList<String>(dependencySet);
        ConnectorDependencyResolver.resolveAndCopyDependencies(dependenciesList, repositoriesList, libDir, invoker, carMojo, connectorName, projectDir);
    }

    private static void resolveAndCopyDependencies(List<String> dependencies, List<String> repositories, String libDir, Invoker invoker, CARMojo carMojo, String connectorName, File projectDir) throws LibraryResolverException {
        File targetDir = new File(libDir + File.separator + connectorName);
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new LibraryResolverException("Failed to create directory: " + targetDir.getAbsolutePath());
        }
        try {
            File tempPom = MavenUtils.createPomFile(dependencies, repositories);
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setBaseDirectory(projectDir);
            request.setGoals(Collections.singletonList(String.format("-f %s dependency:copy-dependencies -DexcludeTransitive=true -DoutputDirectory=%s", tempPom.getAbsolutePath(), libDir + File.separator + connectorName)));
            ConnectorDependencyResolver.executeRequest((InvocationRequest)request, "Failed to resolve and copy dependencies", invoker, carMojo);
            if (!tempPom.delete()) {
                carMojo.getLog().warn((CharSequence)("Failed to delete temporary pom.xml: " + tempPom.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new LibraryResolverException("Failed to create temporary pom.xml", e);
        }
    }

    private static void executeRequest(InvocationRequest request, String errorMessage, Invoker invoker, CARMojo carMojo) throws LibraryResolverException {
        try {
            InvocationResult result = invoker.execute(request);
            if (result.getExitCode() != 0) {
                carMojo.logError(errorMessage);
                if (result.getExecutionException() != null) {
                    carMojo.logError(result.getExecutionException().getMessage());
                }
                throw new LibraryResolverException(errorMessage);
            }
        }
        catch (MavenInvocationException e) {
            throw new LibraryResolverException(errorMessage, e);
        }
    }

    private static Map<String, String> scanLocalEntriesForConnections(String folderPath, CARMojo carMojo) throws Exception {
        HashMap<String, String> connectionTypeMap = new HashMap<String, String>();
        File localEntriesFolder = new File(folderPath);
        if (!localEntriesFolder.exists()) {
            return connectionTypeMap;
        }
        File[] localEntries = localEntriesFolder.listFiles();
        if (localEntries == null) {
            return connectionTypeMap;
        }
        for (File localEntry : localEntries) {
            if (!localEntry.isFile() || !localEntry.getName().endsWith(".xml")) continue;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(localEntry);
            Element root = doc.getDocumentElement();
            String connectorName = "";
            String connectionType = "";
            NodeList initNodes = root.getElementsByTagName("*");
            for (int i = 0; i < initNodes.getLength(); ++i) {
                Element element = (Element)initNodes.item(i);
                String nodeName = element.getNodeName();
                if (!nodeName.endsWith(".init")) continue;
                connectorName = nodeName.substring(0, nodeName.indexOf(".init"));
                NodeList ctNodes = element.getElementsByTagName("connectionType");
                if (ctNodes.getLength() <= 0) continue;
                connectionType = ctNodes.item(0).getTextContent();
                connectionTypeMap.put(connectionType, connectorName);
                break;
            }
            carMojo.getLog().info((CharSequence)("Found local entry file: " + localEntry.getPath() + " with connectionType: " + connectionType + " and connectorName: " + connectorName));
        }
        return connectionTypeMap;
    }

    public static QName extractConnectorInfo(CARMojo carMojo, String filePath) {
        try {
            File xmlFile = new File(filePath + File.separator + "connector.xml");
            if (!xmlFile.exists()) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlFile);
            document.getDocumentElement().normalize();
            Element componentElement = (Element)document.getElementsByTagName("component").item(0);
            if (componentElement != null) {
                String name = componentElement.getAttribute("name");
                String packageName = componentElement.getAttribute("package");
                QName qName = new QName(packageName, name);
                return qName;
            }
            return null;
        }
        catch (Exception e) {
            carMojo.logError("Error occurred while extracting connector information: " + e.getMessage());
            return null;
        }
    }

    static {
        scannedConnections = false;
    }
}

