/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.metadata;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wso2.developerstudio.eclipse.utils.data.ITemporaryFileTag;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.Artifact;
import org.wso2.maven.capp.mojo.AbstractPOMGenMojo;
import org.wso2.maven.capp.utils.CAppMavenUtils;
import org.wso2.maven.esb.ESBArtifact;
import org.wso2.maven.esb.utils.ESBMavenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataPOMGenMojo
extends AbstractPOMGenMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private File outputLocation;
    private File artifactLocation;
    private File moduleProject;
    private String groupId;
    public String typeList;
    private MavenProject mavenModuleProject;
    private static final String ARTIFACT_TYPE = "synapse/metadata";

    private List<ESBArtifact> retrieveArtifacts() {
        return ESBMavenUtils.retrieveArtifacts((File)this.getArtifactLocation());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<ESBArtifact> artifacts = this.retrieveArtifacts();
        ArrayList<Artifact> mappedArtifacts = new ArrayList<Artifact>();
        for (ESBArtifact esbArtifact : artifacts) {
            Artifact artifact = new Artifact();
            artifact.setName(esbArtifact.getName());
            artifact.setVersion(esbArtifact.getVersion());
            artifact.setType(esbArtifact.getType());
            artifact.setServerRole(esbArtifact.getServerRole());
            artifact.setFile(esbArtifact.getFile());
            artifact.setSource(new File(this.getArtifactLocation(), "artifact.xml"));
            mappedArtifacts.add(artifact);
        }
        super.processArtifacts(mappedArtifacts);
    }

    protected void copyResources(MavenProject project, File projectLocation, Artifact artifact) throws IOException {
        ITemporaryFileTag newTag = FileUtils.createNewTempTag();
        File sequenceArtifact = this.getFile(artifact);
        org.codehaus.plexus.util.FileUtils.copyFile((File)sequenceArtifact, (File)new File(projectLocation, sequenceArtifact.getName()));
        newTag.clearAndEnd();
    }

    protected void addPlugins(MavenProject artifactMavenProject, Artifact artifact) {
        Plugin plugin = CAppMavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.wso2.maven", (String)"wso2-esb-metadata-plugin", (String)"5.2.31", (boolean)true);
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom aritfact = CAppMavenUtils.createConfigurationNode((Xpp3Dom)configuration, (String)"artifact");
        aritfact.setValue(this.getFile(artifact).getName());
    }

    protected String getArtifactType() {
        return ARTIFACT_TYPE;
    }

    private File getFile(Artifact artifact) {
        String filePath = artifact.getFilePath();
        filePath = filePath.replace("/synapse-config/", "/resources/");
        return new File(artifact.getSource().getParentFile(), filePath);
    }
}

