/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.registry;

import java.io.File;
import java.io.IOException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.wso2.developerstudio.eclipse.utils.file.FileUtils;
import org.wso2.maven.capp.model.Artifact;
import org.wso2.maven.capp.mojo.AbstractPOMGenMojo;
import org.wso2.maven.core.utils.MavenUtils;
import org.wso2.maven.registry.RegistryArtifact;
import org.wso2.maven.registry.RegistryInfo;
import org.wso2.maven.registry.beans.RegistryCollection;
import org.wso2.maven.registry.beans.RegistryElement;
import org.wso2.maven.registry.beans.RegistryItem;
import org.wso2.maven.registry.utils.GeneralProjectMavenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryResourcePOMGenMojo
extends AbstractPOMGenMojo {
    private MavenProject project;
    private MavenProjectHelper projectHelper;
    private File outputLocation;
    private File artifactLocation;
    private File moduleProject;
    private String groupId;
    private static final String ARTIFACT_TYPE = "registry/resource";
    private List<RegistryArtifact> artifacts;
    private Map<Artifact, RegistryArtifact> artifactToRegArtifactMap;

    private List<RegistryArtifact> retrieveArtifacts() {
        return GeneralProjectMavenUtils.retrieveArtifacts((File)this.getArtifactLocation());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Starting Artifacts list retrieval process."));
        }
        this.artifacts = this.retrieveArtifacts();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Artifacts list retrieval completed"));
        }
        ArrayList<Artifact> mappedArtifacts = new ArrayList<Artifact>();
        this.artifactToRegArtifactMap = new Hashtable<Artifact, RegistryArtifact>();
        for (RegistryArtifact registryArtifact : this.artifacts) {
            Artifact artifact = new Artifact();
            artifact.setName(registryArtifact.getName());
            artifact.setVersion(registryArtifact.getVersion());
            artifact.setType(registryArtifact.getType());
            artifact.setServerRole(registryArtifact.getServerRole());
            artifact.setFile("registry-info.xml");
            artifact.setSource(new File(this.getArtifactLocation(), "artifact.xml"));
            mappedArtifacts.add(artifact);
            this.artifactToRegArtifactMap.put(artifact, registryArtifact);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Artifact model mapping completed"));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Starting Artifact Processing"));
        }
        super.processArtifacts(mappedArtifacts);
    }

    protected void copyResources(MavenProject project, File projectLocation, Artifact artifact) throws IOException {
        RegistryArtifact mappedRegistryArtifact;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Starting to process the artifact copy process"));
        }
        File regInfoFile = new File(projectLocation, "registry-info.xml");
        RegistryInfo regInfo = new RegistryInfo();
        regInfo.setSource(regInfoFile);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Starting generation of Registry Resource Metadata"));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Reusing the previously collected Artifacts details."));
        }
        if ((mappedRegistryArtifact = this.artifactToRegArtifactMap.get(artifact)) != null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " C-App artifact to Registry Artifact Mapping available."));
            }
            List allRegistryItems = mappedRegistryArtifact.getAllRegistryItems();
            Iterator iterator = allRegistryItems.iterator();
            while (iterator.hasNext()) {
                RegistryElement registryItem = (RegistryElement)iterator.next();
                regInfo.addESBArtifact(registryItem);
            }
        } else {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " C-App artifact to Registry Artifact Mapping not available."));
            }
            for (RegistryArtifact registryArtifact : this.artifacts) {
                if (!registryArtifact.getName().equalsIgnoreCase(artifact.getName()) || !this.getProject().getVersion().equalsIgnoreCase(artifact.getVersion()) || !registryArtifact.getType().equalsIgnoreCase(artifact.getType()) || !registryArtifact.getServerRole().equalsIgnoreCase(artifact.getServerRole())) continue;
                List allRegistryItems = registryArtifact.getAllRegistryItems();
                for (RegistryElement registryItem : allRegistryItems) {
                    regInfo.addESBArtifact(registryItem);
                }
                break;
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Registry Resource Metadata collection is complete."));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Starting serialization of Registry Resource Metadata"));
        }
        try {
            regInfo.toFile();
        }
        catch (Exception allRegistryItems) {
            // empty catch block
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Completed serialization of Registry Resource Metadata"));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Start copying the Registry Resource Process"));
        }
        List allESBArtifacts = regInfo.getAllESBArtifacts();
        for (RegistryElement registryItem : allESBArtifacts) {
            File file = null;
            if (registryItem instanceof RegistryItem) {
                file = new File(artifact.getSource().getParentFile().getPath(), ((RegistryItem)registryItem).getFile());
                ((RegistryItem)registryItem).setFile(file.getName());
            } else if (registryItem instanceof RegistryCollection) {
                file = new File(artifact.getSource().getParentFile().getPath(), ((RegistryCollection)registryItem).getDirectory());
                ((RegistryCollection)registryItem).setDirectory(file.getName());
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + "  Metadata processing complete. Copying artifacts."));
            }
            if (file.isFile()) {
                File processedFile = this.processTokenReplacement(file);
                FileUtils.copy((File)processedFile, (File)new File(projectLocation, "resources" + File.separator + file.getName()));
            } else {
                FileUtils.copyDirectory((File)file, (File)new File(projectLocation, "resources" + File.separator + file.getName()));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Artifact Copying complete."));
            }
            try {
                regInfo.toFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Metadata file serialization completed."));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(new Time(System.currentTimeMillis()) + " Artifact copy process is completed"));
        }
    }

    protected void addPlugins(MavenProject artifactMavenProject, Artifact artifact) {
        Plugin plugin = MavenUtils.createPluginEntry((MavenProject)artifactMavenProject, (String)"org.wso2.maven", (String)"wso2-general-project-plugin", (String)"5.2.42", (boolean)true);
        Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom aritfact = MavenUtils.createConfigurationNode((Xpp3Dom)configuration, (String)"artifact");
        aritfact.setValue(artifact.getFile().getName());
    }

    protected String getArtifactType() {
        return ARTIFACT_TYPE;
    }
}

