/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.secret.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.keystore.IdentityKeyStoreWrapper;
import org.wso2.securevault.keystore.TrustKeyStoreWrapper;
import org.wso2.securevault.secret.SecretRepository;
import org.wso2.securevault.secret.SecretRepositoryProvider;

public class VaultSecretRepositoryProvider
implements SecretRepositoryProvider {
    private static final Log log = LogFactory.getLog(VaultSecretRepositoryProvider.class);
    private static final String PROP_SECRET_PROVIDERS = "secretProviders";
    private static final String PROP_REPOSITORIES = "repositories";
    private static final String PROPERTIES = "properties";
    private static final String DOT = ".";
    private final Map<String, SecretRepository> vaultRepositoryMap = new HashMap<String, SecretRepository>();

    @Override
    public SecretRepository getSecretRepository(IdentityKeyStoreWrapper identity, TrustKeyStoreWrapper trust) {
        return null;
    }

    @Override
    public Map<String, SecretRepository> initProvider(Properties configurationProperties, String providerType) throws SecureVaultException {
        StringBuilder repositoriesStringPropKey = new StringBuilder().append(PROP_SECRET_PROVIDERS).append(DOT).append(providerType).append(DOT).append(PROP_REPOSITORIES);
        String repositoriesString = MiscellaneousUtil.getProperty(configurationProperties, repositoriesStringPropKey.toString(), null);
        if (MiscellaneousUtil.isValidPropertyValue(repositoriesString)) {
            String[] repositories;
            for (String repo : repositories = repositoriesString.split(",")) {
                StringBuilder repositoryClassNamePropKey = new StringBuilder().append(repositoriesStringPropKey.toString()).append(DOT).append(repo);
                String repositoryClassName = MiscellaneousUtil.getProperty(configurationProperties, repositoryClassNamePropKey.toString(), null);
                if (!MiscellaneousUtil.isValidPropertyValue(repositoryClassName)) continue;
                try {
                    Class<?> repositoryClass = this.getClass().getClassLoader().loadClass(repositoryClassName.trim());
                    Object repositoryImpl = repositoryClass.newInstance();
                    if (!(repositoryImpl instanceof SecretRepository)) continue;
                    Properties repositoryProperties = VaultSecretRepositoryProvider.filterConfigurations(configurationProperties, repo);
                    ((SecretRepository)repositoryImpl).init(repositoryProperties, providerType);
                    this.vaultRepositoryMap.put(repo, (SecretRepository)repositoryImpl);
                }
                catch (Throwable e) {
                    throw new SecureVaultException("Error while initializing the secret repository " + repositoryClassName, e);
                }
            }
        }
        return this.vaultRepositoryMap;
    }

    private static Properties filterConfigurations(Properties configProperties, String repository) {
        Properties filteredProps = new Properties();
        StringBuilder propertyKeyPrefix = new StringBuilder().append(repository).append(DOT).append(PROPERTIES);
        configProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(propKey, propValue) -> {
            if (propKey.toString().contains(propertyKeyPrefix)) {
                filteredProps.put(propKey, propValue);
            }
        }));
        return filteredProps;
    }
}

