/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *   * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.wso2.securevault.secret.handler;

import org.wso2.securevault.secret.AbstractSecretCallbackHandler;
import org.wso2.securevault.secret.SecretCallback;
import org.wso2.securevault.secret.SecretCallbackHandler;
import org.wso2.securevault.secret.SingleSecretCallback;

/**
 * SecretCallbackHandler that uses an existing SecretCallbackHandler instance
 * provided when starting server
 */
public class SharedSecretCallbackHandler extends AbstractSecretCallbackHandler {

    private SecretCallbackHandler secretCallbackHandler =
            SharedSecretCallbackHandlerCache.getInstance().getSecretCallbackHandler();

    protected void handleSingleSecretCallback(SingleSecretCallback singleSecretCallback) {

        if (secretCallbackHandler == null) {
            if (log.isWarnEnabled()) {
                log.warn("There is no shared SecretCallbackHandler. " +
                        "Please use any other SecretCallbackHandler implementations");
            }
            return;
        }
        secretCallbackHandler.handle(new SecretCallback[]{singleSecretCallback});
    }
}
