/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.secret;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.definition.IdentityKeyStoreInformation;
import org.wso2.securevault.definition.KeyStoreInformationFactory;
import org.wso2.securevault.definition.TrustKeyStoreInformation;
import org.wso2.securevault.keystore.IdentityKeyStoreWrapper;
import org.wso2.securevault.keystore.TrustKeyStoreWrapper;
import org.wso2.securevault.secret.SecretRepository;
import org.wso2.securevault.secret.SecretRepositoryProvider;
import org.wso2.securevault.secret.repository.VaultSecretRepositoryProvider;

public class SecretManager {
    private static Log log = LogFactory.getLog(SecretManager.class);
    private static final SecretManager SECRET_MANAGER = new SecretManager();
    private static final String PROP_DEFAULT_CONF_LOCATION = "secret-manager.properties";
    private static final String PROP_SECRET_MANAGER_CONF = "secret.manager.conf";
    private static final String PROP_SECRET_REPOSITORIES = "secretRepositories";
    private static final String PROP_SECRET_MANAGER_ENABLED = "secVault.enabled";
    private static final String PROP_PROVIDER = "provider";
    private static final String DOT = ".";
    private static final String PROP_SECRET_PROVIDERS = "secretProviders";
    private static final String DELIMITER = ":";
    private SecretRepository parentRepository;
    private boolean initialized = false;
    private boolean legacyProvidersExist = false;
    private boolean novelProvidersExist = false;
    private String globalSecretProvider = null;
    private static final String PROP_SECRET_PROVIDER = "carbon.secretProvider";
    private Map<String, String> providers = new HashMap<String, String>();
    private Map<String, SecretRepository> secretRepositories = new HashMap<String, SecretRepository>();

    public static SecretManager getInstance() {
        return SECRET_MANAGER;
    }

    private SecretManager() {
    }

    public void init(Properties properties) {
        String enable;
        if (this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Secret Manager already has been started.");
            }
            return;
        }
        if (properties == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"KeyStore configuration properties cannot be found");
            }
            return;
        }
        String configurationFile = MiscellaneousUtil.getProperty(properties, PROP_SECRET_MANAGER_CONF, PROP_DEFAULT_CONF_LOCATION);
        Properties configurationProperties = MiscellaneousUtil.loadProperties(configurationFile);
        if (configurationProperties == null || configurationProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configuration properties can not be loaded form : " + configurationFile + " Will use synapse properties"));
            }
            configurationProperties = properties;
        }
        if (!Boolean.parseBoolean(enable = MiscellaneousUtil.getProperty(configurationProperties, PROP_SECRET_MANAGER_ENABLED, "true"))) {
            return;
        }
        this.globalSecretProvider = MiscellaneousUtil.getProperty(configurationProperties, PROP_SECRET_PROVIDER, null);
        if ((this.globalSecretProvider == null || "".equals(this.globalSecretProvider)) && log.isDebugEnabled()) {
            log.debug((Object)"No global secret provider is configured.");
        }
        this.loadProviders(configurationProperties);
        if (!this.isSecureVaultStatusValid()) {
            return;
        }
        Boolean encryptionEnabled = this.getEncryptionEnabledStatus(properties);
        IdentityKeyStoreWrapper identityKeyStoreWrapper = new IdentityKeyStoreWrapper();
        TrustKeyStoreWrapper trustKeyStoreWrapper = new TrustKeyStoreWrapper();
        if (this.legacyProvidersExist || this.novelProvidersExist && encryptionEnabled.booleanValue()) {
            String trustStorePass;
            IdentityKeyStoreInformation identityInformation = KeyStoreInformationFactory.createIdentityKeyStoreInformation(properties);
            TrustKeyStoreInformation trustInformation = KeyStoreInformationFactory.createTrustKeyStoreInformation(properties);
            String identityKeyPass = this.createIdentityKeyPassword(identityInformation);
            String identityStorePass = this.createIdentityStorePassword(identityInformation);
            if (!this.validatePasswords(identityStorePass, identityKeyPass, trustStorePass = this.createTrustStorePassword(trustInformation))) {
                if (log.isDebugEnabled()) {
                    log.info((Object)"Either Identity or Trust keystore password is mandatory in order to initialized secret manager.");
                }
                return;
            }
            identityKeyStoreWrapper.init(identityInformation, identityKeyPass);
            if (trustInformation != null) {
                trustKeyStoreWrapper.init(trustInformation);
            }
        }
        SecretRepository currentParent = null;
        for (Map.Entry<String, String> repositoryProvider : this.providers.entrySet()) {
            String providerType = repositoryProvider.getKey();
            String propertyName = repositoryProvider.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append(propertyName);
            sb.append(DOT);
            sb.append(providerType);
            String id = sb.toString();
            sb.append(DOT);
            sb.append(PROP_PROVIDER);
            String provider = MiscellaneousUtil.getProperty(configurationProperties, sb.toString(), null);
            if (provider == null || "".equals(provider)) {
                SecretManager.handleException("Repository provider cannot be null ");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initiating a Secret Repository");
            }
            try {
                Class<?> aClass = this.getClass().getClassLoader().loadClass(provider.trim());
                Object instance = aClass.newInstance();
                if (instance instanceof SecretRepositoryProvider) {
                    if (PROP_SECRET_PROVIDERS.equals(propertyName)) {
                        Properties filteredConfigs = this.filterConfigurations(providerType, configurationProperties);
                        if (instance instanceof VaultSecretRepositoryProvider && encryptionEnabled.booleanValue()) {
                            ((VaultSecretRepositoryProvider)instance).setProviderKeyStores(identityKeyStoreWrapper, trustKeyStoreWrapper);
                        }
                        Map<String, SecretRepository> providerBasedSecretRepositories = ((SecretRepositoryProvider)instance).initProvider(filteredConfigs, providerType);
                        this.secretRepositories.putAll(providerBasedSecretRepositories);
                    } else if (PROP_SECRET_REPOSITORIES.equals(propertyName)) {
                        SecretRepository secretRepository = ((SecretRepositoryProvider)instance).getSecretRepository(identityKeyStoreWrapper, trustKeyStoreWrapper);
                        secretRepository.init(configurationProperties, id);
                        if (this.parentRepository == null) {
                            this.parentRepository = secretRepository;
                        }
                        secretRepository.setParent(currentParent);
                        currentParent = secretRepository;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Successfully Initiate a Secret Repository provided by : " + provider));
                    continue;
                }
                SecretManager.handleException("Invalid class as SecretRepositoryProvider : Class Name : " + provider);
            }
            catch (ClassNotFoundException e) {
                SecretManager.handleException("A Secret Provider cannot be found for class name : " + provider);
            }
            catch (IllegalAccessException e) {
                SecretManager.handleException("Error creating a instance from class : " + provider);
            }
            catch (InstantiationException e) {
                SecretManager.handleException("Error creating a instance from class : " + provider);
            }
        }
        this.initialized = true;
    }

    public String resolveSecret(String secretAnnotation) {
        String[] secretAnnotationStrings = secretAnnotation.split(DELIMITER);
        if (secretAnnotationStrings.length == 1 && this.legacyProvidersExist) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting the value of " + secretAnnotation + " from the configured legacy provider."));
            }
            return this.getSecret(secretAnnotation);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting the value of " + secretAnnotation + " from the providers listed under secretProviders property."));
        }
        return this.resolveSecret(secretAnnotationStrings);
    }

    private String resolveSecret(String[] annotation) throws SecureVaultException {
        int length = annotation.length;
        switch (length) {
            case 1: {
                if (this.providers.isEmpty()) {
                    log.error((Object)"No provider has been configured. Returning the annotation itself.");
                    return Arrays.toString(annotation);
                }
                if (this.secretRepositories.isEmpty()) {
                    log.error((Object)"No repository has been configured. Returning the annotation itself.");
                    return Arrays.toString(annotation);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Set the values for the provider and the repository type. Returning the value for secret annotation.");
                }
                return this.getSecret((String)this.providers.keySet().toArray()[0], (String)this.secretRepositories.keySet().toArray()[0], annotation[0]);
            }
            case 3: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Returning the value for secret annotation.");
                }
                return this.getSecret(annotation[0], annotation[1], annotation[2]);
            }
        }
        throw new SecureVaultException("Invalid Annotation, The annotation expected to have [provider_type , repository_type , alias] but got " + Arrays.toString(annotation));
    }

    public String getSecret(String alias) {
        if (!this.initialized || this.parentRepository == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"There is no secret repository. Returning alias itself");
            }
            return alias;
        }
        return this.parentRepository.getSecret(alias);
    }

    private String getSecret(String provider, String repository, String alias) {
        if (!this.providers.containsKey(provider)) {
            log.error((Object)"Provider type in the annotation does not match with the configured providers. Returning the alias itself.");
            return alias;
        }
        if (!this.secretRepositories.containsKey(repository)) {
            log.error((Object)"Repository type in the annotation does not match with the configured repositories Returning the alias itself.");
            return alias;
        }
        return this.secretRepositories.get(repository).getSecret(alias);
    }

    public String getEncryptedData(String alias) {
        if (!this.initialized || this.parentRepository == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"There is no secret repository. Returning alias itself");
            }
            return alias;
        }
        return this.parentRepository.getEncryptedData(alias);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void shoutDown() {
        this.parentRepository = null;
        this.initialized = false;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SecureVaultException(msg);
    }

    private boolean validatePasswords(String identityStorePass, String identityKeyPass, String trustStorePass) {
        boolean isValid = false;
        if (trustStorePass != null && !"".equals(trustStorePass)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Trust Store Password cannot be found.");
            }
            isValid = true;
        } else if (identityStorePass != null && !"".equals(identityStorePass) && identityKeyPass != null && !"".equals(identityKeyPass)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Store Password and Identity Store private key Password cannot be found.");
            }
            isValid = true;
        }
        return isValid;
    }

    public String getGlobalSecretProvider() {
        return this.globalSecretProvider;
    }

    private void loadProviders(Properties secretConfigurationProperties) {
        this.readLegacyProviders(secretConfigurationProperties);
        this.readNovelProviders(secretConfigurationProperties);
    }

    private void readLegacyProviders(Properties secretConfigurationProperties) {
        String legacyProvidersString = MiscellaneousUtil.getProperty(secretConfigurationProperties, PROP_SECRET_REPOSITORIES, null);
        if (MiscellaneousUtil.isValidPropertyValue(legacyProvidersString)) {
            this.legacyProvidersExist = true;
            String[] legacyProviders = this.populateArrayOfSecretProviders(legacyProvidersString);
            this.addToProvidersMap(legacyProviders, PROP_SECRET_REPOSITORIES);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identified the providers listed under secretRepositories property of the secret-conf.");
            }
        }
    }

    private void readNovelProviders(Properties secretConfigurationProperties) {
        String novelProvidersString = MiscellaneousUtil.getProperty(secretConfigurationProperties, PROP_SECRET_PROVIDERS, null);
        if (MiscellaneousUtil.isValidPropertyValue(novelProvidersString)) {
            this.novelProvidersExist = true;
            String[] novelProviders = this.populateArrayOfSecretProviders(novelProvidersString);
            this.addToProvidersMap(novelProviders, PROP_SECRET_PROVIDERS);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identified the providers listed under secretProviders property of the secret-conf.");
            }
        }
    }

    private boolean isSecureVaultStatusValid() {
        if (!this.legacyProvidersExist && !this.novelProvidersExist) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No secret provider has been configured.");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Validated the secure vault status by identifying the configured secret providers.");
        }
        return true;
    }

    private void addToProvidersMap(String[] providersArray, String providerType) {
        for (String providerName : providersArray) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added a secret provider to providers map: " + this.providers));
            }
            this.providers.put(providerName, providerType);
        }
    }

    private String[] populateArrayOfSecretProviders(String propertyValue) {
        String[] propertyValues = propertyValue.split(",");
        if (propertyValues.length == 0 && log.isDebugEnabled()) {
            log.debug((Object)"No secret repositories have been configured.");
        }
        return propertyValues;
    }

    private String createIdentityKeyPassword(IdentityKeyStoreInformation identityInformation) {
        String identityKeyPass = null;
        if (identityInformation != null) {
            identityKeyPass = identityInformation.getKeyPasswordProvider().getResolvedSecret();
        }
        return identityKeyPass;
    }

    private String createIdentityStorePassword(IdentityKeyStoreInformation identityInformation) {
        String identityStorePass = null;
        if (identityInformation != null) {
            identityStorePass = identityInformation.getKeyStorePasswordProvider().getResolvedSecret();
        }
        return identityStorePass;
    }

    private String createTrustStorePassword(TrustKeyStoreInformation trustInformation) {
        String trustStorePass = null;
        if (trustInformation != null) {
            trustStorePass = trustInformation.getKeyStorePasswordProvider().getResolvedSecret();
        }
        return trustStorePass;
    }

    private Properties filterConfigurations(String provider, Properties configProperties) {
        Properties filteredProps = new Properties();
        configProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(propKey, propValue) -> {
            if (propKey.toString().contains(provider)) {
                filteredProps.put(propKey, propValue);
            }
        }));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returning the filtered properties.");
        }
        return filteredProps;
    }

    private boolean getEncryptionEnabledStatus(Properties properties) {
        for (Map.Entry<Object, Object> config : properties.entrySet()) {
            if (!config.getKey().toString().contains("encryptionEnabled") || !Boolean.parseBoolean(config.getValue().toString())) continue;
            return true;
        }
        return false;
    }
}

