/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.input.stream;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.execution.query.input.handler.Filter;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamFunction;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamFunctionExtension;
import org.wso2.siddhi.query.api.execution.query.input.handler.StreamHandler;
import org.wso2.siddhi.query.api.execution.query.input.handler.Window;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.InputStream;
import org.wso2.siddhi.query.api.expression.Expression;

public class SingleInputStream
extends InputStream {
    protected boolean isInnerStream = false;
    protected String streamId;
    protected String streamReferenceId;
    protected List<StreamHandler> streamHandlers = new ArrayList<StreamHandler>();
    protected int windowPosition = -1;

    protected SingleInputStream(String streamId) {
        this(streamId, false);
    }

    protected SingleInputStream(String streamId, boolean isInnerStream) {
        this(null, streamId, isInnerStream);
    }

    public SingleInputStream(String streamReferenceId, String streamId) {
        this(streamReferenceId, streamId, false);
    }

    public SingleInputStream(String streamReferenceId, String streamId, boolean isInnerStream) {
        this.streamReferenceId = streamReferenceId;
        this.isInnerStream = isInnerStream;
        this.streamId = isInnerStream ? "#".concat(streamId) : streamId;
    }

    public SingleInputStream(BasicSingleInputStream basicSingleInputStream, Window window) {
        this.streamId = basicSingleInputStream.getStreamId();
        this.isInnerStream = basicSingleInputStream.isInnerStream();
        this.streamReferenceId = basicSingleInputStream.getStreamReferenceId();
        this.streamHandlers = basicSingleInputStream.getStreamHandlers();
        this.windowPosition = basicSingleInputStream.getStreamHandlers().size();
        this.streamHandlers.add(window);
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getStreamReferenceId() {
        return this.streamReferenceId;
    }

    @Override
    public List<String> getAllStreamIds() {
        ArrayList<String> streamIds = new ArrayList<String>();
        streamIds.add(this.streamId);
        return streamIds;
    }

    @Override
    public List<String> getUniqueStreamIds() {
        return this.getAllStreamIds();
    }

    public SingleInputStream as(String streamReferenceId) {
        this.streamReferenceId = streamReferenceId;
        return this;
    }

    public List<StreamHandler> getStreamHandlers() {
        return this.streamHandlers;
    }

    public void addStreamHandlers(List<StreamHandler> streamHandlers) {
        this.streamHandlers.addAll(streamHandlers);
    }

    public SingleInputStream filter(Expression filterExpression) {
        this.streamHandlers.add(new Filter(filterExpression));
        return this;
    }

    public SingleInputStream filter(Filter filter) {
        this.streamHandlers.add(filter);
        return this;
    }

    public SingleInputStream function(String name, Expression ... parameters) {
        this.streamHandlers.add(new StreamFunction(name, parameters));
        return this;
    }

    public SingleInputStream function(String extensionName, String functionName, Expression ... parameters) {
        this.streamHandlers.add(new StreamFunctionExtension(extensionName, functionName, parameters));
        return this;
    }

    public SingleInputStream function(StreamFunction streamFunction) {
        this.streamHandlers.add(streamFunction);
        return this;
    }

    public boolean isInnerStream() {
        return this.isInnerStream;
    }

    public String toString() {
        return "SingleInputStream{isInnerStream=" + this.isInnerStream + ", id='" + this.streamId + '\'' + ", streamReferenceId='" + this.streamReferenceId + '\'' + ", streamHandlers=" + this.streamHandlers + ", windowPosition=" + this.windowPosition + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleInputStream)) {
            return false;
        }
        SingleInputStream that = (SingleInputStream)o;
        if (this.isInnerStream != that.isInnerStream) {
            return false;
        }
        if (this.windowPosition != that.windowPosition) {
            return false;
        }
        if (this.streamHandlers != null ? !this.streamHandlers.equals(that.streamHandlers) : that.streamHandlers != null) {
            return false;
        }
        if (this.streamId != null ? !this.streamId.equals(that.streamId) : that.streamId != null) {
            return false;
        }
        return !(this.streamReferenceId != null ? !this.streamReferenceId.equals(that.streamReferenceId) : that.streamReferenceId != null);
    }

    public int hashCode() {
        int result = this.isInnerStream ? 1 : 0;
        result = 31 * result + (this.streamId != null ? this.streamId.hashCode() : 0);
        result = 31 * result + (this.streamReferenceId != null ? this.streamReferenceId.hashCode() : 0);
        result = 31 * result + (this.streamHandlers != null ? this.streamHandlers.hashCode() : 0);
        result = 31 * result + this.windowPosition;
        return result;
    }
}

