/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.expression;

import org.wso2.siddhi.query.api.expression.Expression;

public class Variable
extends Expression {
    public static final int LAST = -2;
    private static final long serialVersionUID = 1L;
    private String streamId;
    private boolean isInnerStream;
    private Integer streamIndex = null;
    private String functionId;
    private Integer functionIndex;
    private String attributeName;

    public Variable(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public boolean isInnerStream() {
        return this.isInnerStream;
    }

    public Integer getStreamIndex() {
        return this.streamIndex;
    }

    public void setStreamIndex(Integer streamIndex) {
        this.streamIndex = streamIndex;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public Integer getFunctionIndex() {
        return this.functionIndex;
    }

    public void setFunctionIndex(Integer functionIndex) {
        this.functionIndex = functionIndex;
    }

    public void setStreamId(boolean isInnerStream, String streamId) {
        this.setStreamId(isInnerStream, false, streamId);
    }

    public void setStreamId(boolean isInnerStream, boolean isFaultStream, String streamId) {
        this.isInnerStream = isInnerStream;
        this.streamId = isInnerStream ? (isFaultStream ? "!".concat("#").concat(streamId) : "#".concat(streamId)) : (isFaultStream ? "!".concat(streamId) : streamId);
    }

    public Variable ofStream(String streamId) {
        this.streamId = streamId;
        this.isInnerStream = false;
        return this;
    }

    public Variable ofInnerStream(String streamId) {
        this.streamId = streamId;
        this.isInnerStream = false;
        return this;
    }

    public Variable ofStream(String streamId, int streamIndex) {
        this.streamId = streamId;
        this.streamIndex = streamIndex;
        this.isInnerStream = false;
        return this;
    }

    public Variable ofInnerStream(String streamId, int streamIndex) {
        this.streamId = streamId;
        this.streamIndex = streamIndex;
        this.isInnerStream = true;
        return this;
    }

    public Variable ofFunction(String functionId) {
        this.functionId = functionId;
        return this;
    }

    public Variable ofFunction(String functionId, int functionIndex) {
        this.functionId = functionId;
        this.functionIndex = functionIndex;
        return this;
    }

    public String toString() {
        return "Variable{id='" + this.streamId + '\'' + ", isInnerStream=" + this.isInnerStream + ", streamIndex=" + this.streamIndex + ", functionId='" + this.functionId + '\'' + ", functionIndex=" + this.functionIndex + ", attributeName='" + this.attributeName + '\'' + "} ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)o;
        if (this.isInnerStream != variable.isInnerStream) {
            return false;
        }
        if (this.attributeName != null ? !this.attributeName.equals(variable.attributeName) : variable.attributeName != null) {
            return false;
        }
        if (this.functionId != null ? !this.functionId.equals(variable.functionId) : variable.functionId != null) {
            return false;
        }
        if (this.functionIndex != null ? !this.functionIndex.equals(variable.functionIndex) : variable.functionIndex != null) {
            return false;
        }
        if (this.streamId != null ? !this.streamId.equals(variable.streamId) : variable.streamId != null) {
            return false;
        }
        return !(this.streamIndex != null ? !this.streamIndex.equals(variable.streamIndex) : variable.streamIndex != null);
    }

    public int hashCode() {
        int result = this.streamId != null ? this.streamId.hashCode() : 0;
        result = 31 * result + (this.isInnerStream ? 1 : 0);
        result = 31 * result + (this.streamIndex != null ? this.streamIndex.hashCode() : 0);
        result = 31 * result + (this.functionId != null ? this.functionId.hashCode() : 0);
        result = 31 * result + (this.functionIndex != null ? this.functionIndex.hashCode() : 0);
        result = 31 * result + (this.attributeName != null ? this.attributeName.hashCode() : 0);
        return result;
    }
}

