/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.execution.query.input.state;

import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.execution.query.input.state.AbsentStreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.CountStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.EveryStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.NextStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.api.expression.constant.TimeConstant;

public class State {
    public static StateElement every(StateElement stateElement) {
        return new EveryStateElement(stateElement);
    }

    public static StateElement logicalAnd(StreamStateElement streamStateElement1, StreamStateElement streamStateElement2) {
        return new LogicalStateElement(streamStateElement1, LogicalStateElement.Type.AND, streamStateElement2);
    }

    public static StateElement logicalOr(StreamStateElement streamStateElement1, StreamStateElement streamStateElement2) {
        return new LogicalStateElement(streamStateElement1, LogicalStateElement.Type.OR, streamStateElement2);
    }

    public static AbsentStreamStateElement logicalNot(StreamStateElement streamStateElement, TimeConstant time) {
        if (streamStateElement.getBasicSingleInputStream().getStreamReferenceId() != null) {
            throw new SiddhiAppValidationException("NOT pattern cannot have reference id but found " + streamStateElement.getBasicSingleInputStream().getStreamReferenceId());
        }
        return new AbsentStreamStateElement(streamStateElement.getBasicSingleInputStream(), time);
    }

    public static StateElement logicalNotAnd(AbsentStreamStateElement streamStateElement1, StreamStateElement streamStateElement2) {
        if (streamStateElement2 instanceof AbsentStreamStateElement) {
            return new LogicalStateElement(streamStateElement1, LogicalStateElement.Type.AND, streamStateElement2);
        }
        if (streamStateElement1.getWaitingTime() == null) {
            return new LogicalStateElement(streamStateElement1, LogicalStateElement.Type.AND, streamStateElement2);
        }
        return new LogicalStateElement(streamStateElement1, LogicalStateElement.Type.AND, streamStateElement2);
    }

    public static StateElement next(StateElement stateElement, StateElement followedByStateElement) {
        return new NextStateElement(stateElement, followedByStateElement);
    }

    public static StateElement count(StreamStateElement streamStateElement, int min, int max) {
        return new CountStateElement(streamStateElement, min, max);
    }

    public static StateElement countMoreThanEqual(StreamStateElement streamStateElement, int min) {
        return new CountStateElement(streamStateElement, min, -1);
    }

    public static StateElement countLessThanEqual(StreamStateElement streamStateElement, int max) {
        return new CountStateElement(streamStateElement, -1, max);
    }

    public static StreamStateElement stream(BasicSingleInputStream basicSingleInputStream) {
        return new StreamStateElement(basicSingleInputStream);
    }

    public static StateElement zeroOrMany(StreamStateElement streamStateElement) {
        return new CountStateElement(streamStateElement, 0, -1);
    }

    public static StateElement zeroOrOne(StreamStateElement streamStateElement) {
        return new CountStateElement(streamStateElement, 0, 1);
    }

    public static StateElement oneOrMany(StreamStateElement streamStateElement) {
        return new CountStateElement(streamStateElement, 1, -1);
    }
}

