/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import wvlet.airframe.control.Parallel;
import wvlet.airframe.control.Parallel$ParallelExecutionStats$;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Parallel$
implements LogSupport {
    public static Parallel$ MODULE$;
    private final Parallel.ParallelExecutionStats stats;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Parallel$();
    }

    private Logger logger$lzycompute() {
        Parallel$ parallel$ = this;
        synchronized (parallel$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void break() {
        throw new Parallel.BreakException();
    }

    public Parallel.ParallelExecutionStats stats() {
        return this.stats;
    }

    public <T, R> Seq<R> run(Seq<T> source, int parallelism, Function1<T, R> f, ClassTag<R> evidence$1) {
        Seq seq;
        BoxedUnit boxedUnit;
        String executionId = UUID.randomUUID().toString();
        if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "Parallel.scala", 74, 10), (Object)new StringBuilder(38).append(executionId).append(" - Begin Parallel.run (parallelism = ").append(parallelism).append(")").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LinkedBlockingQueue<Parallel.Worker> requestQueue = new LinkedBlockingQueue<Parallel.Worker>(parallelism);
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        AtomicBoolean interrupted = new AtomicBoolean(false);
        package$.MODULE$.Range().apply(0, parallelism).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Parallel.Worker worker = new Parallel.Worker(executionId, Integer.toString(i), requestQueue, resultQueue, interrupted, f);
            requestQueue.put(worker);
        });
        ExecutorService executor = Executors.newFixedThreadPool(parallelism);
        this.stats().totalThreads().addAndGet(parallelism);
        try {
            try {
                Iterator it = source.iterator();
                while (it.hasNext() && !interrupted.get()) {
                    Parallel.Worker worker = (Parallel.Worker)requestQueue.take();
                    if (!interrupted.get()) {
                        worker.message().set(it.next());
                        executor.execute(worker);
                        continue;
                    }
                    requestQueue.put(worker);
                }
                while (requestQueue.size() != parallelism) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                seq = ((TraversableOnce)((GenericTraversableTemplate)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(resultQueue).asScala()).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toSeq();
            }
            catch (InterruptedException interruptedException) {
                throw new TimeoutException();
            }
        }
        finally {
            executor.shutdown();
            requestQueue.clear();
            this.stats().totalThreads().addAndGet(parallelism * -1);
        }
        return seq;
    }

    public <T, R> int run$default$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    public <T, R> Iterator<R> iterate(Iterator<T> source, int parallelism, Function1<T, R> f) {
        BoxedUnit boxedUnit;
        String executionId = UUID.randomUUID().toString();
        if (this.logger().isEnabled((LogLevel)LogLevel.TRACE$.MODULE$)) {
            this.logger().log((LogLevel)LogLevel.TRACE$.MODULE$, new LogSource("", "Parallel.scala", 139, 10), (Object)new StringBuilder(42).append(executionId).append(" - Begin Parallel.iterate (parallelism = ").append(parallelism).append(")").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        LinkedBlockingQueue requestQueue = new LinkedBlockingQueue(parallelism);
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        AtomicBoolean interrupted = new AtomicBoolean(false);
        package$.MODULE$.Range().apply(0, parallelism).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Parallel.Worker worker = new Parallel.Worker(executionId, Integer.toString(i), requestQueue, resultQueue, interrupted, f);
            requestQueue.put(worker);
        });
        new Thread(parallelism, source, interrupted, requestQueue, resultQueue){
            private final int parallelism$1;
            private final Iterator source$1;
            private final AtomicBoolean interrupted$2;
            private final LinkedBlockingQueue requestQueue$2;
            private final LinkedBlockingQueue resultQueue$2;

            public void run() {
                ExecutorService executor = Executors.newFixedThreadPool(this.parallelism$1);
                Parallel$.MODULE$.stats().totalThreads().addAndGet(this.parallelism$1);
                try {
                    try {
                        while (this.source$1.hasNext() && !this.interrupted$2.get()) {
                            Parallel.Worker worker = (Parallel.Worker)this.requestQueue$2.take();
                            if (!this.interrupted$2.get()) {
                                worker.message().set(this.source$1.next());
                                executor.execute(worker);
                                continue;
                            }
                            this.requestQueue$2.put(worker);
                        }
                        while (this.requestQueue$2.size() != this.parallelism$1) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new TimeoutException();
                    }
                }
                finally {
                    this.resultQueue$2.put(None$.MODULE$);
                    executor.shutdown();
                    this.requestQueue$2.clear();
                    Parallel$.MODULE$.stats().totalThreads().addAndGet(this.parallelism$1 * -1);
                }
            }
            {
                this.parallelism$1 = parallelism$1;
                this.source$1 = source$1;
                this.interrupted$2 = interrupted$2;
                this.requestQueue$2 = requestQueue$2;
                this.resultQueue$2 = resultQueue$2;
            }
        }.start();
        return new Parallel.ResultIterator(resultQueue);
    }

    public <T, R> int iterate$default$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Parallel$() {
        MODULE$ = this;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        this.stats = new Parallel.ParallelExecutionStats(Parallel$ParallelExecutionStats$.MODULE$.$lessinit$greater$default$1(), Parallel$ParallelExecutionStats$.MODULE$.$lessinit$greater$default$2(), Parallel$ParallelExecutionStats$.MODULE$.$lessinit$greater$default$3(), Parallel$ParallelExecutionStats$.MODULE$.$lessinit$greater$default$4());
    }
}

