/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;
import scala.util.matching.Regex;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class CommandLineTokenizer$
implements LogSupport {
    public static CommandLineTokenizer$ MODULE$;
    private final Regex DOUBLE_QUOTED_LITERAL;
    private final Regex SINGLE_QUOTED_LITERAL;
    private final Regex REGULAR_TOKEN;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new CommandLineTokenizer$();
    }

    private Logger logger$lzycompute() {
        CommandLineTokenizer$ commandLineTokenizer$ = this;
        synchronized (commandLineTokenizer$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Regex DOUBLE_QUOTED_LITERAL() {
        return this.DOUBLE_QUOTED_LITERAL;
    }

    private Regex SINGLE_QUOTED_LITERAL() {
        return this.SINGLE_QUOTED_LITERAL;
    }

    private Regex REGULAR_TOKEN() {
        return this.REGULAR_TOKEN;
    }

    private String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }

    public String[] tokenize(String line) {
        return (String[])this.parse(0, line).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private List<String> parse(int pos, String line) {
        char ch;
        IntRef cursor = IntRef.create((int)pos);
        CommandLineTokenizer$.skipWhiteSpaces$1(cursor, line);
        if (cursor.elem >= line.length()) {
            return Nil$.MODULE$;
        }
        char c = ch = line.charAt(cursor.elem);
        switch (c) {
            case '\'': {
                Option option = this.SINGLE_QUOTED_LITERAL().findPrefixMatchOf((CharSequence)line.substring(cursor.elem));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Regex.Match m = (Regex.Match)some.value();
                    String token = m.matched();
                    String string = this.unquote(token);
                    return this.parse(cursor.elem + token.length(), line).$colon$colon((Object)string);
                }
                if (None$.MODULE$.equals(option)) {
                    return this.parseToken$1(line, cursor, pos);
                }
                throw new MatchError((Object)option);
            }
            case '\"': {
                Option option = this.DOUBLE_QUOTED_LITERAL().findPrefixMatchOf((CharSequence)line.substring(cursor.elem));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Regex.Match m = (Regex.Match)some.value();
                    String token = m.matched();
                    String string = this.unquote(token);
                    return this.parse(cursor.elem + token.length(), line).$colon$colon((Object)string);
                }
                if (None$.MODULE$.equals(option)) {
                    return this.parseToken$1(line, cursor, pos);
                }
                throw new MatchError((Object)option);
            }
        }
        return this.parseToken$1(line, cursor, pos);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final void skipWhiteSpaces$1(IntRef cursor$1, String line$1) {
        boolean toContinue = true;
        block3: while (toContinue && cursor$1.elem < line$1.length()) {
            char ch;
            char c = ch = line$1.charAt(cursor$1.elem);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++cursor$1.elem;
                    continue block3;
                }
            }
            toContinue = false;
        }
    }

    private final List parseToken$1(String line$1, IntRef cursor$1, int pos$1) {
        Option option = this.REGULAR_TOKEN().findPrefixMatchOf((CharSequence)line$1.substring(cursor$1.elem));
        if (option instanceof Some) {
            String token;
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            String string = token = m.matched();
            return this.parse(cursor$1.elem + token.length(), line$1).$colon$colon((Object)string);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Failed to parse token. pos:").append(pos$1).append("\n").append(line$1).toString());
        }
        throw new MatchError((Object)option);
    }

    private CommandLineTokenizer$() {
        MODULE$ = this;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        this.DOUBLE_QUOTED_LITERAL = new StringOps(Predef$.MODULE$.augmentString("\"([^\"\\p{Cntrl}\\\\]|\\\\[\\\\/\\\\\"bfnrt]|\\\\u[a-fA-F0-9]{4})*\"")).r();
        this.SINGLE_QUOTED_LITERAL = new StringOps(Predef$.MODULE$.augmentString("'([^'\\p{Cntrl}\\\\]|\\\\[\\\\/\\\\\"bfnrt]|\\\\u[a-fA-F0-9]{4})*'")).r();
        this.REGULAR_TOKEN = new StringOps(Predef$.MODULE$.augmentString("([^\\\"'\\s]+)")).r();
    }
}

