/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.control.util;

import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a2Q\u0001C\u0005\u0001\u0017EA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\u0006;\u0001!\tA\b\u0005\u0007E\u0001\u0001\u000b\u0015\u0002\u000e\t\r\r\u0002\u0001\u0015)\u0003%\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u0015\u0019\u0004\u0001\"\u00015\u0005a)\u0005\u0010]8oK:$\u0018.\u00197N_ZLgnZ!wKJ\fw-\u001a\u0006\u0003\u0015-\tA!\u001e;jY*\u0011A\"D\u0001\bG>tGO]8m\u0015\tqq\"\u0001\u0005bSJ4'/Y7f\u0015\u0005\u0001\u0012!B<wY\u0016$8C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u0006Qq/\u001b8e_^\u001c\u0016N_3\u0004\u0001A\u00111cG\u0005\u00039Q\u0011A\u0001T8oO\u00061A(\u001b8jiz\"\"aH\u0011\u0011\u0005\u0001\u0002Q\"A\u0005\t\u000ba\u0011\u0001\u0019\u0001\u000e\u0002\tQLW.Z\u0001\u0004K6\f\u0007CA\n&\u0013\t1CC\u0001\u0004E_V\u0014G.\u001a\u0015\u0003\t!\u0002\"aE\u0015\n\u0005)\"\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\rU\u0004H-\u0019;f)\r!Sf\f\u0005\u0006]\u0015\u0001\rAG\u0001\ni&lWm\u0015;b[BDQ\u0001M\u0003A\u0002\u0011\n\u0011\u0001_\u0001\u0005Y\u0006\u001cH/F\u0001%\u0003\u0015\u0011Xm]3u)\u0005)\u0004CA\n7\u0013\t9DC\u0001\u0003V]&$\b")
public class ExponentialMovingAverage {
    private final long windowSize;
    private long time;
    private volatile double ema;

    public double update(long timeStamp, double x) {
        double newEma;
        if (this.time == Long.MIN_VALUE) {
            this.time = timeStamp;
            this.ema = x;
            return x;
        }
        long td = timeStamp - this.time;
        Predef$.MODULE$.assert(td >= 0L, (Function0 & java.io.Serializable & Serializable)() -> "Nonmonotonic timestamp");
        this.time = timeStamp;
        double w = (double)this.windowSize == 0.0 ? 0.0 : package$.MODULE$.exp(-((double)td) / (double)this.windowSize);
        this.ema = newEma = x * (1.0 - w) + this.ema * w;
        return newEma;
    }

    public double last() {
        return this.ema;
    }

    public void reset() {
        this.time = Long.MIN_VALUE;
        this.ema = 0.0;
    }

    public ExponentialMovingAverage(long windowSize) {
        this.windowSize = windowSize;
        this.time = Long.MIN_VALUE;
        this.ema = 0.0;
    }
}

