/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.internal;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpServerException;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCStatus;
import wvlet.airframe.http.RPCStatus$;
import wvlet.airframe.http.RPCStatus$INTERNAL_ERROR_I0$;
import wvlet.airframe.http.RxHttpEndpoint;
import wvlet.airframe.http.RxHttpFilter;
import wvlet.airframe.rx.Rx;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class RPCResponseFilter$
implements RxHttpFilter,
LogSupport {
    public static RPCResponseFilter$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new RPCResponseFilter$();
    }

    @Override
    public RxHttpFilter andThen(RxHttpFilter nextFilter) {
        return RxHttpFilter.andThen$((RxHttpFilter)this, nextFilter);
    }

    @Override
    public RxHttpEndpoint andThen(RxHttpEndpoint endpoint) {
        return RxHttpFilter.andThen$((RxHttpFilter)this, endpoint);
    }

    private Logger logger$lzycompute() {
        RPCResponseFilter$ rPCResponseFilter$ = this;
        synchronized (rPCResponseFilter$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Rx<HttpMessage.Response> apply(HttpMessage.Request request, RxHttpEndpoint next) {
        return next.apply(request).transform((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                HttpMessage.Response resp = (HttpMessage.Response)success.value();
                return MODULE$.setRPCStatus(resp);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                Throwable throwable = e;
                if (throwable instanceof HttpServerException) {
                    HttpServerException httpServerException = (HttpServerException)throwable;
                    RPCStatus qual$1 = RPCStatus$.MODULE$.fromHttpStatus(httpServerException.status());
                    String x$1 = httpServerException.getMessage();
                    Throwable x$2 = httpServerException.getCause();
                    int x$3 = qual$1.newException$default$3();
                    Map<String, Object> x$4 = qual$1.newException$default$4();
                    RPCException re = qual$1.newException(x$1, x$2, x$3, x$4);
                    return re.toResponse();
                }
                if (throwable instanceof RPCException) {
                    RPCException rPCException = (RPCException)throwable;
                    return rPCException.toResponse();
                }
                return RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException(throwable.getMessage(), throwable, RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException$default$3(), RPCStatus$INTERNAL_ERROR_I0$.MODULE$.newException$default$4()).toResponse();
            }
            throw new MatchError((Object)try_);
        });
    }

    private HttpMessage.Response setRPCStatus(HttpMessage.Response resp) {
        Option<String> option = resp.getHeader("x-airframe-rpc-status");
        if (option instanceof Some) {
            return resp;
        }
        if (None$.MODULE$.equals(option)) {
            RPCStatus status = RPCStatus$.MODULE$.fromHttpStatus(resp.status());
            return (HttpMessage.Response)resp.addHeader("x-airframe-rpc-status", Integer.toString(status.code()));
        }
        throw new MatchError(option);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RPCResponseFilter$() {
        MODULE$ = this;
        RxHttpFilter.$init$(this);
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
    }
}

