/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.client;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import wvlet.airframe.codec.MessageCodec;
import wvlet.airframe.codec.MessageCodec$;
import wvlet.airframe.codec.PrimitiveCodec;
import wvlet.airframe.control.CircuitBreakerOpenException;
import wvlet.airframe.control.Retry;
import wvlet.airframe.control.Retry$;
import wvlet.airframe.http.Http$;
import wvlet.airframe.http.HttpClientException;
import wvlet.airframe.http.HttpClientException$;
import wvlet.airframe.http.HttpClientMaxRetryException;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMessage$;
import wvlet.airframe.http.HttpMessage$HttpMessageResponseAdapter$;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpMultiMap$;
import wvlet.airframe.http.HttpRequestAdapter;
import wvlet.airframe.http.HttpResponseAdapter;
import wvlet.airframe.http.HttpStatus$BadRequest_400$;
import wvlet.airframe.http.HttpStatus$InternalServerError_500$;
import wvlet.airframe.http.HttpStatus$ServiceUnavailable_503$;
import wvlet.airframe.http.RPCEncoding;
import wvlet.airframe.http.RPCEncoding$JSON$;
import wvlet.airframe.http.RPCEncoding$MsgPack$;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCException$;
import wvlet.airframe.http.RPCStatus$DATA_LOSS_I8$;
import wvlet.airframe.http.RPCStatus$INVALID_ARGUMENT_U2$;
import wvlet.airframe.http.client.HttpClientConfig;
import wvlet.airframe.http.internal.HttpResponseBodyCodec;
import wvlet.airframe.http.package$;
import wvlet.airframe.json.JSON;
import wvlet.airframe.surface.Surface;
import wvlet.log.LazyLogger;
import wvlet.log.LogLevel;
import wvlet.log.LogSource;
import wvlet.log.LogSupport;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpClients$
implements LogSupport {
    public static HttpClients$ MODULE$;
    private final HttpResponseBodyCodec<HttpMessage.Response> responseBodyCodec;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HttpClients$();
    }

    private Logger logger$lzycompute() {
        HttpClients$ httpClients$ = this;
        synchronized (httpClients$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private HttpResponseBodyCodec<HttpMessage.Response> responseBodyCodec() {
        return this.responseBodyCodec;
    }

    public <Req, Resp> Retry.RetryContext baseHttpClientRetry(HttpRequestAdapter<Req> evidence$1, ClassTag<Req> evidence$2, HttpResponseAdapter<Resp> evidence$3) {
        return Retry$.MODULE$.withJitter(15, Retry$.MODULE$.withJitter$default$2(), Retry$.MODULE$.withJitter$default$3(), Retry$.MODULE$.withJitter$default$4()).withResultClassifier((Function1 & Serializable & scala.Serializable)response -> HttpClientException$.MODULE$.classifyHttpResponse(response, evidence$3)).beforeRetry((Function1 & Serializable & scala.Serializable)ctx -> MODULE$.defaultBeforeRetryAction((Retry.RetryContext)ctx, evidence$1, evidence$2));
    }

    public <Req, Resp> Retry.RetryContext defaultHttpClientRetry(HttpRequestAdapter<Req> evidence$4, ClassTag<Req> evidence$5, HttpResponseAdapter<Resp> evidence$6) {
        return this.baseHttpClientRetry(evidence$4, evidence$5, evidence$6).withErrorClassifier((Function1 & Serializable & scala.Serializable)ex -> HttpClientException$.MODULE$.classifyExecutionFailure((Throwable)ex));
    }

    public <Req> Object defaultBeforeRetryAction(Retry.RetryContext ctx, HttpRequestAdapter<Req> evidence$7, ClassTag<Req> evidence$8) {
        String string;
        Some some;
        Object r;
        Class cls = ((ClassTag)Predef$.MODULE$.implicitly(evidence$8)).runtimeClass();
        Option option = ctx.context();
        if (option instanceof Some && cls.isAssignableFrom((r = (some = (Some)option).value()).getClass())) {
            HttpRequestAdapter adapter = (HttpRequestAdapter)Predef$.MODULE$.implicitly(evidence$7);
            Object req = r;
            String path = adapter.pathOf(req);
            string = new java.lang.StringBuilder(23).append("Request to ").append(path).append(" is failed: ").append(ctx.lastError().getMessage()).toString();
        } else {
            string = new java.lang.StringBuilder(19).append("Request is failed: ").append(ctx.lastError().getMessage()).toString();
        }
        String errorMessage = string;
        int nextWaitMillis = ctx.nextWaitMillis();
        if (this.logger().isEnabled((LogLevel)LogLevel.WARN$.MODULE$)) {
            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)ctx.retryCount());
            Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)ctx.maxRetry());
            String arg$macro$3 = errorMessage;
            double arg$macro$4 = (double)nextWaitMillis / 1000.0;
            this.logger().log((LogLevel)LogLevel.WARN$.MODULE$, new LogSource("", "HttpClients.scala", 67, 9), (Object)new StringOps("[%s/%s] %s. Retry the request in %.3f sec.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, BoxesRunTime.boxToDouble((double)arg$macro$4)})));
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public PartialFunction<Throwable, Nothing$> defaultHttpClientErrorHandler(Function0<Option<HttpMessage.Response>> lastResponse) {
        return new scala.Serializable(lastResponse){
            public static final long serialVersionUID = 0L;
            private final Function0 lastResponse$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof HttpClientException) {
                    HttpClientException httpClientException = (HttpClientException)A1;
                    HttpMessage.Response resp = httpClientException.response().toHttpResponse();
                    Option<String> option = resp.getHeader("x-airframe-rpc-status");
                    if (option instanceof Some) {
                        RPCException ex = RPCException$.MODULE$.fromResponse(httpClientException.response().toHttpResponse());
                        throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), ex.status().httpStatus(), ex.message(), ex);
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw httpClientException;
                    }
                    throw new MatchError(option);
                }
                if (A1 instanceof RPCException) {
                    RPCException rPCException = (RPCException)A1;
                    HttpMessage.Response resp = rPCException.toResponse();
                    throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), rPCException.status().httpStatus(), rPCException.message(), rPCException);
                }
                if (A1 instanceof CircuitBreakerOpenException) {
                    CircuitBreakerOpenException circuitBreakerOpenException = (CircuitBreakerOpenException)A1;
                    HttpMessage.Response resp = (HttpMessage.Response)((Option)this.lastResponse$1.apply()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Http$.MODULE$.response(HttpStatus$ServiceUnavailable_503$.MODULE$));
                    throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), circuitBreakerOpenException.getMessage(), (Throwable)circuitBreakerOpenException);
                }
                if (A1 instanceof Retry.MaxRetryException) {
                    Retry.MaxRetryException maxRetryException = (Retry.MaxRetryException)A1;
                    throw new HttpClientMaxRetryException(HttpMessage$.MODULE$.HttpMessageResponseWrapper((HttpMessage.Response)((Option)this.lastResponse$1.apply()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Http$.MODULE$.response(HttpStatus$InternalServerError_500$.MODULE$))), maxRetryException.retryContext(), maxRetryException.retryContext().lastError());
                }
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    HttpMessage.Response resp = (HttpMessage.Response)((Option)this.lastResponse$1.apply()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Http$.MODULE$.response(HttpStatus$InternalServerError_500$.MODULE$));
                    throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), e.getMessage(), e);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof HttpClientException) {
                    return true;
                }
                if (throwable instanceof RPCException) {
                    return true;
                }
                if (throwable instanceof CircuitBreakerOpenException) {
                    return true;
                }
                if (throwable instanceof Retry.MaxRetryException) {
                    return true;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable);
                return !option.isEmpty();
            }
            {
                this.lastResponse$1 = lastResponse$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3()}, serializedLambda);
            }
        };
    }

    public String urlEncode(String s) {
        return package$.MODULE$.compat().urlEncode(s);
    }

    public <Resource> String buildResourceUri(String path, Resource resource, Surface resourceSurface) {
        BoxedUnit boxedUnit;
        HttpMultiMap queryParams = this.flattenResourceToQueryParams(resource, resourceSurface);
        StringBuilder pathWithParams = new StringBuilder();
        pathWithParams.append(path);
        if (queryParams.nonEmpty()) {
            String queryParamString = ((TraversableOnce)queryParams.entries().map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(1).append(x.key()).append("=").append(x.value()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("&");
            pathWithParams.append("?");
            boxedUnit = pathWithParams.append(queryParamString);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return pathWithParams.result();
    }

    public <Resource> HttpMultiMap flattenResourceToQueryParams(Resource resource, Surface resourceSurface) {
        MessageCodec resourceCodec = MessageCodec$.MODULE$.ofSurface(resourceSurface);
        JSON.JSONObject resourceJson = (JSON.JSONObject)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> resourceCodec.toJSONObject(resource)).getOrElse((Function0 & Serializable & scala.Serializable)() -> JSON.JSONObject$.MODULE$.empty());
        HttpMultiMap.HttpMultiMapBuilder queryParams = HttpMultiMap$.MODULE$.newBuilder();
        resourceJson.v().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JSON.JSONValue j = (JSON.JSONValue)tuple2._2();
                if (j instanceof JSON.JSONArray) {
                    JSON.JSONArray jSONArray = (JSON.JSONArray)j;
                    return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(jSONArray.toJSON())));
                }
            }
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JSON.JSONValue j = (JSON.JSONValue)tuple2._2();
                if (j instanceof JSON.JSONObject) {
                    JSON.JSONObject jSONObject = (JSON.JSONObject)j;
                    return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(jSONObject.toJSON())));
                }
            }
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                JSON.JSONValue other = (JSON.JSONValue)tuple2._2();
                return queryParams.$plus$eq((Tuple2<String, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.urlEncode(k)), (Object)MODULE$.urlEncode(other.toString())));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        return queryParams.result();
    }

    public <Req> HttpMessage.Request prepareRequest(HttpClientConfig config, HttpMessage.Request baseRequest, Surface requestSurface, Req requestBody) {
        HttpMessage.Request request;
        block5: {
            try {
                String string = baseRequest.method();
                if ("GET".equals(string)) {
                    String newPath = this.buildResourceUri(baseRequest.path(), requestBody, requestSurface);
                    request = baseRequest.withUri(newPath);
                    break block5;
                }
                MessageCodec requestCodec = config.codecFactory().ofSurface(requestSurface, config.codecFactory().ofSurface$default$2());
                byte[] bytes = config.rpcEncoding().encodeWithCodec(requestBody, requestCodec);
                RPCEncoding rPCEncoding = config.rpcEncoding();
                if (RPCEncoding$MsgPack$.MODULE$.equals(rPCEncoding)) {
                    request = (HttpMessage.Request)baseRequest.withMsgPack(bytes);
                    break block5;
                }
                if (RPCEncoding$JSON$.MODULE$.equals(rPCEncoding)) {
                    request = (HttpMessage.Request)baseRequest.withJson(bytes);
                    break block5;
                }
                throw new MatchError((Object)rPCEncoding);
            }
            catch (Throwable e) {
                throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(Http$.MODULE$.response(HttpStatus$BadRequest_400$.MODULE$)), HttpStatus$BadRequest_400$.MODULE$, new java.lang.StringBuilder(40).append("Failed to encode the HTTP request body: ").append(requestBody).toString(), e);
            }
        }
        return request;
    }

    public <Resp> Resp parseResponse(HttpClientConfig config, Surface responseSurface, HttpMessage.Response resp) {
        Object object;
        if (HttpMessage.Response.class.isAssignableFrom(responseSurface.rawType())) {
            return (Resp)resp;
        }
        try {
            Object responseObject;
            MessageCodec codec;
            byte[] msgpack = this.responseBodyCodec().toMsgPack(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp));
            MessageCodec messageCodec = codec = config.codecFactory().ofSurface(responseSurface, config.codecFactory().ofSurface$default$2());
            object = PrimitiveCodec.UnitCodec$.MODULE$.equals(messageCodec) ? null : (responseObject = codec.fromMsgPack(msgpack));
        }
        catch (Throwable e) {
            throw new HttpClientException(HttpMessage$.MODULE$.HttpMessageResponseWrapper(resp), resp.status(), new java.lang.StringBuilder(48).append("Failed to parse the response from the server: ").append(resp).append(": ").append(e.getMessage()).toString(), e);
        }
        return (Resp)object;
    }

    public HttpMessage.Request prepareRPCRequest(HttpClientConfig config, String resourcePath, Surface requestSurface, Object requestContent) {
        HttpMessage.Request request;
        MessageCodec requestEncoder = config.codecFactory().ofSurface(requestSurface, config.codecFactory().ofSurface$default$2());
        try {
            request = (HttpMessage.Request)((HttpMessage)((HttpMessage)Http$.MODULE$.POST(resourcePath).withContentType(config.rpcEncoding().applicationType())).withAccept(config.rpcEncoding().applicationType())).withContent(config.rpcEncoding().encodeWithCodec(requestContent, requestEncoder));
        }
        catch (Throwable e) {
            throw RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException(new java.lang.StringBuilder(44).append("Failed to encode the RPC request argument ").append(requestContent).append(": ").append(e.getMessage()).toString(), e, RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException$default$3(), RPCStatus$INVALID_ARGUMENT_U2$.MODULE$.newException$default$4());
        }
        return request;
    }

    public Object parseRPCResponse(HttpClientConfig config, HttpMessage.Response response, Surface responseSurface) {
        Object object;
        if (HttpMessage.Response.class.isAssignableFrom(responseSurface.rawType())) {
            return response;
        }
        try {
            Object responseObject;
            MessageCodec codec;
            byte[] msgpack = this.responseBodyCodec().toMsgPack(HttpMessage$.MODULE$.HttpMessageResponseWrapper(response));
            MessageCodec messageCodec = codec = config.codecFactory().ofSurface(responseSurface, config.codecFactory().ofSurface$default$2());
            object = PrimitiveCodec.UnitCodec$.MODULE$.equals(messageCodec) ? null : (responseObject = codec.fromMsgPack(msgpack));
        }
        catch (Throwable e) {
            throw RPCStatus$DATA_LOSS_I8$.MODULE$.newException(new java.lang.StringBuilder(51).append("Failed to parse the RPC response from the server ").append(response).append(": ").append(e.getMessage()).toString(), e, RPCStatus$DATA_LOSS_I8$.MODULE$.newException$default$3(), RPCStatus$DATA_LOSS_I8$.MODULE$.newException$default$4());
        }
        return object;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HttpClients$() {
        MODULE$ = this;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        this.responseBodyCodec = new HttpResponseBodyCodec<HttpMessage.Response>(HttpMessage$HttpMessageResponseAdapter$.MODULE$);
    }
}

