/*
 * Decompiled with CFR 0.152.
 */
package wvlet.airframe.http.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import wvlet.airframe.http.HttpContext;
import wvlet.airframe.http.HttpMessage;
import wvlet.airframe.http.HttpMultiMap;
import wvlet.airframe.http.HttpServerException;
import wvlet.airframe.http.RPCException;
import wvlet.airframe.http.RPCMethod;
import wvlet.airframe.http.RPCStatus;
import wvlet.airframe.http.RPCStatus$;
import wvlet.airframe.http.internal.RPCCallContext;
import wvlet.airframe.surface.MethodParameter;
import wvlet.airframe.surface.Parameter;
import wvlet.airframe.surface.Surface;
import wvlet.airframe.ulid.ULID;
import wvlet.log.LazyLogger;
import wvlet.log.LogSupport;
import wvlet.log.LogTimestampFormatter$;
import wvlet.log.Logger;
import wvlet.log.LoggingMethods;

public final class HttpLogs$
implements LogSupport {
    public static HttpLogs$ MODULE$;
    private final scala.collection.concurrent.Map<String, String> headerSanitizeCache;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new HttpLogs$();
    }

    private Logger logger$lzycompute() {
        HttpLogs$ httpLogs$ = this;
        synchronized (httpLogs$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogger.logger$((LazyLogger)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public ListMap<String, Object> durationLogs(long baseTime, long sinceNano) {
        long end = System.nanoTime();
        long durationMills = TimeUnit.NANOSECONDS.toMillis(end - sinceNano);
        return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"end_time_ms"), (Object)BoxesRunTime.boxToLong((long)(baseTime + durationMills))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duration_ms"), (Object)BoxesRunTime.boxToLong((long)durationMills))}));
    }

    public ListMap<String, Object> unixTimeLogs(long currentTimeMillis) {
        return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"time"), (Object)BoxesRunTime.boxToLong((long)(currentTimeMillis / 1000L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"start_time_ms"), (Object)BoxesRunTime.boxToLong((long)currentTimeMillis)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"event_timestamp"), (Object)LogTimestampFormatter$.MODULE$.formatTimestampWithNoSpaace(currentTimeMillis))}));
    }

    public long unixTimeLogs$default$1() {
        return System.currentTimeMillis();
    }

    public Map<String, Object> commonRequestLogs(HttpMessage.Request request) {
        Builder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"method"), (Object)request.method().toString()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)request.path()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uri"), (Object)this.sanitize(request.uri())));
        String queryString = this.extractQueryString(request.uri());
        Object object = new StringOps(Predef$.MODULE$.augmentString(queryString)).nonEmpty() ? m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"query_string"), (Object)queryString)) : BoxedUnit.UNIT;
        request.dest().foreach((Function1 & Serializable & scala.Serializable)d -> m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dest"), (Object)d.hostAndPort())));
        request.remoteAddress().foreach((Function1 & Serializable & scala.Serializable)remoteAddr -> m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remote_address"), (Object)remoteAddr.hostAndPort())));
        return (Map)m.result();
    }

    public Map<String, Object> commonResponseLogs(HttpMessage.Response response) {
        Builder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status_code"), (Object)BoxesRunTime.boxToInteger((int)response.statusCode())));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status_code_name"), (Object)response.status().reason()));
        response.contentLength().foreach((Function1 & Serializable & scala.Serializable)x$3 -> m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_content_length"), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$3)))));
        response.getHeader("x-airframe-rpc-status").foreach((Function1 & Serializable & scala.Serializable)rpcStatus -> {
            HttpLogs$.$anonfun$commonResponseLogs$2(m, rpcStatus);
            return BoxedUnit.UNIT;
        });
        return (Map)m.result();
    }

    public Map<String, Object> rpcStatusLogs(RPCStatus status) {
        return (Map)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_status"), (Object)BoxesRunTime.boxToInteger((int)status.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_status_name"), (Object)status.name())}));
    }

    public Map<String, Object> requestHeaderLogs(HttpMessage.Request request, HttpMultiMap excludeHeaders) {
        Map<String, Object> m = this.headerLogs(request.header(), excludeHeaders);
        if (m.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_header"), m)}));
    }

    public Map<String, Object> responseHeaderLogs(HttpMessage.Response response, HttpMultiMap excludeHeaders) {
        Map<String, Object> m = this.headerLogs(response.header(), excludeHeaders);
        if (m.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_header"), m)}));
    }

    public Map<String, Object> headerLogs(HttpMultiMap headerMap, HttpMultiMap excludeHeaders) {
        Builder m = ListMap$.MODULE$.newBuilder();
        headerMap.entries().foreach((Function1 & Serializable & scala.Serializable)e -> {
            if (!excludeHeaders.contains(e.key().toLowerCase())) {
                String v = headerMap.getAll(e.key()).mkString(";");
                return m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.sanitizeHeader(e.key())), (Object)v));
            }
            return BoxedUnit.UNIT;
        });
        return (Map)m.result();
    }

    public Map<String, Object> rpcMethodLogs(RPCMethod rpcMethod) {
        return rpcMethod.logData();
    }

    public ListMap<String, Object> rpcLogs(RPCCallContext rpcContext) {
        Builder m = ListMap$.MODULE$.newBuilder();
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_interface"), (Object)rpcContext.rpcInterfaceName()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_class"), (Object)rpcContext.rpcClassName()));
        m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_method"), (Object)rpcContext.rpcMethodName()));
        ListMap<String, Object> rpcArgs = this.extractRpcArgLog(rpcContext);
        Object object = rpcArgs.nonEmpty() ? m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rpc_args"), rpcArgs)) : BoxedUnit.UNIT;
        return (ListMap)m.result();
    }

    public ListMap<String, Object> extractRpcArgLog(RPCCallContext rpcContext) {
        Builder rpcArgsBuilder = ListMap$.MODULE$.newBuilder();
        ((TraversableLike)rpcContext.rpcMethodSurface().args().zip(rpcContext.rpcArgs(), Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HttpLogs$.$anonfun$extractRpcArgLog$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 != null) {
                MethodParameter p = (MethodParameter)tuple2._1();
                Object arg = tuple2._2();
                return (Builder)rpcArgsBuilder.$plus$plus$eq((TraversableOnce)HttpLogs$.traverseParam$1((Parameter)p, arg));
            }
            throw new MatchError((Object)tuple2);
        });
        return (ListMap)rpcArgsBuilder.result();
    }

    public ListMap<String, Object> errorLogs(Throwable e) {
        Builder m;
        block1: {
            Throwable throwable;
            block3: {
                block2: {
                    block0: {
                        m = ListMap$.MODULE$.newBuilder();
                        throwable = this.findCause$1(e);
                        if (throwable != null) break block0;
                        break block1;
                    }
                    if (!(throwable instanceof HttpServerException)) break block2;
                    HttpServerException httpServerException = (HttpServerException)throwable;
                    if (httpServerException.getCause() == null) break block1;
                    Throwable rootCause = this.findCause$1(httpServerException.getCause());
                    m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception_message"), (Object)rootCause.getMessage()));
                    m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)rootCause));
                    break block1;
                }
                if (!(throwable instanceof RPCException)) break block3;
                RPCException rPCException = (RPCException)throwable;
                m.$plus$plus$eq(this.rpcStatusLogs(rPCException.status()));
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception_message"), (Object)rPCException.getMessage()));
                if (!rPCException.shouldReportStackTrace()) break block1;
                m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)rPCException));
                break block1;
            }
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception_message"), (Object)throwable.getMessage()));
            m.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)throwable));
        }
        return (ListMap)m.result();
    }

    private String sanitize(String s) {
        return ((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(s)).map((Function1 & Serializable & scala.Serializable)x0$1 -> HttpLogs$.$anonfun$sanitize$1(BoxesRunTime.unboxToChar((Object)x0$1)), Predef$.MODULE$.fallbackStringCanBuildFrom())).mkString();
    }

    private scala.collection.concurrent.Map<String, String> headerSanitizeCache() {
        return this.headerSanitizeCache;
    }

    private String sanitizeHeader(String h) {
        return (String)this.headerSanitizeCache().getOrElseUpdate((Object)h, (Function0 & Serializable & scala.Serializable)() -> h.replaceAll("-", "_").toLowerCase());
    }

    public String extractQueryString(String uri) {
        int qPos = uri.indexOf(63);
        if (qPos < 0 || qPos == uri.length() - 1) {
            return "";
        }
        return uri.substring(qPos + 1, uri.length());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$commonResponseLogs$2(Builder m$2, String rpcStatus) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> RPCStatus$.MODULE$.ofCode(new StringOps(Predef$.MODULE$.augmentString(rpcStatus)).toInt())).foreach((Function1 & Serializable & scala.Serializable)status -> (Builder)m$2.$plus$plus$eq(MODULE$.rpcStatusLogs((RPCStatus)status)));
    }

    private static final ListMap traverseObject$1(Surface s, Object arg) {
        Builder builder = ListMap$.MODULE$.newBuilder();
        s.params().foreach((Function1 & Serializable & scala.Serializable)p -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Builder)builder.$plus$plus$eq((TraversableOnce)HttpLogs$.traverseParam$1(p, p.get(arg)))));
        return (ListMap)builder.result();
    }

    private static final ListMap traverseParam$1(Parameter p, Object arg) {
        Object object = arg;
        if (object instanceof HttpMessage.Request) {
            return ListMap$.MODULE$.empty();
        }
        String string = p.surface().fullName();
        String string2 = "com.twitter.finagle.http.Request";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof HttpContext) {
            return ListMap$.MODULE$.empty();
        }
        if (p.isSecret()) {
            return ListMap$.MODULE$.empty();
        }
        if (object instanceof ULID) {
            ULID uLID = (ULID)object;
            return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)uLID)}));
        }
        if (p.surface().params().length() > 0) {
            return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)HttpLogs$.traverseObject$1(p.surface(), arg))}));
        }
        return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), arg)}));
    }

    public static final /* synthetic */ boolean $anonfun$extractRpcArgLog$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private final Throwable findCause$1(Throwable e) {
        while (true) {
            ExecutionException executionException;
            Throwable throwable;
            if ((throwable = e) instanceof Exception) {
                Exception exception = (Exception)throwable;
                String string = exception.getClass().getName();
                String string2 = "java.lang.reflect.InvocationTargetException";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    e = exception.getCause();
                    continue;
                }
            }
            if (!(throwable instanceof ExecutionException) || (executionException = (ExecutionException)throwable).getCause() == null) break;
            e = executionException.getCause();
        }
        return e;
    }

    public static final /* synthetic */ Object $anonfun$sanitize$1(char x0$1) {
        char c = x0$1;
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return BoxesRunTime.boxToCharacter((char)c);
    }

    private HttpLogs$() {
        MODULE$ = this;
        LoggingMethods.$init$((LoggingMethods)this);
        LazyLogger.$init$((LazyLogger)this);
        this.headerSanitizeCache = (scala.collection.concurrent.Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
    }
}

