/*
 * Decompiled with CFR 0.152.
 */
package wvlet.log;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.concurrent.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import wvlet.log.ConsoleLogHandler;
import wvlet.log.ConsoleLogHandler$;
import wvlet.log.LogEnv$;
import wvlet.log.LogFormatter;
import wvlet.log.LogLevel;
import wvlet.log.LogLevel$;
import wvlet.log.LogLevel$INFO$;
import wvlet.log.Logger;

public final class Logger$
implements scala.Serializable {
    public static Logger$ MODULE$;
    private Map<String, Logger> loggerCache;
    private final Logger rootLogger;
    private volatile boolean bitmap$0;

    static {
        new Logger$();
    }

    private Map<String, Logger> loggerCache$lzycompute() {
        Logger$ logger$ = this;
        synchronized (logger$) {
            if (!this.bitmap$0) {
                this.loggerCache = (Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
                this.bitmap$0 = true;
            }
        }
        return this.loggerCache;
    }

    private Map<String, Logger> loggerCache() {
        return !this.bitmap$0 ? this.loggerCache$lzycompute() : this.loggerCache;
    }

    public Logger rootLogger() {
        return this.rootLogger;
    }

    public Logger initLogger(String name, Option<LogLevel> level, Seq<Handler> handlers, boolean useParents) {
        Logger logger = this.apply(name);
        logger.clearHandlers();
        level.foreach((Function1 & Serializable & scala.Serializable)l -> {
            logger.setLogLevel(l);
            return BoxedUnit.UNIT;
        });
        handlers.foreach((Function1 & Serializable & scala.Serializable)h -> {
            logger.addHandler(h);
            return BoxedUnit.UNIT;
        });
        logger.setUseParentHandlers(useParents);
        return logger;
    }

    public <A> Logger of(ClassTag<A> evidence$1) {
        return this.apply(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass().getName());
    }

    public Logger apply(String loggerName) {
        return (Logger)this.loggerCache().getOrElseUpdate((Object)loggerName, (Function0 & Serializable & scala.Serializable)() -> new Logger(loggerName, java.util.logging.Logger.getLogger(loggerName)));
    }

    public LogLevel getDefaultLogLevel() {
        return this.rootLogger().getLogLevel();
    }

    public void setDefaultLogLevel(LogLevel level) {
        this.rootLogger().setLogLevel(level);
    }

    public synchronized void setDefaultFormatter(LogFormatter formatter) {
        this.rootLogger().resetHandler(new ConsoleLogHandler(formatter, ConsoleLogHandler$.MODULE$.$lessinit$greater$default$2()));
    }

    public void setDefaultHandler(Handler handler) {
        this.rootLogger().resetHandler(handler);
    }

    public void resetDefaultLogLevel() {
        this.rootLogger().resetLogLevel();
    }

    public void clearAllHandlers() {
        this.rootLogger().clearAllHandlers();
    }

    public void init() {
        this.clearAllHandlers();
        this.resetDefaultLogLevel();
        this.rootLogger().resetHandler(LogEnv$.MODULE$.defaultHandler());
    }

    public Option<LogLevel> initLogger$default$2() {
        return None$.MODULE$;
    }

    public Seq<Handler> initLogger$default$3() {
        return (Seq)Nil$.MODULE$;
    }

    public boolean initLogger$default$4() {
        return true;
    }

    public void setLogLevels(Properties logLevels) {
        ((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(logLevels).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Logger$.$anonfun$setLogLevels$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Logger$.$anonfun$setLogLevels$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void scheduleLogLevelScan() {
        LogEnv$.MODULE$.scheduleLogLevelScan();
    }

    public void stopScheduledLogLevelScan() {
        LogEnv$.MODULE$.stopScheduledLogLevelScan();
    }

    public void scanLogLevels() {
        LogEnv$.MODULE$.scanLogLevels();
    }

    public void scanLogLevels(Seq<String> loglevelFileCandidates) {
        LogEnv$.MODULE$.scanLogLevels(loglevelFileCandidates);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$setLogLevels$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$setLogLevels$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String loggerName = (String)tuple2._1();
        String level = (String)tuple2._2();
        Option<LogLevel> option = LogLevel$.MODULE$.unapply(level);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            LogLevel lv = (LogLevel)some.value();
            String string = loggerName;
            String string2 = "_root_";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                MODULE$.rootLogger().setLogLevel(lv);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                MODULE$.apply(loggerName).setLogLevel(lv);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Console$.MODULE$.err().println(new StringBuilder(35).append("Unknown loglevel ").append(level).append(" is specified for ").append(loggerName).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    private Logger$() {
        void var1_5;
        MODULE$ = this;
        package$.MODULE$.props().put((Object)"java.util.logging.manager", (Object)"wvlet.log.AirframeLogManager");
        String x$1 = "";
        Seq x$2 = (Seq)new .colon.colon((Object)LogEnv$.MODULE$.defaultHandler(), (List)Nil$.MODULE$);
        Option<LogLevel> x$3 = this.initLogger$default$2();
        boolean x$4 = this.initLogger$default$4();
        Logger l = this.initLogger(x$1, x$3, (Seq<Handler>)x$2, x$4);
        if (LogEnv$.MODULE$.isScalaJS()) {
            l.setLogLevel(LogLevel$INFO$.MODULE$);
        }
        this.rootLogger = var1_5;
    }
}

